/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.request.RelationshipUR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.DynMembership;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Groupable;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.anyobject.ADynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.GRelationship;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.TypeExtension;
import org.apache.syncope.core.persistence.api.entity.user.UDynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.java.data.AnyDataBinder;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class GroupDataBinderImpl
extends AnyDataBinder
implements GroupDataBinder {
    protected final SearchCondVisitor searchCondVisitor;

    public GroupDataBinderImpl(AnyTypeDAO anyTypeDAO, RealmSearchDAO realmSearchDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, DerAttrHandler derAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, SearchCondVisitor searchCondVisitor, PlainAttrValidationManager validator) {
        super(anyTypeDAO, realmSearchDAO, anyTypeClassDAO, anyObjectDAO, userDAO, groupDAO, plainSchemaDAO, resourceDAO, relationshipTypeDAO, entityFactory, anyUtilsFactory, derAttrHandler, mappingManager, intAttrNameParser, outboundMatcher, validator);
        this.searchCondVisitor = searchCondVisitor;
    }

    protected void setDynMembership(Group group, AnyType anyType, String dynMembershipFIQL) {
        DynGroupMembership dynMembership;
        SearchCond dynMembershipCond = SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)dynMembershipFIQL, (String[])new String[0]);
        if (!dynMembershipCond.isValid()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchParameters);
            sce.getElements().add(dynMembershipFIQL);
            throw sce;
        }
        if (anyType.getKind() == AnyTypeKind.GROUP) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            sce.getElements().add(anyType.getKind().name());
            throw sce;
        }
        if (anyType.getKind() == AnyTypeKind.ANY_OBJECT && group.getADynMembership(anyType).isEmpty()) {
            dynMembership = (DynGroupMembership)this.entityFactory.newEntity(ADynGroupMembership.class);
            dynMembership.setGroup(group);
            ((ADynGroupMembership)dynMembership).setAnyType(anyType);
            group.add((ADynGroupMembership)dynMembership);
        } else if (anyType.getKind() == AnyTypeKind.USER && group.getUDynMembership() == null) {
            dynMembership = (DynGroupMembership)this.entityFactory.newEntity(UDynGroupMembership.class);
            dynMembership.setGroup(group);
            group.setUDynMembership((UDynGroupMembership)dynMembership);
        } else {
            dynMembership = anyType.getKind() == AnyTypeKind.ANY_OBJECT ? (DynGroupMembership)group.getADynMembership(anyType).get() : group.getUDynMembership();
        }
        dynMembership.setFIQLCond(dynMembershipFIQL);
    }

    public void create(Group group, GroupCR groupCR) {
        GroupTO anyTO = new GroupTO();
        EntityTOUtils.toAnyTO((AnyCR)groupCR, (AnyTO)anyTO);
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidGroups = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidGroup);
        if (groupCR.getName() == null) {
            LOG.error("No name specified for this group");
            invalidGroups.getElements().add("No name specified for this group");
        } else {
            group.setName(groupCR.getName());
        }
        Realm realm = this.realmSearchDAO.findByFullPath(groupCR.getRealm()).orElse(null);
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + groupCR.getRealm());
            scce.addException(noRealm);
        }
        group.setRealm(realm);
        this.fill((AnyTO)anyTO, (Any)group, (AnyCR)groupCR, this.anyUtilsFactory.getInstance(AnyTypeKind.GROUP), scce);
        if (groupCR.getUserOwner() != null) {
            this.userDAO.findById(groupCR.getUserOwner()).ifPresentOrElse(arg_0 -> ((Group)group).setUserOwner(arg_0), () -> LOG.warn("Ignoring invalid user specified as owner: {}", (Object)groupCR.getUserOwner()));
        }
        if (groupCR.getGroupOwner() != null) {
            this.groupDAO.findById(groupCR.getGroupOwner()).ifPresentOrElse(arg_0 -> ((Group)group).setGroupOwner(arg_0), () -> LOG.warn("Ignoring invalid group specified as owner: {}", (Object)groupCR.getGroupOwner()));
        }
        if (groupCR.getUDynMembershipCond() != null) {
            this.setDynMembership(group, this.anyTypeDAO.getUser(), groupCR.getUDynMembershipCond());
        }
        groupCR.getADynMembershipConds().forEach((type, fiql) -> this.anyTypeDAO.findById(type).ifPresentOrElse(anyType -> this.setDynMembership(group, (AnyType)anyType, (String)fiql), () -> LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), type)));
        groupCR.getTypeExtensions().forEach(typeExtTO -> this.anyTypeDAO.findById(typeExtTO.getAnyType()).ifPresentOrElse(anyType -> {
            TypeExtension typeExt = (TypeExtension)this.entityFactory.newEntity(TypeExtension.class);
            typeExt.setAnyType(anyType);
            typeExt.setGroup(group);
            group.add(typeExt);
            typeExtTO.getAuxClasses().forEach(name -> this.anyTypeClassDAO.findById(name).ifPresentOrElse(arg_0 -> ((TypeExtension)typeExt).add(arg_0), () -> LOG.warn("Ignoring invalid {}: {}", (Object)AnyTypeClass.class.getSimpleName(), name)));
            if (typeExt.getAuxClasses().isEmpty()) {
                group.getTypeExtensions().remove(typeExt);
                typeExt.setGroup(null);
            }
        }, () -> LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), (Object)typeExtTO.getAnyType())));
        HashSet relationships = new HashSet();
        groupCR.getRelationships().forEach(relationshipTO -> {
            AnyObject otherEnd = this.anyObjectDAO.findById(relationshipTO.getOtherEndKey()).orElse(null);
            if (otherEnd == null) {
                LOG.debug("Ignoring invalid anyObject {}", (Object)relationshipTO.getOtherEndKey());
            } else if (relationshipTO.getEnd() == RelationshipTO.End.RIGHT) {
                SyncopeClientException noRight = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                noRight.getElements().add("Relationships shall be created or updated only from their left end");
                scce.addException(noRight);
            } else if (relationships.contains(Pair.of((Object)otherEnd.getKey(), (Object)relationshipTO.getType()))) {
                SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                assigned.getElements().add(otherEnd.getType().getKey() + " " + otherEnd.getName() + " in relationship " + relationshipTO.getType());
                scce.addException(assigned);
            } else if (group.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                relationships.add(Pair.of((Object)otherEnd.getKey(), (Object)relationshipTO.getType()));
                this.relationshipTypeDAO.findById(relationshipTO.getType()).ifPresentOrElse(relationshipType -> {
                    GRelationship relationship = (GRelationship)this.entityFactory.newEntity(GRelationship.class);
                    relationship.setType(relationshipType);
                    relationship.setRightEnd((Any)otherEnd);
                    relationship.setLeftEnd((Any)group);
                    group.add((Relationship)relationship);
                }, () -> LOG.debug("Ignoring invalid relationship type {}", (Object)relationshipTO.getType()));
            } else {
                SyncopeClientException unrelatable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                unrelatable.getElements().add(otherEnd.getType().getKey() + " " + otherEnd.getName() + " cannot be related");
                scce.addException(unrelatable);
            }
        });
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public PropagationByResource<String> update(Group toBeUpdated, GroupUR groupUR) {
        AnyType anyType;
        Group group = (Group)this.groupDAO.save((Entity)toBeUpdated);
        GroupTO anyTO = AnyOperations.patch((GroupTO)this.getGroupTO(group, true), (GroupUR)groupUR);
        Map<String, ConnObject> beforeOnResources = this.onResources((Any)group, this.groupDAO.findAllResourceKeys(group.getKey()), null, Set.of());
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        this.setRealm((Any)group, (AnyUR)groupUR);
        if (groupUR.getName() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)groupUR.getName().getValue()))) {
            group.setName((String)groupUR.getName().getValue());
        }
        PropagationByResource ownerPropByRes = new PropagationByResource();
        if (groupUR.getUserOwner() != null) {
            if (groupUR.getUserOwner().getValue() == null) {
                if (group.getUserOwner() != null) {
                    group.setUserOwner(null);
                    ownerPropByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(group.getKey()));
                }
            } else {
                User userOwner = this.userDAO.findById((String)groupUR.getUserOwner().getValue()).orElse(null);
                if (userOwner == null) {
                    LOG.debug("Unable to find user owner for group {} by key {}", (Object)group.getKey(), groupUR.getUserOwner().getValue());
                    group.setUserOwner(null);
                } else {
                    group.setUserOwner(userOwner);
                    ownerPropByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(group.getKey()));
                }
            }
        }
        if (groupUR.getGroupOwner() != null) {
            if (groupUR.getGroupOwner().getValue() == null) {
                if (group.getGroupOwner() != null) {
                    group.setGroupOwner(null);
                    ownerPropByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(group.getKey()));
                }
            } else {
                Group groupOwner = this.groupDAO.findById((String)groupUR.getGroupOwner().getValue()).orElse(null);
                if (groupOwner == null) {
                    LOG.debug("Unable to find group owner for group {} by key {}", (Object)group.getKey(), groupUR.getGroupOwner().getValue());
                    group.setGroupOwner(null);
                } else {
                    group.setGroupOwner(groupOwner);
                    ownerPropByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(group.getKey()));
                }
            }
        }
        this.fill((AnyTO)anyTO, (Any)group, (AnyUR)groupUR, this.anyUtilsFactory.getInstance(AnyTypeKind.GROUP), scce);
        group = (Group)this.groupDAO.save((Entity)group);
        if (groupUR.getUDynMembershipCond() == null) {
            if (group.getUDynMembership() != null) {
                group.getUDynMembership().setGroup(null);
                group.setUDynMembership(null);
                this.groupDAO.clearUDynMembers(group);
            }
        } else {
            this.setDynMembership(group, this.anyTypeDAO.getUser(), groupUR.getUDynMembershipCond());
        }
        Iterator<Object> itor = group.getADynMemberships().iterator();
        while (itor.hasNext()) {
            ADynGroupMembership aDynGroupMembership = (ADynGroupMembership)itor.next();
            aDynGroupMembership.setGroup(null);
            itor.remove();
        }
        this.groupDAO.clearADynMembers(group);
        for (Map.Entry entry : groupUR.getADynMembershipConds().entrySet()) {
            anyType = this.anyTypeDAO.findById((String)entry.getKey()).orElse(null);
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), entry.getKey());
                continue;
            }
            this.setDynMembership(group, anyType, (String)entry.getValue());
        }
        group = this.groupDAO.saveAndRefreshDynMemberships(group);
        for (TypeExtensionTO typeExtensionTO : groupUR.getTypeExtensions()) {
            anyType = this.anyTypeDAO.findById(typeExtensionTO.getAnyType()).orElse(null);
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), (Object)typeExtensionTO.getAnyType());
                continue;
            }
            TypeExtension typeExt2 = group.getTypeExtension(anyType).orElse(null);
            if (typeExt2 == null) {
                typeExt2 = (TypeExtension)this.entityFactory.newEntity(TypeExtension.class);
                typeExt2.setAnyType(anyType);
                typeExt2.setGroup(group);
                group.add(typeExt2);
            }
            for (String key : typeExtensionTO.getAuxClasses()) {
                AnyTypeClass anyTypeClass2 = this.anyTypeClassDAO.findById(key).orElse(null);
                if (anyTypeClass2 == null) {
                    LOG.warn("Ignoring invalid {}: {}", (Object)AnyTypeClass.class.getSimpleName(), (Object)key);
                    continue;
                }
                typeExt2.add(anyTypeClass2);
            }
            typeExt2.getAuxClasses().removeIf(anyTypeClass -> !typeExtensionTO.getAuxClasses().contains(anyTypeClass.getKey()));
            if (!typeExt2.getAuxClasses().isEmpty()) continue;
            group.getTypeExtensions().remove(typeExt2);
            typeExt2.setGroup(null);
        }
        group.getTypeExtensions().removeIf(typeExt -> groupUR.getTypeExtension(typeExt.getAnyType().getKey()).isEmpty());
        HashSet<Pair> relationships = new HashSet<Pair>();
        for (RelationshipUR patch2 : groupUR.getRelationships().stream().filter(patch -> patch.getRelationshipTO() != null).toList()) {
            RelationshipType relationshipType = this.relationshipTypeDAO.findById(patch2.getRelationshipTO().getType()).orElse(null);
            if (relationshipType == null) {
                LOG.debug("Ignoring invalid relationship type {}", (Object)patch2.getRelationshipTO().getType());
                continue;
            }
            GRelationship relationship = group.getRelationship(relationshipType, patch2.getRelationshipTO().getOtherEndKey()).orElse(null);
            if (relationship != null) {
                group.getRelationships().remove(relationship);
                relationship.setLeftEnd(null);
            }
            if (patch2.getOperation() != PatchOperation.ADD_REPLACE) continue;
            AnyObject otherEnd = this.anyObjectDAO.findById(patch2.getRelationshipTO().getOtherEndKey()).orElse(null);
            if (otherEnd == null) {
                LOG.debug("Ignoring invalid any object {}", (Object)patch2.getRelationshipTO().getOtherEndKey());
                continue;
            }
            if (relationships.contains(Pair.of((Object)otherEnd.getKey(), (Object)patch2.getRelationshipTO().getType()))) {
                SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                assigned.getElements().add("Group was already in relationship " + patch2.getRelationshipTO().getType() + " with " + otherEnd.getType().getKey() + " " + otherEnd.getName());
                scce.addException(assigned);
                continue;
            }
            if (patch2.getRelationshipTO().getEnd() == RelationshipTO.End.RIGHT) {
                SyncopeClientException noRight = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                noRight.getElements().add("Relationships shall be created or updated only from their left end");
                scce.addException(noRight);
                continue;
            }
            if (group.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                relationships.add(Pair.of((Object)otherEnd.getKey(), (Object)patch2.getRelationshipTO().getType()));
                GRelationship newRelationship = (GRelationship)this.entityFactory.newEntity(GRelationship.class);
                newRelationship.setType(relationshipType);
                newRelationship.setRightEnd((Any)otherEnd);
                newRelationship.setLeftEnd((Any)group);
                group.add((Relationship)newRelationship);
                continue;
            }
            LOG.error("{} cannot be related to {}", (Object)otherEnd, (Object)group);
            SyncopeClientException unrelatable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
            unrelatable.getElements().add(otherEnd.getType().getKey() + " " + otherEnd.getName() + " cannot be related");
            scce.addException(unrelatable);
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
        group = (Group)this.groupDAO.save((Entity)group);
        PropagationByResource<String> propagationByResource = this.propByRes(beforeOnResources, this.onResources((Any)group, this.groupDAO.findAllResourceKeys(group.getKey()), null, Set.of()));
        propagationByResource.merge(ownerPropByRes);
        return propagationByResource;
    }

    public TypeExtensionTO getTypeExtensionTO(TypeExtension typeExt) {
        TypeExtensionTO typeExtTO = new TypeExtensionTO();
        typeExtTO.setAnyType(typeExt.getAnyType().getKey());
        typeExtTO.getAuxClasses().addAll(typeExt.getAuxClasses().stream().map(Entity::getKey).toList());
        return typeExtTO;
    }

    @Transactional(readOnly=true)
    public GroupTO getGroupTO(Group group, boolean details) {
        GroupTO groupTO = new GroupTO();
        groupTO.setKey(group.getKey());
        groupTO.setName(group.getName());
        groupTO.setStatus(group.getStatus());
        groupTO.setCreator(group.getCreator());
        groupTO.setCreationDate(group.getCreationDate());
        groupTO.setCreationContext(group.getCreationContext());
        groupTO.setLastModifier(group.getLastModifier());
        groupTO.setLastChangeDate(group.getLastChangeDate());
        groupTO.setLastChangeContext(group.getLastChangeContext());
        Optional.ofNullable(group.getUserOwner()).map(Entity::getKey).ifPresent(arg_0 -> ((GroupTO)groupTO).setUserOwner(arg_0));
        Optional.ofNullable(group.getGroupOwner()).map(Entity::getKey).ifPresent(arg_0 -> ((GroupTO)groupTO).setGroupOwner(arg_0));
        GroupDataBinderImpl.fillTO((AnyTO)groupTO, group.getRealm().getFullPath(), group.getAuxClasses(), group.getPlainAttrs(), this.derAttrHandler.getValues((Any)group), group.getResources());
        groupTO.getDynRealms().addAll(this.groupDAO.findDynRealms(group.getKey()));
        groupTO.setStaticUserMembershipCount(this.groupDAO.countUMembers(group.getKey()));
        groupTO.setStaticAnyObjectMembershipCount(this.groupDAO.countAMembers(group.getKey()));
        groupTO.setDynamicUserMembershipCount(this.groupDAO.countUDynMembers(group));
        groupTO.setDynamicAnyObjectMembershipCount(this.groupDAO.countADynMembers(group));
        Optional.ofNullable(group.getUDynMembership()).map(DynMembership::getFIQLCond).ifPresent(arg_0 -> ((GroupTO)groupTO).setUDynMembershipCond(arg_0));
        group.getADynMemberships().forEach(memb -> groupTO.getADynMembershipConds().put(memb.getAnyType().getKey(), memb.getFIQLCond()));
        group.getTypeExtensions().forEach(typeExt -> groupTO.getTypeExtensions().add(this.getTypeExtensionTO((TypeExtension)typeExt)));
        if (details) {
            groupTO.getRelationships().addAll(group.getRelationships().stream().map(r -> GroupDataBinderImpl.getRelationshipTO(r.getType().getKey(), RelationshipTO.End.LEFT, r.getRightEnd())).toList());
        }
        return groupTO;
    }

    @Transactional(readOnly=true)
    public GroupTO getGroupTO(String key) {
        return this.getGroupTO((Group)this.groupDAO.authFind(key), true);
    }

    protected static void populateTransitiveResources(Group group, Groupable<?, ?, ?, ?> any, Map<String, PropagationByResource<String>> result) {
        PropagationByResource propByRes = new PropagationByResource();
        group.getResources().forEach(resource -> {
            if (!any.getResources().contains(resource) && any.getMemberships().stream().filter(m -> !((Group)m.getRightEnd()).equals((Object)group)).noneMatch(m -> ((Group)m.getRightEnd()).getResources().contains(resource))) {
                propByRes.add(ResourceOperation.DELETE, (Serializable)((Object)resource.getKey()));
            }
            if (!propByRes.isEmpty()) {
                result.put(any.getKey(), propByRes);
            }
        });
    }

    @Transactional(readOnly=true)
    public Map<String, PropagationByResource<String>> findAnyObjectsWithTransitiveResources(String groupKey) {
        Group group = (Group)this.groupDAO.authFind(groupKey);
        HashMap<String, PropagationByResource<String>> result = new HashMap<String, PropagationByResource<String>>();
        this.groupDAO.findAMemberships(group).forEach(membership -> GroupDataBinderImpl.populateTransitiveResources(group, (Groupable)membership.getLeftEnd(), result));
        return result;
    }

    @Transactional(readOnly=true)
    public Map<String, PropagationByResource<String>> findUsersWithTransitiveResources(String groupKey) {
        Group group = (Group)this.groupDAO.authFind(groupKey);
        HashMap<String, PropagationByResource<String>> result = new HashMap<String, PropagationByResource<String>>();
        this.groupDAO.findUMemberships(group, Pageable.unpaged()).forEach(membership -> GroupDataBinderImpl.populateTransitiveResources(group, (Groupable)membership.getLeftEnd(), result));
        return result;
    }
}

