/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.AttrPatch;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Groupable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.URelationship;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.java.data.AnyDataBinder;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class UserDataBinderImpl
extends AnyDataBinder
implements UserDataBinder {
    protected final RoleDAO roleDAO;
    protected final SecurityQuestionDAO securityQuestionDAO;
    protected final AccessTokenDAO accessTokenDAO;
    protected final DelegationDAO delegationDAO;
    protected final ConfParamOps confParamOps;
    protected final SecurityProperties securityProperties;

    public UserDataBinderImpl(AnyTypeDAO anyTypeDAO, RealmSearchDAO realmSearchDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, DerAttrHandler derAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator, RoleDAO roleDAO, SecurityQuestionDAO securityQuestionDAO, AccessTokenDAO accessTokenDAO, DelegationDAO delegationDAO, ConfParamOps confParamOps, SecurityProperties securityProperties) {
        super(anyTypeDAO, realmSearchDAO, anyTypeClassDAO, anyObjectDAO, userDAO, groupDAO, plainSchemaDAO, resourceDAO, relationshipTypeDAO, entityFactory, anyUtilsFactory, derAttrHandler, mappingManager, intAttrNameParser, outboundMatcher, validator);
        this.roleDAO = roleDAO;
        this.securityQuestionDAO = securityQuestionDAO;
        this.accessTokenDAO = accessTokenDAO;
        this.delegationDAO = delegationDAO;
        this.confParamOps = confParamOps;
        this.securityProperties = securityProperties;
    }

    @Transactional(readOnly=true)
    public UserTO getAuthenticatedUserTO() {
        UserTO authUserTO;
        String authUsername = AuthContextUtils.getUsername();
        if (this.securityProperties.getAnonymousUser().equals(authUsername)) {
            authUserTO = new UserTO();
            authUserTO.setKey(null);
            authUserTO.setUsername(this.securityProperties.getAnonymousUser());
        } else if (this.securityProperties.getAdminUser().equals(authUsername)) {
            authUserTO = new UserTO();
            authUserTO.setKey(null);
            authUserTO.setUsername(this.securityProperties.getAdminUser());
        } else {
            User authUser = (User)this.userDAO.findByUsername(authUsername).orElseThrow(() -> new NotFoundException("User" + authUsername));
            authUserTO = this.getUserTO(authUser, true);
        }
        return authUserTO;
    }

    protected SyncopeClientException addToSyncopeClientException(SyncopeClientCompositeException scce, RuntimeException e) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.NotFound);
        sce.getElements().add(e.getMessage());
        scce.addException(sce);
        return scce;
    }

    protected void setPassword(User user, String password, SyncopeClientCompositeException scce) {
        try {
            this.setCipherAlgorithm(user);
            user.setPassword(password);
        }
        catch (IllegalArgumentException e) {
            throw this.addToSyncopeClientException(scce, e);
        }
    }

    protected void setSecurityAnswer(User user, String securityAnswer, SyncopeClientCompositeException scce) {
        try {
            this.setCipherAlgorithm(user);
            user.setSecurityAnswer(securityAnswer);
        }
        catch (IllegalArgumentException e) {
            throw this.addToSyncopeClientException(scce, e);
        }
    }

    protected void setCipherAlgorithm(User user) {
        if (user.getCipherAlgorithm() == null) {
            user.setCipherAlgorithm(CipherAlgorithm.valueOf((String)((String)this.confParamOps.get(AuthContextUtils.getDomain(), "password.cipher.algorithm", (Object)CipherAlgorithm.AES.name(), String.class))));
        }
    }

    protected void linkedAccount(UserTO anyTO, User user, LinkedAccountTO accountTO, SyncopeClientException invalidValues) {
        ExternalResource resource = this.resourceDAO.findById(accountTO.getResource()).orElse(null);
        if (resource == null) {
            LOG.debug("Ignoring invalid resource {}", (Object)accountTO.getResource());
            return;
        }
        LinkedAccount account = user.getLinkedAccount(resource.getKey(), accountTO.getConnObjectKeyValue()).map(LinkedAccount.class::cast).orElseGet(() -> {
            LinkedAccount acct = (LinkedAccount)this.entityFactory.newEntity(LinkedAccount.class);
            acct.setOwner(user);
            user.add(acct);
            acct.setConnObjectKeyValue(accountTO.getConnObjectKeyValue());
            acct.setResource(resource);
            return acct;
        });
        account.setUsername(accountTO.getUsername());
        if (StringUtils.isBlank((CharSequence)accountTO.getPassword())) {
            account.setEncodedPassword(null, null);
        } else if (!accountTO.getPassword().equals(account.getPassword())) {
            if (account.getCipherAlgorithm() == null) {
                account.setCipherAlgorithm(CipherAlgorithm.AES);
            }
            account.setPassword(accountTO.getPassword());
        }
        account.setSuspended(Boolean.valueOf(accountTO.isSuspended()));
        accountTO.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty()).forEach(attrTO -> this.getPlainSchema(attrTO.getSchema()).ifPresent(schema -> {
            PlainAttr attr = account.getPlainAttr(schema.getKey()).orElseGet(() -> {
                PlainAttr newAttr = new PlainAttr();
                newAttr.setPlainSchema(schema);
                return newAttr;
            });
            this.fillAttr((AttributableTO)anyTO, attrTO.getValues(), (PlainSchema)schema, attr, invalidValues);
            if (!attr.getValuesAsStrings().isEmpty()) {
                account.add(attr);
            }
        }));
    }

    public void create(User user, UserCR userCR) {
        UserTO anyTO = new UserTO();
        EntityTOUtils.toAnyTO((AnyCR)userCR, (AnyTO)anyTO);
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        user.setUsername(userCR.getUsername());
        if (StringUtils.isBlank((CharSequence)userCR.getPassword()) || !userCR.isStorePassword()) {
            LOG.debug("Password was not provided or not required to be stored");
        } else {
            this.setPassword(user, userCR.getPassword(), scce);
            user.setChangePwdDate(OffsetDateTime.now());
        }
        user.setMustChangePassword(userCR.isMustChangePassword());
        if (userCR.getSecurityQuestion() != null) {
            this.securityQuestionDAO.findById(userCR.getSecurityQuestion()).ifPresent(arg_0 -> ((User)user).setSecurityQuestion(arg_0));
        }
        this.setSecurityAnswer(user, userCR.getSecurityAnswer(), scce);
        userCR.getRoles().forEach(roleKey -> this.roleDAO.findById(roleKey).ifPresentOrElse(arg_0 -> ((User)user).add(arg_0), () -> LOG.warn("Ignoring unknown role with id {}", roleKey)));
        Realm realm = this.realmSearchDAO.findByFullPath(userCR.getRealm()).orElse(null);
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + userCR.getRealm());
            scce.addException(noRealm);
        }
        user.setRealm(realm);
        HashSet relationships = new HashSet();
        userCR.getRelationships().forEach(relationshipTO -> {
            AnyObject otherEnd = this.anyObjectDAO.findById(relationshipTO.getOtherEndKey()).orElse(null);
            if (otherEnd == null) {
                LOG.debug("Ignoring invalid anyObject {}", (Object)relationshipTO.getOtherEndKey());
            } else if (relationshipTO.getEnd() == RelationshipTO.End.RIGHT) {
                SyncopeClientException noRight = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                noRight.getElements().add("Relationships shall be created or updated only from their left end");
                scce.addException(noRight);
            } else if (relationships.contains(Pair.of((Object)otherEnd.getKey(), (Object)relationshipTO.getType()))) {
                SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                assigned.getElements().add(otherEnd.getType().getKey() + " " + otherEnd.getName() + " in relationship " + relationshipTO.getType());
                scce.addException(assigned);
            } else if (user.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                relationships.add(Pair.of((Object)otherEnd.getKey(), (Object)relationshipTO.getType()));
                this.relationshipTypeDAO.findById(relationshipTO.getType()).ifPresentOrElse(relationshipType -> {
                    URelationship relationship = (URelationship)this.entityFactory.newEntity(URelationship.class);
                    relationship.setType(relationshipType);
                    relationship.setRightEnd((Any)otherEnd);
                    relationship.setLeftEnd((Any)user);
                    user.add((Relationship)relationship);
                }, () -> LOG.debug("Ignoring invalid relationship type {}", (Object)relationshipTO.getType()));
            } else {
                SyncopeClientException unrelatable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                unrelatable.getElements().add(otherEnd.getType().getKey() + " " + otherEnd.getName() + " cannot be related");
                scce.addException(unrelatable);
            }
        });
        HashSet groups = new HashSet();
        userCR.getMemberships().forEach(membershipTO -> {
            Group group;
            Group group2 = group = membershipTO.getGroupKey() == null ? (Group)this.groupDAO.findByName(membershipTO.getGroupName()).orElse(null) : (Group)this.groupDAO.findById(membershipTO.getGroupKey()).orElse(null);
            if (group == null) {
                LOG.debug("Ignoring invalid group {}", (Object)(membershipTO.getGroupKey() + " / " + membershipTO.getGroupName()));
            } else if (groups.contains(group.getKey())) {
                LOG.error("{} was already assigned to {}", (Object)group, (Object)user);
                SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                assigned.getElements().add("Group " + group.getName() + " was already assigned");
                scce.addException(assigned);
            } else {
                groups.add(group.getKey());
                UMembership membership = (UMembership)this.entityFactory.newEntity(UMembership.class);
                membership.setRightEnd((Any)group);
                membership.setLeftEnd((Any)user);
                user.add((Membership)membership);
                this.fill((AnyTO)anyTO, (Any)user, (Membership<?>)membership, (MembershipTO)membershipTO, scce);
            }
        });
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        userCR.getLinkedAccounts().forEach(acct -> this.linkedAccount(anyTO, user, (LinkedAccountTO)acct, invalidValues));
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
        this.fill((AnyTO)anyTO, (Any)user, (AnyCR)userCR, this.anyUtilsFactory.getInstance(AnyTypeKind.USER), scce);
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    protected boolean isPasswordMapped(ExternalResource resource) {
        return resource.getProvisionByAnyType(AnyTypeKind.USER.name()).filter(provision -> provision.getMapping() != null).map(provision -> provision.getMapping().getItems().stream().anyMatch(Item::isPassword)).orElse(false);
    }

    public Pair<PropagationByResource<String>, PropagationByResource<Pair<String, String>>> update(User toBeUpdated, UserUR userUR) {
        User user = (User)this.userDAO.save((Entity)toBeUpdated);
        UserTO anyTO = AnyOperations.patch((UserTO)this.getUserTO(user, true), (UserUR)userUR);
        PropagationByResource propByRes = new PropagationByResource();
        PropagationByResource propByLinkedAccount = new PropagationByResource();
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(AnyTypeKind.USER);
        String password = null;
        HashSet<String> changePwdRes = new HashSet<String>();
        if (userUR.getPassword() != null) {
            if (userUR.getPassword().getOperation() == PatchOperation.DELETE) {
                user.setEncodedPassword(null, null);
                changePwdRes.addAll(userUR.getPassword().getResources());
            } else if (StringUtils.isNotBlank((CharSequence)((CharSequence)userUR.getPassword().getValue()))) {
                if (userUR.getPassword().isOnSyncope()) {
                    this.setPassword(user, (String)userUR.getPassword().getValue(), scce);
                    user.setChangePwdDate(OffsetDateTime.now());
                }
                password = (String)userUR.getPassword().getValue();
                changePwdRes.addAll(userUR.getPassword().getResources());
            }
            if (!changePwdRes.isEmpty()) {
                propByRes.addAll(ResourceOperation.UPDATE, (Collection)userUR.getPassword().getResources());
            }
        }
        Map<String, ConnObject> beforeOnResources = this.onResources((Any)user, this.userDAO.findAllResourceKeys(user.getKey()), password, changePwdRes);
        this.setRealm((Any)user, (AnyUR)userUR);
        if (userUR.getUsername() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)userUR.getUsername().getValue()))) {
            String oldUsername = user.getUsername();
            user.setUsername((String)userUR.getUsername().getValue());
            if (oldUsername.equals(AuthContextUtils.getUsername())) {
                AuthContextUtils.updateUsername((String)((String)userUR.getUsername().getValue()));
            }
            this.accessTokenDAO.findByOwner(oldUsername).ifPresent(accessToken -> {
                accessToken.setOwner((String)userUR.getUsername().getValue());
                this.accessTokenDAO.save((Entity)accessToken);
            });
        }
        if (userUR.getSecurityQuestion() != null) {
            if (userUR.getSecurityQuestion().getValue() == null) {
                user.setSecurityQuestion(null);
                user.setSecurityAnswer(null);
            } else {
                this.securityQuestionDAO.findById((String)userUR.getSecurityQuestion().getValue()).ifPresent(securityQuestion -> {
                    user.setSecurityQuestion(securityQuestion);
                    this.setSecurityAnswer(user, (String)userUR.getSecurityAnswer().getValue(), scce);
                });
            }
        }
        for (StringPatchItem patch2 : userUR.getRoles()) {
            this.roleDAO.findById((String)patch2.getValue()).ifPresentOrElse(role -> {
                switch (patch2.getOperation()) {
                    case ADD_REPLACE: {
                        user.add(role);
                        break;
                    }
                    default: {
                        user.getRoles().remove(role);
                    }
                }
            }, () -> LOG.warn("Ignoring unknown role with key {}", patch2.getValue()));
        }
        this.fill((AnyTO)anyTO, (Any)user, (AnyUR)userUR, anyUtils, scce);
        HashSet relationships = new HashSet();
        userUR.getRelationships().stream().filter(patch -> patch.getRelationshipTO() != null).forEach(patch -> {
            RelationshipType relationshipType = this.relationshipTypeDAO.findById(patch.getRelationshipTO().getType()).orElse(null);
            if (relationshipType == null) {
                LOG.debug("Ignoring invalid relationship type {}", (Object)patch.getRelationshipTO().getType());
            } else {
                user.getRelationship(relationshipType, patch.getRelationshipTO().getOtherEndKey()).ifPresent(relationship -> {
                    user.getRelationships().remove(relationship);
                    relationship.setLeftEnd(null);
                });
                if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                    AnyObject otherEnd = this.anyObjectDAO.findById(patch.getRelationshipTO().getOtherEndKey()).orElse(null);
                    if (otherEnd == null) {
                        LOG.debug("Ignoring invalid any object {}", (Object)patch.getRelationshipTO().getOtherEndKey());
                    } else if (relationships.contains(Pair.of((Object)otherEnd.getKey(), (Object)patch.getRelationshipTO().getType()))) {
                        SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                        assigned.getElements().add("User was already in relationship " + patch.getRelationshipTO().getType() + " with " + otherEnd.getType().getKey() + " " + otherEnd.getName());
                        scce.addException(assigned);
                    } else if (patch.getRelationshipTO().getEnd() == RelationshipTO.End.RIGHT) {
                        SyncopeClientException noRight = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                        noRight.getElements().add("Relationships shall be created or updated only from their left end");
                        scce.addException(noRight);
                    } else if (user.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                        relationships.add(Pair.of((Object)otherEnd.getKey(), (Object)patch.getRelationshipTO().getType()));
                        URelationship newRelationship = (URelationship)this.entityFactory.newEntity(URelationship.class);
                        newRelationship.setType(relationshipType);
                        newRelationship.setRightEnd((Any)otherEnd);
                        newRelationship.setLeftEnd((Any)user);
                        user.add((Relationship)newRelationship);
                    } else {
                        LOG.error("{} cannot be related to {}", (Object)otherEnd, (Object)user);
                        SyncopeClientException unrelatable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                        unrelatable.getElements().add(otherEnd.getType().getKey() + " " + otherEnd.getName() + " cannot be related");
                        scce.addException(unrelatable);
                    }
                }
            }
        });
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        HashSet groups = new HashSet();
        userUR.getMemberships().stream().filter(patch -> patch.getGroup() != null).forEach(patch -> {
            user.getMembership(patch.getGroup()).ifPresent(membership -> {
                user.remove((Membership)membership);
                membership.setLeftEnd(null);
                user.getPlainAttrs((Membership)membership).forEach(arg_0 -> ((User)user).remove(arg_0));
                this.userDAO.deleteMembership(membership);
                if (patch.getOperation() == PatchOperation.DELETE) {
                    propByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(((Group)membership.getRightEnd()).getKey()));
                }
            });
            if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                Group group = this.groupDAO.findById(patch.getGroup()).orElse(null);
                if (group == null) {
                    LOG.debug("Ignoring invalid group {}", (Object)patch.getGroup());
                } else if (groups.contains(group.getKey())) {
                    LOG.error("Multiple patches for group {} of {} were found", (Object)group, (Object)user);
                    SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                    assigned.getElements().add("Multiple patches for group " + group.getName() + " were found");
                    scce.addException(assigned);
                } else {
                    groups.add(group.getKey());
                    UMembership newMembership = (UMembership)this.entityFactory.newEntity(UMembership.class);
                    newMembership.setRightEnd((Any)group);
                    newMembership.setLeftEnd((Any)user);
                    user.add((Membership)newMembership);
                    patch.getPlainAttrs().forEach(attrTO -> this.getPlainSchema(attrTO.getSchema()).ifPresentOrElse(schema -> user.getPlainAttr(schema.getKey(), (Membership)newMembership).ifPresentOrElse(attr -> LOG.debug("Plain attribute found for {} and membership of {}, nothing to do", schema, (Object)newMembership.getRightEnd()), () -> {
                        LOG.debug("No plain attribute found for {} and membership of {}", schema, (Object)newMembership.getRightEnd());
                        PlainAttr newAttr = new PlainAttr();
                        newAttr.setMembership(newMembership.getKey());
                        newAttr.setPlainSchema(schema);
                        user.add(newAttr);
                        this.processAttrPatch((AnyTO)anyTO, (Any)user, (AttrPatch)new AttrPatch.Builder(attrTO).build(), (PlainSchema)schema, newAttr, invalidValues);
                    }), () -> LOG.debug("Invalid {}{}, ignoring...", (Object)PlainSchema.class.getSimpleName(), (Object)attrTO.getSchema())));
                    if (!invalidValues.isEmpty()) {
                        scce.addException(invalidValues);
                    }
                    propByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(group.getKey()));
                    if (toBeUpdated.canDecodeSecrets()) {
                        if (userUR.getPassword() == null) {
                            userUR.setPassword(new PasswordPatch());
                        }
                        group.getResources().stream().filter(this::isPasswordMapped).forEach(resource -> userUR.getPassword().getResources().add(resource.getKey()));
                    }
                }
            }
        });
        userUR.getLinkedAccounts().stream().filter(patch -> patch.getLinkedAccountTO() != null).forEach(patch -> {
            user.getLinkedAccount(patch.getLinkedAccountTO().getResource(), patch.getLinkedAccountTO().getConnObjectKeyValue()).ifPresent(account -> {
                if (patch.getOperation() == PatchOperation.DELETE) {
                    user.getLinkedAccounts().remove(account);
                    account.setOwner(null);
                    propByLinkedAccount.add(ResourceOperation.DELETE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue()));
                }
                new HashSet(account.getPlainAttrs()).forEach(arg_0 -> ((LinkedAccount)account).remove(arg_0));
            });
            if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                this.linkedAccount(anyTO, user, patch.getLinkedAccountTO(), invalidValues);
            }
        });
        user.getLinkedAccounts().forEach(account -> propByLinkedAccount.add(ResourceOperation.CREATE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue())));
        if (scce.hasExceptions()) {
            throw scce;
        }
        User saved = (User)this.userDAO.save((Entity)user);
        Map<String, ConnObject> afterOnResources = this.onResources((Any)user, this.userDAO.findAllResourceKeys(user.getKey()), password, changePwdRes);
        propByRes.merge(this.propByRes(beforeOnResources, afterOnResources));
        if (userUR.getMustChangePassword() != null) {
            user.setMustChangePassword(((Boolean)userUR.getMustChangePassword().getValue()).booleanValue());
            propByRes.addAll(ResourceOperation.UPDATE, anyUtils.getAllResources((Any)saved).stream().map(resource -> resource.getProvisionByAnyType(saved.getType().getKey()).filter(arg_0 -> ((MappingManager)this.mappingManager).hasMustChangePassword(arg_0)).map(provision -> resource.getKey()).orElse(null)).filter(Objects::nonNull).toList());
        }
        return Pair.of((Object)propByRes, (Object)propByLinkedAccount);
    }

    protected LinkedAccountTO getLinkedAccountTO(LinkedAccount account, boolean returnPasswordValue) {
        LinkedAccountTO accountTO = new LinkedAccountTO.Builder(account.getKey(), account.getResource().getKey(), account.getConnObjectKeyValue()).username(account.getUsername()).password(returnPasswordValue ? account.getPassword() : null).suspended(BooleanUtils.isTrue((Boolean)account.isSuspended())).build();
        account.getPlainAttrs().forEach(plainAttr -> accountTO.getPlainAttrs().add(new Attr.Builder(plainAttr.getSchema()).values((Collection)plainAttr.getValuesAsStrings()).build()));
        return accountTO;
    }

    @Transactional(readOnly=true)
    public LinkedAccountTO getLinkedAccountTO(LinkedAccount account) {
        return this.getLinkedAccountTO(account, true);
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(User user, boolean details) {
        Boolean returnPasswordValue = (Boolean)this.confParamOps.get(AuthContextUtils.getDomain(), "return.password.value", (Object)Boolean.FALSE, Boolean.class);
        UserTO userTO = new UserTO();
        userTO.setKey(user.getKey());
        userTO.setUsername(user.getUsername());
        userTO.setStatus(user.getStatus());
        userTO.setSuspended(BooleanUtils.isTrue((Boolean)user.isSuspended()));
        userTO.setMustChangePassword(user.isMustChangePassword());
        if (returnPasswordValue.booleanValue()) {
            userTO.setPassword(user.getPassword());
            userTO.setSecurityAnswer(user.getSecurityAnswer());
        }
        Optional.ofNullable(user.getSecurityQuestion()).map(Entity::getKey).ifPresent(arg_0 -> ((UserTO)userTO).setSecurityQuestion(arg_0));
        userTO.setCreationDate(user.getCreationDate());
        userTO.setCreator(user.getCreator());
        userTO.setCreationDate(user.getCreationDate());
        userTO.setCreationContext(user.getCreationContext());
        userTO.setLastModifier(user.getLastModifier());
        userTO.setLastChangeDate(user.getLastChangeDate());
        userTO.setLastChangeContext(user.getLastChangeContext());
        userTO.setChangePwdDate(user.getChangePwdDate());
        userTO.setFailedLogins(user.getFailedLogins());
        userTO.setLastLoginDate(user.getLastLoginDate());
        userTO.setToken(user.getToken());
        userTO.setTokenExpireTime(user.getTokenExpireTime());
        UserDataBinderImpl.fillTO((AnyTO)userTO, user.getRealm().getFullPath(), user.getAuxClasses(), user.getPlainAttrs(), this.derAttrHandler.getValues((Any)user), this.userDAO.findAllResources(user));
        userTO.getDynRealms().addAll(this.userDAO.findDynRealms(user.getKey()));
        if (details) {
            userTO.getRoles().addAll(user.getRoles().stream().map(Entity::getKey).toList());
            userTO.getDynRoles().addAll(this.userDAO.findDynRoles(user.getKey()).stream().map(Entity::getKey).toList());
            userTO.getRelationships().addAll(user.getRelationships().stream().map(r -> UserDataBinderImpl.getRelationshipTO(r.getType().getKey(), RelationshipTO.End.LEFT, r.getRightEnd())).toList());
            userTO.getMemberships().addAll(user.getMemberships().stream().map(membership -> UserDataBinderImpl.getMembershipTO(user.getPlainAttrs((Membership)membership), this.derAttrHandler.getValues((Groupable)user, (Membership)membership), (Membership<? extends Any>)membership)).toList());
            userTO.getDynMemberships().addAll(this.userDAO.findDynGroups(user.getKey()).stream().map(group -> new MembershipTO.Builder(group.getKey()).groupName(group.getName()).build()).toList());
            userTO.getLinkedAccounts().addAll(user.getLinkedAccounts().stream().map(account -> this.getLinkedAccountTO((LinkedAccount)account, returnPasswordValue)).toList());
            userTO.getDelegatingDelegations().addAll(this.delegationDAO.findByDelegating(user).stream().map(Entity::getKey).toList());
            userTO.getDelegatedDelegations().addAll(this.delegationDAO.findByDelegated(user).stream().map(Entity::getKey).toList());
        }
        return userTO;
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(String key) {
        return this.getUserTO((User)this.userDAO.authFind(key), true);
    }
}

