/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.newrelic;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.newrelic.ClientProviderType;
import io.micrometer.newrelic.NewRelicClientProvider;
import io.micrometer.newrelic.NewRelicConfig;
import io.micrometer.newrelic.NewRelicInsightsAgentClientProvider;
import io.micrometer.newrelic.NewRelicInsightsApiClientProvider;
import io.micrometer.newrelic.NewRelicNamingConvention;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NewRelicMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("new-relic-metrics-publisher");
    final NewRelicClientProvider clientProvider;
    private final MeterRegistry.Config thisConfig;

    public NewRelicMeterRegistry(NewRelicConfig config, Clock clock) {
        this(config, null, clock);
    }

    public NewRelicMeterRegistry(NewRelicConfig config, @Nullable NewRelicClientProvider clientProvider, Clock clock) {
        this(config, clientProvider, new NewRelicNamingConvention(), clock, DEFAULT_THREAD_FACTORY);
    }

    NewRelicMeterRegistry(NewRelicConfig config, @Nullable NewRelicClientProvider clientProvider, NamingConvention namingConvention, Clock clock, ThreadFactory threadFactory) {
        super((StepRegistryConfig)config, clock);
        if (clientProvider == null) {
            clientProvider = config.clientProviderType() == ClientProviderType.INSIGHTS_AGENT ? new NewRelicInsightsAgentClientProvider(config) : new NewRelicInsightsApiClientProvider(config);
        }
        this.clientProvider = clientProvider;
        this.thisConfig = new MeterRegistry.Config(){

            public MeterRegistry.Config namingConvention(NamingConvention convention) {
                NewRelicMeterRegistry.this.clientProvider.setNamingConvention(convention);
                return super.namingConvention(convention);
            }
        };
        this.config().namingConvention(namingConvention);
        this.start(threadFactory);
    }

    public MeterRegistry.Config config() {
        return this.thisConfig;
    }

    public static Builder builder(NewRelicConfig config) {
        return new Builder(config);
    }

    protected void publish() {
        this.clientProvider.publish(this);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    static /* synthetic */ ThreadFactory access$000() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final NewRelicConfig config;
        @Nullable
        private NewRelicClientProvider clientProvider;
        private NamingConvention convention = new NewRelicNamingConvention();
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = NewRelicMeterRegistry.access$000();
        @Nullable
        private HttpSender httpClient;

        Builder(NewRelicConfig config) {
            this.config = config;
        }

        public Builder clientProvider(NewRelicClientProvider clientProvider) {
            this.clientProvider = clientProvider;
            return this;
        }

        public Builder namingConvention(NamingConvention convention) {
            this.convention = convention;
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        @Deprecated
        public Builder httpClient(HttpSender httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public NewRelicMeterRegistry build() {
            if (this.httpClient != null) {
                if (this.clientProvider != null) {
                    throw new IllegalStateException("Please remove httpClient() configuration as it has been deprecated in favour of clientProvider().");
                }
                this.clientProvider = new NewRelicInsightsApiClientProvider(this.config, this.httpClient, this.convention);
            }
            return new NewRelicMeterRegistry(this.config, this.clientProvider, this.convention, this.clock, this.threadFactory);
        }
    }
}

