/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.operations.UpdateApiOp;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorAPIOperationRunner;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.GetImpl;
import org.identityconnectors.framework.impl.api.local.operations.ObjectNormalizerFacade;
import org.identityconnectors.framework.impl.api.local.operations.SearchImpl;
import org.identityconnectors.framework.impl.api.local.operations.SpiOperationLoggingUtil;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.UpdateAttributeValuesOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

public class UpdateImpl
extends ConnectorAPIOperationRunner
implements UpdateApiOp {
    private static final Log OP_LOG = Log.getLog(UpdateOp.class);
    private static final Set<String> OPERATIONAL_ATTRIBUTE_NAMES = new HashSet<String>();
    private static final String OPERATIONAL_ATTRIBUTE_ERR = "Operational attribute '%s' can not be added or removed.";

    public UpdateImpl(ConnectorOperationalContext context, Connector connector) {
        super(context, connector);
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        Uid ret;
        UpdateImpl.validateInput(objectClass, uid, replaceAttributes, false);
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        ObjectNormalizerFacade normalizer = this.getNormalizer(objectClass);
        uid = (Uid)normalizer.normalizeAttribute((Attribute)uid);
        replaceAttributes = normalizer.normalizeAttributes(replaceAttributes);
        UpdateOp op = (UpdateOp)this.getConnector();
        this.logOpEntry("update", objectClass, uid, replaceAttributes, options);
        try {
            ret = op.update(objectClass, uid, replaceAttributes, options);
        }
        catch (RuntimeException e) {
            SpiOperationLoggingUtil.logOpException(OP_LOG, this.getOperationalContext(), UpdateOp.class, "update", e);
            throw e;
        }
        this.logOpExit("update", ret);
        return (Uid)normalizer.normalizeAttribute((Attribute)ret);
    }

    public Uid addAttributeValues(ObjectClass objclass, Uid uid, Set<Attribute> valuesToAdd, OperationOptions options) {
        Uid ret;
        UpdateImpl.validateInput(objclass, uid, valuesToAdd, true);
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        ObjectNormalizerFacade normalizer = this.getNormalizer(objclass);
        uid = (Uid)normalizer.normalizeAttribute((Attribute)uid);
        valuesToAdd = normalizer.normalizeAttributes(valuesToAdd);
        UpdateOp op = (UpdateOp)this.getConnector();
        if (op instanceof UpdateAttributeValuesOp) {
            UpdateAttributeValuesOp valueOp = (UpdateAttributeValuesOp)op;
            this.logOpEntry("addAttributeValues", objclass, uid, valuesToAdd, options);
            try {
                ret = valueOp.addAttributeValues(objclass, uid, valuesToAdd, options);
            }
            catch (RuntimeException e) {
                this.logOpException("addAttributeValues", e);
                throw e;
            }
            this.logOpExit("addAttributeValues", ret);
        } else {
            Set<Attribute> replaceAttributes = this.fetchAndMerge(objclass, uid, valuesToAdd, true, options);
            this.logOpEntry("update", objclass, uid, replaceAttributes, options);
            try {
                ret = op.update(objclass, uid, replaceAttributes, options);
            }
            catch (RuntimeException e) {
                this.logOpException("update", e);
                throw e;
            }
            this.logOpExit("update", ret);
        }
        return (Uid)normalizer.normalizeAttribute((Attribute)ret);
    }

    public Uid removeAttributeValues(ObjectClass objclass, Uid uid, Set<Attribute> valuesToRemove, OperationOptions options) {
        Uid ret;
        UpdateImpl.validateInput(objclass, uid, valuesToRemove, true);
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        ObjectNormalizerFacade normalizer = this.getNormalizer(objclass);
        uid = (Uid)normalizer.normalizeAttribute((Attribute)uid);
        valuesToRemove = normalizer.normalizeAttributes(valuesToRemove);
        UpdateOp op = (UpdateOp)this.getConnector();
        if (op instanceof UpdateAttributeValuesOp) {
            UpdateAttributeValuesOp valueOp = (UpdateAttributeValuesOp)op;
            this.logOpEntry("removeAttributeValues", objclass, uid, valuesToRemove, options);
            try {
                ret = valueOp.removeAttributeValues(objclass, uid, valuesToRemove, options);
            }
            catch (RuntimeException e) {
                this.logOpException("removeAttributeValues", e);
                throw e;
            }
            this.logOpExit("removeAttributeValues", ret);
        } else {
            Set<Attribute> replaceAttributes = this.fetchAndMerge(objclass, uid, valuesToRemove, false, options);
            this.logOpEntry("update", objclass, uid, replaceAttributes, options);
            try {
                ret = op.update(objclass, uid, replaceAttributes, options);
            }
            catch (RuntimeException e) {
                this.logOpException("update", e);
                throw e;
            }
            this.logOpExit("update", ret);
        }
        return (Uid)normalizer.normalizeAttribute((Attribute)ret);
    }

    private Set<Attribute> fetchAndMerge(ObjectClass objclass, Uid uid, Set<Attribute> valuesToChange, boolean add, OperationOptions options) {
        if (!(this.getConnector() instanceof SearchOp)) {
            throw new UnsupportedOperationException("Connector must support: " + SearchOp.class);
        }
        OperationOptionsBuilder builder = new OperationOptionsBuilder(options);
        HashSet attrNames = new HashSet();
        valuesToChange.forEach(attribute -> attrNames.add(attribute.getName()));
        builder.setAttributesToGet(attrNames);
        options = builder.build();
        ConnectorObject o = this.getConnectorObject(objclass, uid, options);
        if (o == null) {
            throw new UnknownUidException(uid, objclass);
        }
        Set<Attribute> mergeAttrs = this.merge(valuesToChange, o.getAttributes(), add);
        return mergeAttrs;
    }

    public Set<Attribute> merge(Set<Attribute> updateAttrs, Set<Attribute> baseAttrs, boolean add) {
        HashSet<Attribute> ret = new HashSet<Attribute>();
        Map baseAttrMap = AttributeUtil.toMap(baseAttrs);
        for (Attribute updateAttr : updateAttrs) {
            List values;
            Attribute modifiedAttr;
            String name = updateAttr.getName();
            Attribute baseAttr = (Attribute)baseAttrMap.get(name);
            if (add) {
                if (baseAttr == null) {
                    modifiedAttr = updateAttr;
                } else {
                    values = CollectionUtil.newList((Collection)baseAttr.getValue());
                    values.addAll(updateAttr.getValue());
                    modifiedAttr = AttributeBuilder.build((String)name, (Collection)values);
                }
            } else {
                if (baseAttr == null) continue;
                values = CollectionUtil.newList((Collection)baseAttr.getValue());
                updateAttr.getValue().forEach(val -> values.remove(val));
                modifiedAttr = values.isEmpty() ? AttributeBuilder.build((String)name) : AttributeBuilder.build((String)name, (Collection)values);
            }
            ret.add(modifiedAttr);
        }
        return ret;
    }

    private ConnectorObject getConnectorObject(ObjectClass oclass, Uid uid, OperationOptions options) {
        GetImpl get = new GetImpl(new SearchImpl(this.getOperationalContext(), this.getConnector()));
        return get.getObject(oclass, uid, options);
    }

    public static void validateInput(ObjectClass objectClass, Uid uid, Set<Attribute> replaceAttributes, boolean isDelta) {
        Assertions.nullCheck((Object)uid, (String)"uid");
        Assertions.nullCheck((Object)objectClass, (String)"objectClass");
        if (ObjectClass.ALL.equals((Object)objectClass)) {
            throw new UnsupportedOperationException("Operation is not allowed on __ALL__ object class");
        }
        Assertions.nullCheck(replaceAttributes, (String)"replaceAttributes");
        if (AttributeUtil.getUidAttribute(replaceAttributes) != null) {
            throw new InvalidAttributeValueException("Parameter 'replaceAttributes' contains a uid.");
        }
        if (isDelta) {
            replaceAttributes.forEach(attr -> {
                Assertions.nullCheck((Object)attr, (String)"replaceAttributes");
                if (attr.getValue() == null) {
                    throw new IllegalArgumentException("Can not add or remove a 'null' value.");
                }
                String name = attr.getName();
                if (OPERATIONAL_ATTRIBUTE_NAMES.contains(name)) {
                    String msg = String.format(OPERATIONAL_ATTRIBUTE_ERR, name);
                    throw new IllegalArgumentException(msg);
                }
            });
        }
    }

    private void logOpEntry(String opName, ObjectClass objectClass, Uid uid, Set<Attribute> attrs, OperationOptions options) {
        SpiOperationLoggingUtil.logOpEntry(OP_LOG, this.getOperationalContext(), UpdateOp.class, opName, objectClass, uid, attrs, options);
    }

    private void logOpExit(String opName, Uid uid) {
        SpiOperationLoggingUtil.logOpExit(OP_LOG, this.getOperationalContext(), UpdateOp.class, opName, uid);
    }

    private void logOpException(String opName, RuntimeException e) {
        SpiOperationLoggingUtil.logOpException(OP_LOG, this.getOperationalContext(), UpdateOp.class, opName, e);
    }

    static {
        OPERATIONAL_ATTRIBUTE_NAMES.addAll(OperationalAttributes.getOperationalAttributeNames());
        OPERATIONAL_ATTRIBUTE_NAMES.add(Name.NAME);
    }
}

