/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.resultset.common;

import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.common.CostCachingResultSet;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ResultSets {
    public static <O> Collection<O> asCollection(final ResultSet<O> resultSet) {
        return new AbstractCollection<O>(){

            @Override
            public Iterator<O> iterator() {
                return resultSet.iterator();
            }

            @Override
            public int size() {
                return resultSet.size();
            }

            @Override
            public boolean contains(Object o) {
                Object object = o;
                return resultSet.contains(object);
            }

            @Override
            public boolean isEmpty() {
                return resultSet.isEmpty();
            }
        };
    }

    public static <O> List<ResultSet<O>> wrapWithCostCachingIfNecessary(Iterable<? extends ResultSet<O>> resultSets) {
        LinkedList<ResultSet<O>> result = new LinkedList<ResultSet<O>>();
        for (ResultSet<O> candidate : resultSets) {
            result.add(ResultSets.wrapWithCostCachingIfNecessary(candidate));
        }
        return result;
    }

    public static <O> ResultSet<O> wrapWithCostCachingIfNecessary(ResultSet<O> resultSet) {
        return resultSet instanceof CostCachingResultSet ? resultSet : new CostCachingResultSet(resultSet);
    }

    ResultSets() {
    }
}

