/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.resultset.connective;

import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.common.ResultSets;
import com.googlecode.cqengine.resultset.filter.FilteringIterator;
import com.googlecode.cqengine.resultset.iterator.ConcatenatingIterator;
import com.googlecode.cqengine.resultset.iterator.IteratorUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ResultSetUnion<O>
extends ResultSet<O> {
    final Query<O> query;
    final Iterable<? extends ResultSet<O>> resultSets;
    final QueryOptions queryOptions;
    final boolean useIndexMergeStrategy;

    public ResultSetUnion(Iterable<? extends ResultSet<O>> resultSets, Query<O> query, QueryOptions queryOptions) {
        this(resultSets, query, queryOptions, false);
    }

    public ResultSetUnion(Iterable<? extends ResultSet<O>> resultSets, Query<O> query, QueryOptions queryOptions, boolean useIndexMergeStrategy) {
        List costCachingResultSets = ResultSets.wrapWithCostCachingIfNecessary(resultSets);
        this.resultSets = costCachingResultSets;
        this.query = query;
        this.queryOptions = queryOptions;
        this.useIndexMergeStrategy = useIndexMergeStrategy;
    }

    @Override
    public Iterator<O> iterator() {
        final ArrayList resultSetsAlreadyIterated = new ArrayList();
        ConcatenatingIterator unionAllIterator = new ConcatenatingIterator<O>(){
            private Iterator<? extends ResultSet<O>> resultSetsIterator;
            private ResultSet<O> currentResultSet;
            {
                this.resultSetsIterator = ResultSetUnion.this.resultSets.iterator();
                this.currentResultSet = null;
            }

            @Override
            public Iterator<O> getNextIterator() {
                if (this.currentResultSet != null) {
                    resultSetsAlreadyIterated.add(this.currentResultSet);
                }
                if (this.resultSetsIterator.hasNext()) {
                    this.currentResultSet = this.resultSetsIterator.next();
                    return this.currentResultSet.iterator();
                }
                this.currentResultSet = null;
                return null;
            }
        };
        if (this.useIndexMergeStrategy) {
            return new FilteringIterator<O>(unionAllIterator, this.queryOptions){

                @Override
                public boolean isValid(O object, QueryOptions queryOptions) {
                    for (ResultSet resultSet : resultSetsAlreadyIterated) {
                        if (!resultSet.contains(object)) continue;
                        return false;
                    }
                    return true;
                }
            };
        }
        return new FilteringIterator<O>(unionAllIterator, this.queryOptions){

            @Override
            public boolean isValid(O object, QueryOptions queryOptions) {
                for (ResultSet resultSet : resultSetsAlreadyIterated) {
                    if (!resultSet.matches(object)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public boolean contains(O object) {
        for (ResultSet<O> resultSet : this.resultSets) {
            if (!resultSet.contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(O object) {
        return this.query.matches(object, this.queryOptions);
    }

    @Override
    public int size() {
        return IteratorUtil.countElements(this);
    }

    @Override
    public int getRetrievalCost() {
        long retrievalCost = 0L;
        for (ResultSet<O> resultSet : this.resultSets) {
            retrievalCost += (long)resultSet.getRetrievalCost();
        }
        return (int)Math.min(retrievalCost, Integer.MAX_VALUE);
    }

    @Override
    public int getMergeCost() {
        long mergeCost = 0L;
        for (ResultSet<O> resultSet : this.resultSets) {
            mergeCost += (long)resultSet.getMergeCost();
        }
        return (int)Math.min(mergeCost, Integer.MAX_VALUE);
    }

    @Override
    public void close() {
        for (ResultSet<O> resultSet : this.resultSets) {
            resultSet.close();
        }
    }

    @Override
    public Query<O> getQuery() {
        return this.query;
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }
}

