/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ValidatePasswordResetTokenAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidatePasswordResetTokenAction.class);
    private final PasswordManagementService passwordManagementService;
    private final TicketRegistry ticketRegistry;

    protected Event doExecuteInternal(RequestContext requestContext) {
        try {
            String transientTicket = requestContext.getRequestParameters().get("pswdrst");
            if (StringUtils.isNotBlank((CharSequence)transientTicket)) {
                TransientSessionTicket tst = (TransientSessionTicket)this.ticketRegistry.getTicket(transientTicket, TransientSessionTicket.class);
                String token = tst.getProperties().get("token").toString();
                String username = this.passwordManagementService.parseToken(token);
                if (StringUtils.isBlank((CharSequence)username)) {
                    throw new IllegalArgumentException("Password reset token could not be verified to determine username");
                }
                return new EventFactorySupport().event((Object)this, "resetPassword");
            }
            String doChange = requestContext.getRequestParameters().get("doChangePassword");
            if (StringUtils.isNotBlank((CharSequence)doChange) && BooleanUtils.toBoolean((String)doChange)) {
                return new EventFactorySupport().event((Object)this, "resetPassword");
            }
            return null;
        }
        catch (Exception e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            return new EventFactorySupport().event((Object)this, "invalidPasswordResetToken");
        }
    }

    @Generated
    public ValidatePasswordResetTokenAction(PasswordManagementService passwordManagementService, TicketRegistry ticketRegistry) {
        this.passwordManagementService = passwordManagementService;
        this.ticketRegistry = ticketRegistry;
    }
}

