/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.attrvalue.InvalidPlainAttrValueException;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class DefaultAnyUtils
implements AnyUtils {
    protected static final Logger LOG = LoggerFactory.getLogger(AnyUtils.class);
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final EntityFactory entityFactory;
    protected final AnyTypeKind anyTypeKind;
    protected final Map<String, Field> userFields = new HashMap<String, Field>();
    protected final Map<String, Field> groupFields = new HashMap<String, Field>();
    protected final Map<String, Field> anyObjectFields = new HashMap<String, Field>();

    protected static void initFieldNames(Class<?> entityClass, Map<String, Field> fields) {
        List classes = ClassUtils.getAllSuperclasses(entityClass);
        classes.add(entityClass);
        classes.forEach(clazz -> {
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.getName().startsWith("pc") || Collection.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType())) continue;
                fields.put(field.getName(), field);
                if (!"id".equals(field.getName())) continue;
                fields.put("key", field);
            }
        });
    }

    public DefaultAnyUtils(UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO plainSchemaDAO, EntityFactory entityFactory, AnyTypeKind anyTypeKind) {
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.plainSchemaDAO = plainSchemaDAO;
        this.entityFactory = entityFactory;
        this.anyTypeKind = anyTypeKind;
        DefaultAnyUtils.initFieldNames(entityFactory.userClass(), this.userFields);
        DefaultAnyUtils.initFieldNames(entityFactory.groupClass(), this.groupFields);
        DefaultAnyUtils.initFieldNames(entityFactory.anyObjectClass(), this.anyObjectFields);
    }

    public AnyTypeKind anyTypeKind() {
        return this.anyTypeKind;
    }

    public <T extends Any> Class<T> anyClass() {
        return switch (this.anyTypeKind) {
            case AnyTypeKind.GROUP -> this.entityFactory.groupClass();
            case AnyTypeKind.ANY_OBJECT -> this.entityFactory.anyObjectClass();
            default -> this.entityFactory.userClass();
        };
    }

    public Optional<Field> getField(String name) {
        return Optional.ofNullable((switch (this.anyTypeKind) {
            case AnyTypeKind.GROUP -> this.groupFields;
            case AnyTypeKind.ANY_OBJECT -> this.anyObjectFields;
            default -> this.userFields;
        }).get(name));
    }

    public <T extends AnyTO> T newAnyTO() {
        UserTO result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = new UserTO();
                break;
            }
            case GROUP: {
                result = new GroupTO();
                break;
            }
            case ANY_OBJECT: {
                result = new AnyObjectTO();
                break;
            }
        }
        return (T)result;
    }

    public <C extends AnyCR> C newAnyCR() {
        UserCR result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = new UserCR();
                break;
            }
            case GROUP: {
                result = new GroupCR();
                break;
            }
            case ANY_OBJECT: {
                result = new AnyObjectCR();
                break;
            }
        }
        return (C)result;
    }

    public <U extends AnyUR> U newAnyUR(String key) {
        UserUR result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = new UserUR();
                break;
            }
            case GROUP: {
                result = new GroupUR();
                break;
            }
            case ANY_OBJECT: {
                result = new AnyObjectUR();
                break;
            }
        }
        if (result != null) {
            result.setKey(key);
        }
        return (U)result;
    }

    public <A extends Any> AnyDAO<A> dao() {
        UserDAO result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = this.userDAO;
                break;
            }
            case GROUP: {
                result = this.groupDAO;
                break;
            }
            case ANY_OBJECT: {
                result = this.anyObjectDAO;
                break;
            }
        }
        return result;
    }

    @Transactional(readOnly=true)
    public Set<ExternalResource> getAllResources(Any any) {
        HashSet<ExternalResource> resources = new HashSet<ExternalResource>();
        Any any2 = any;
        Objects.requireNonNull(any2);
        Any any3 = any2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{User.class, Group.class, AnyObject.class}, (Object)any3, n)) {
            case 0: {
                User user = (User)any3;
                resources.addAll(this.userDAO.findAllResources(user));
                break;
            }
            case 1: {
                Group group = (Group)any3;
                resources.addAll(group.getResources());
                break;
            }
            case 2: {
                AnyObject anyObject = (AnyObject)any3;
                resources.addAll(this.anyObjectDAO.findAllResources(anyObject));
                break;
            }
        }
        return resources;
    }

    @Transactional
    public void addAttr(PlainAttrValidationManager validator, String key, PlainSchema schema, String value) {
        Any any = (Any)this.dao().findById(key).orElseThrow(() -> new NotFoundException(String.valueOf(this.anyTypeKind) + " " + key));
        HashSet typeOwnClasses = new HashSet();
        typeOwnClasses.addAll(any.getType().getClasses());
        typeOwnClasses.addAll(any.getAuxClasses());
        if (typeOwnClasses.stream().noneMatch(clazz -> clazz.getPlainSchemas().contains(schema))) {
            LOG.warn("Schema {} not allowed for {}, ignoring", (Object)schema, (Object)any);
            return;
        }
        any.getPlainAttr(schema.getKey()).ifPresentOrElse(attr -> LOG.debug("{} has already {} set: {}", new Object[]{any, schema.getKey(), attr.getValuesAsStrings()}), () -> {
            PlainAttr attr = new PlainAttr();
            attr.setPlainSchema(schema);
            any.add(attr);
            try {
                attr.add(validator, value);
                this.dao().save((Entity)any);
            }
            catch (InvalidPlainAttrValueException e) {
                LOG.error("Invalid value for attribute {} and {}: {}", new Object[]{schema.getKey(), any, value, e});
            }
        });
    }

    @Transactional
    public void removeAttr(String key, PlainSchema schema) {
        Any any = (Any)this.dao().findById(key).orElseThrow(() -> new NotFoundException(String.valueOf(this.anyTypeKind) + " " + key));
        any.getPlainAttr(schema.getKey()).ifPresentOrElse(attr -> {
            any.remove(attr);
            this.dao().save((Entity)any);
        }, () -> LOG.warn("Any {} does not contain {} PLAIN attribute", (Object)key, (Object)schema.getKey()));
    }
}

