/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.layoutdialect.decorators.html;

import java.util.function.Predicate;
import nz.net.ultraq.thymeleaf.layoutdialect.decorators.SortingStrategy;
import nz.net.ultraq.thymeleaf.layoutdialect.decorators.html.HtmlBodyDecorator;
import nz.net.ultraq.thymeleaf.layoutdialect.decorators.html.HtmlHeadDecorator;
import nz.net.ultraq.thymeleaf.layoutdialect.decorators.xml.XmlDocumentDecorator;
import nz.net.ultraq.thymeleaf.layoutdialect.models.extensions.IModelExtensions;
import nz.net.ultraq.thymeleaf.layoutdialect.models.extensions.ITemplateEventExtensions;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.ITemplateEvent;

public class HtmlDocumentDecorator
extends XmlDocumentDecorator {
    private final boolean autoHeadMerging;
    private final SortingStrategy sortingStrategy;

    public HtmlDocumentDecorator(ITemplateContext iTemplateContext, SortingStrategy sortingStrategy, boolean bl) {
        super(iTemplateContext);
        this.sortingStrategy = sortingStrategy;
        this.autoHeadMerging = bl;
    }

    @Override
    public IModel decorate(IModel iModel, IModel iModel2) {
        IModel iModel3;
        Object object;
        IModelFactory iModelFactory = this.context.getModelFactory();
        IModel iModel4 = iModel.cloneModel();
        Predicate<ITemplateEvent> predicate = iTemplateEvent -> ITemplateEventExtensions.isOpeningElementOf(iTemplateEvent, "head");
        if (this.autoHeadMerging) {
            object = IModelExtensions.findModel(iModel4, predicate);
            iModel3 = new HtmlHeadDecorator(this.context, this.sortingStrategy).decorate((IModel)object, IModelExtensions.findModel(iModel2, predicate));
            if (IModelExtensions.asBoolean(iModel3)) {
                if (IModelExtensions.asBoolean(object)) {
                    IModelExtensions.replaceModel(iModel4, IModelExtensions.findIndexOfModel(iModel4, object), iModel3);
                } else {
                    IModelExtensions.insertModelWithWhitespace(iModel4, IModelExtensions.findIndexOf(iModel4, iTemplateEvent -> ITemplateEventExtensions.isOpeningElementOf(iTemplateEvent, "body") || ITemplateEventExtensions.isClosingElementOf(iTemplateEvent, "html")) - 1, iModel3, iModelFactory);
                }
            }
        } else {
            IModelExtensions.replaceModel(iModel4, IModelExtensions.findIndexOf(iModel4, predicate), IModelExtensions.findModel(iModel2, predicate));
        }
        object = iTemplateEvent -> ITemplateEventExtensions.isOpeningElementOf(iTemplateEvent, "body");
        iModel3 = IModelExtensions.findModel(iModel4, (Predicate<ITemplateEvent>)object);
        IModel iModel5 = new HtmlBodyDecorator(this.context).decorate(iModel3, IModelExtensions.findModel(iModel2, (Predicate<ITemplateEvent>)object));
        if (IModelExtensions.asBoolean(iModel5)) {
            if (IModelExtensions.asBoolean(iModel3)) {
                IModelExtensions.replaceModel(iModel4, IModelExtensions.findIndexOfModel(iModel4, iModel3), iModel5);
            } else {
                IModelExtensions.insertModelWithWhitespace(iModel4, IModelExtensions.findIndexOf(iModel4, iTemplateEvent -> ITemplateEventExtensions.isClosingElementOf(iTemplateEvent, "html")) - 1, iModel5, iModelFactory);
            }
        }
        return super.decorate(iModel4, iModel2);
    }

    public final SortingStrategy getSortingStrategy() {
        return this.sortingStrategy;
    }

    public final boolean getAutoHeadMerging() {
        return this.autoHeadMerging;
    }

    public final boolean isAutoHeadMerging() {
        return this.autoHeadMerging;
    }
}

