/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;

public class DirectBasicAuthClient
extends DirectClient {
    private String realmName = "authentication required";

    public DirectBasicAuthClient() {
    }

    public DirectBasicAuthClient(Authenticator usernamePasswordAuthenticator) {
        this.setAuthenticatorIfUndefined(usernamePasswordAuthenticator);
    }

    public DirectBasicAuthClient(Authenticator usernamePasswordAuthenticator, ProfileCreator profileCreator) {
        this.setAuthenticatorIfUndefined(usernamePasswordAuthenticator);
        this.setProfileCreatorIfUndefined(profileCreator);
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"realmName", (String)this.realmName);
        this.setCredentialsExtractorIfUndefined((CredentialsExtractor)new BasicAuthExtractor());
    }

    public Optional<Credentials> getCredentials(CallContext ctx) {
        this.addAuthenticateHeader(ctx.webContext());
        return super.getCredentials(ctx);
    }

    protected void addAuthenticateHeader(WebContext context) {
        context.setResponseHeader("WWW-Authenticate", "Basic realm=\"" + this.realmName + "\"");
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRealmName() {
        return this.realmName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DirectBasicAuthClient(super=" + super.toString() + ", realmName=" + this.realmName + ")";
    }
}

