/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BearerAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;

public class DirectBearerAuthClient
extends DirectClient {
    private String realmName = "authentication required";

    public DirectBearerAuthClient() {
    }

    public DirectBearerAuthClient(Authenticator tokenAuthenticator) {
        this.setAuthenticatorIfUndefined(tokenAuthenticator);
    }

    public DirectBearerAuthClient(ProfileCreator profileCreator) {
        this.setAuthenticatorIfUndefined(Authenticator.ALWAYS_VALIDATE);
        this.setProfileCreatorIfUndefined(profileCreator);
    }

    public DirectBearerAuthClient(Authenticator tokenAuthenticator, ProfileCreator profileCreator) {
        this.setAuthenticatorIfUndefined(tokenAuthenticator);
        this.setProfileCreatorIfUndefined(profileCreator);
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"realmName", (String)this.realmName);
        this.setCredentialsExtractorIfUndefined((CredentialsExtractor)new BearerAuthExtractor());
    }

    public Optional<Credentials> getCredentials(CallContext ctx) {
        ctx.webContext().setResponseHeader("WWW-Authenticate", "Bearer realm=\"" + this.realmName + "\"");
        return super.getCredentials(ctx);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRealmName() {
        return this.realmName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DirectBearerAuthClient(super=" + super.toString() + ", realmName=" + this.realmName + ")";
    }
}

