/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.http.credentials.CredentialUtil;

public class DigestCredentials
extends TokenCredentials {
    private static final long serialVersionUID = -5130296967270874521L;
    private String username;
    private String realm;
    private String nonce;
    private String uri;
    private String cnonce;
    private String nc;
    private String qop;
    private String httpMethod;

    public DigestCredentials(String token, String httpMethod, String username, String realm, String nonce, String uri, String cnonce, String nc, String qop) {
        super(token);
        this.username = username;
        this.realm = realm;
        this.nonce = nonce;
        this.uri = uri;
        this.cnonce = cnonce;
        this.nc = nc;
        this.qop = qop;
        this.httpMethod = httpMethod;
    }

    public String calculateServerDigest(boolean passwordAlreadyEncoded, String password) {
        return this.generateDigest(passwordAlreadyEncoded, this.username, this.realm, password, this.httpMethod, this.uri, this.qop, this.nonce, this.nc, this.cnonce);
    }

    private String generateDigest(boolean passwordAlreadyEncoded, String username, String realm, String password, String httpMethod, String uri, String qop, String nonce, String nc, String cnonce) {
        String digest;
        String a2 = httpMethod + ":" + uri;
        String ha2 = CredentialUtil.encryptMD5(a2);
        String ha1 = passwordAlreadyEncoded ? password : CredentialUtil.encryptMD5(username + ":" + realm + ":" + password);
        if (qop == null) {
            digest = CredentialUtil.encryptMD5(ha1, nonce + ":" + ha2);
        } else if ("auth".equals(qop)) {
            digest = CredentialUtil.encryptMD5(ha1, nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + ha2);
        } else {
            throw new TechnicalException("Invalid qop: '" + qop + "'");
        }
        return digest;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DigestCredentials(username=" + this.username + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DigestCredentials)) {
            return false;
        }
        DigestCredentials other = (DigestCredentials)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$username = this.username;
        String other$username = other.username;
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$realm = this.realm;
        String other$realm = other.realm;
        if (this$realm == null ? other$realm != null : !this$realm.equals(other$realm)) {
            return false;
        }
        String this$nonce = this.nonce;
        String other$nonce = other.nonce;
        if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) {
            return false;
        }
        String this$uri = this.uri;
        String other$uri = other.uri;
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$cnonce = this.cnonce;
        String other$cnonce = other.cnonce;
        if (this$cnonce == null ? other$cnonce != null : !this$cnonce.equals(other$cnonce)) {
            return false;
        }
        String this$nc = this.nc;
        String other$nc = other.nc;
        if (this$nc == null ? other$nc != null : !this$nc.equals(other$nc)) {
            return false;
        }
        String this$qop = this.qop;
        String other$qop = other.qop;
        if (this$qop == null ? other$qop != null : !this$qop.equals(other$qop)) {
            return false;
        }
        String this$httpMethod = this.httpMethod;
        String other$httpMethod = other.httpMethod;
        return !(this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DigestCredentials;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.username;
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $realm = this.realm;
        result = result * 59 + ($realm == null ? 43 : $realm.hashCode());
        String $nonce = this.nonce;
        result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
        String $uri = this.uri;
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $cnonce = this.cnonce;
        result = result * 59 + ($cnonce == null ? 43 : $cnonce.hashCode());
        String $nc = this.nc;
        result = result * 59 + ($nc == null ? 43 : $nc.hashCode());
        String $qop = this.qop;
        result = result * 59 + ($qop == null ? 43 : $qop.hashCode());
        String $httpMethod = this.httpMethod;
        result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUsername() {
        return this.username;
    }
}

