/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldup.search;

import java.util.Base64;
import java.util.Optional;
import net.tirasa.connid.bundles.ldup.LdUpUtils;
import net.tirasa.connid.bundles.ldup.search.LdUpFilter;
import net.tirasa.connid.bundles.ldup.search.LdUpFilterTranslator;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.SearchScope;
import org.ldaptive.control.PagedResultsControl;
import org.ldaptive.control.RequestControl;
import org.ldaptive.handler.ResultPredicate;

public class LdUpSearchOp
implements SearchOp<LdUpFilter> {
    protected static final Log LOG = Log.getLog(LdUpSearchOp.class);
    protected final LdUpUtils ldUpUtils;

    public LdUpSearchOp(LdUpUtils ldUpUtils) {
        this.ldUpUtils = ldUpUtils;
    }

    public FilterTranslator<LdUpFilter> createFilterTranslator(ObjectClass objectClass, OperationOptions options) {
        return new LdUpFilterTranslator(this.ldUpUtils, objectClass);
    }

    public void executeQuery(ObjectClass objectClass, LdUpFilter filter, ResultsHandler handler, OperationOptions options) {
        SearchRequest request;
        LdUpFilter actualFilter = Optional.ofNullable(filter).orElseGet(() -> LdUpFilter.forNativeFilter("objectClass=" + this.ldUpUtils.ldapObjectClass(objectClass)));
        if (actualFilter.getEntryDN() == null && actualFilter.getNativeFilter() == null) {
            throw new ConnectorException("Invalid search filter");
        }
        if (actualFilter.getEntryDN() == null) {
            String nativeFilter = actualFilter.getNativeFilter();
            while (nativeFilter.startsWith("(") && nativeFilter.endsWith(")")) {
                nativeFilter = nativeFilter.substring(1, nativeFilter.length() - 1);
            }
            request = (SearchRequest)SearchRequest.builder().dn(this.ldUpUtils.getConfiguration().getBaseDn()).scope(Optional.ofNullable(options.getScope()).map(scope -> {
                switch (scope) {
                    case "object": {
                        return SearchScope.OBJECT;
                    }
                    case "onelevel": {
                        return SearchScope.ONELEVEL;
                    }
                }
                return SearchScope.SUBTREE;
            }).orElse(SearchScope.SUBTREE)).filter("(&(objectClass=" + this.ldUpUtils.ldapObjectClass(objectClass) + ")(" + nativeFilter + "))").build();
        } else {
            request = (SearchRequest)SearchRequest.builder().dn(actualFilter.getEntryDN()).scope(SearchScope.OBJECT).filter("objectClass=" + this.ldUpUtils.ldapObjectClass(objectClass)).build();
        }
        if (options.getPageSize() != null) {
            PagedResultsControl prc = new PagedResultsControl(options.getPageSize().intValue());
            Optional.ofNullable(options.getPagedResultsCookie()).map(cookie -> Base64.getDecoder().decode((String)cookie)).ifPresent(arg_0 -> ((PagedResultsControl)prc).setCookie(arg_0));
            request.setControls(new RequestControl[]{prc});
        }
        String idAttr = this.ldUpUtils.getIdAttribute(objectClass);
        request.setReturnAttributes(this.ldUpUtils.returnAttributes(options).map(attrs -> {
            attrs.add(idAttr);
            return (String[])attrs.toArray(String[]::new);
        }).orElse(ReturnAttributes.ALL.value()));
        LOG.ok("Search request is {0}", new Object[]{request});
        try {
            SearchResponse response = ((SearchOperation)((SearchOperation.Builder)((SearchOperation.Builder)SearchOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute(request);
            response.getEntries().forEach(entry -> {
                Uid uid = Optional.ofNullable(entry.getAttribute(idAttr)).map(attr -> new Uid(attr.getStringValue())).orElseThrow(() -> new IllegalArgumentException("Could not fetch " + idAttr + " value"));
                handler.handle(this.ldUpUtils.connectorObjectBuilder(objectClass, uid, (LdapEntry)entry, options).build());
            });
            if (handler instanceof SearchResultsHandler) {
                Optional.ofNullable(response.getControl("1.2.840.113556.1.4.319")).map(PagedResultsControl.class::cast).filter(control -> control.getCookie() != null).ifPresent(control -> ((SearchResultsHandler)handler).handleResult(new SearchResult(Base64.getEncoder().encodeToString(control.getCookie()), control.getSize())));
            }
        }
        catch (LdapException e) {
            LOG.warn((Throwable)e, "Error while executing search request {0}", new Object[]{request});
        }
    }
}

