/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.apis.Foursquare2Api;
import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.foursquare.FoursquareProfileCreator;
import org.pac4j.oauth.profile.foursquare.FoursquareProfileDefinition;

public class FoursquareClient
extends OAuth20Client {
    public FoursquareClient() {
    }

    public FoursquareClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.setApi(Foursquare2Api.instance());
        this.configuration.setProfileDefinition(new FoursquareProfileDefinition());
        this.configuration.setScope("user");
        this.setProfileCreatorIfUndefined(new FoursquareProfileCreator(this.configuration, (IndirectClient)this));
        this.setLogoutActionBuilderIfUndefined((ctx, profile, targetUrl) -> Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)ctx.webContext(), (String)"https://www.foursquare.com/logout")));
        super.internalInit(forceReinit);
    }
}

