/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.monitor;

import io.micrometer.core.instrument.Timer;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class SlowRequestsFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SlowRequestsFilter.class);
    private static final int SLOW_REQUEST_THRESHOLD = 5000;
    private final Timer slowRequestTimer;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        this.slowRequestTimer.record(Unchecked.runnable(() -> {
            long startTime = System.currentTimeMillis();
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            long duration = System.currentTimeMillis() - startTime;
            if (duration > 5000L) {
                LOGGER.warn("Slow request detected: [{}] took [{}] ms", (Object)request.getRequestURI(), (Object)duration);
            }
        }));
    }

    @Generated
    public SlowRequestsFilter(Timer slowRequestTimer) {
        this.slowRequestTimer = slowRequestTimer;
    }
}

