/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationDeviceProviderAction;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DuoSecurityMultifactorAuthenticationDeviceProviderAction
extends BaseCasWebflowAction
implements MultifactorAuthenticationDeviceProviderAction {
    protected Event doExecuteInternal(RequestContext requestContext) {
        ApplicationContext applicationContext = requestContext.getActiveFlow().getApplicationContext();
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = authentication.getPrincipal();
        Collection providers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, DuoSecurityMultifactorAuthenticationProvider.class).values();
        Set accounts = providers.stream().filter(Objects::nonNull).filter(BeanSupplier::isNotProxy).filter(provider -> Objects.nonNull(provider.getDeviceManager())).map(provider -> provider.getDeviceManager().findRegisteredDevices(principal)).flatMap(Collection::stream).collect(Collectors.toSet());
        MultifactorAuthenticationWebflowUtils.putMultifactorAuthenticationRegisteredDevices((RequestContext)requestContext, accounts);
        return null;
    }

    @Generated
    public DuoSecurityMultifactorAuthenticationDeviceProviderAction() {
    }
}

