/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cmd.DeleteProcessInstanceCmd;

public class DeleteProcessInstancesByIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Collection<String> processInstanceIds;
    protected String deleteReason;

    public DeleteProcessInstancesByIdCmd(Collection<String> processInstanceIds, String deleteReason) {
        this.processInstanceIds = processInstanceIds;
        this.deleteReason = deleteReason;
    }

    public Void execute(CommandContext commandContext) {
        if (this.processInstanceIds == null) {
            throw new FlowableIllegalArgumentException("processInstanceIds are null");
        }
        HashSet<String> processInstanceIdSet = new HashSet<String>(this.processInstanceIds);
        for (String processInstanceId : processInstanceIdSet) {
            this.executeSingleDelete(commandContext, processInstanceId);
        }
        return null;
    }

    protected Void executeSingleDelete(CommandContext commandContext, String processInstanceId) {
        DeleteProcessInstanceCmd command = new DeleteProcessInstanceCmd(processInstanceId, this.deleteReason);
        return command.execute(commandContext);
    }
}

