/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.engine.impl.DeploymentQueryImpl;
import org.flowable.engine.impl.ModelQueryImpl;
import org.flowable.engine.impl.ProcessDefinitionQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.AbstractProcessEngineEntityManager;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.DeploymentEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.ModelEntity;
import org.flowable.engine.impl.persistence.entity.ModelEntityManager;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionInfoEntityManager;
import org.flowable.engine.impl.persistence.entity.ResourceEntity;
import org.flowable.engine.impl.persistence.entity.ResourceEntityManager;
import org.flowable.engine.impl.persistence.entity.data.DeploymentDataManager;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.Model;
import org.flowable.engine.repository.ProcessDefinition;

public class DeploymentEntityManagerImpl
extends AbstractProcessEngineEntityManager<DeploymentEntity, DeploymentDataManager>
implements DeploymentEntityManager {
    public DeploymentEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, DeploymentDataManager deploymentDataManager) {
        super(processEngineConfiguration, deploymentDataManager);
    }

    public void insert(DeploymentEntity deployment) {
        this.insert(deployment, false);
        for (EngineResource resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceEntityManager().insert((ResourceEntity)resource);
        }
    }

    @Override
    public void deleteDeployment(String deploymentId, boolean cascade) {
        List processDefinitions = new ProcessDefinitionQueryImpl().deploymentId(deploymentId).list();
        this.updateRelatedModels(deploymentId);
        if (cascade) {
            this.deleteProcessInstancesForProcessDefinitions(processDefinitions);
            this.deleteHistoricTaskEventLogEntriesForProcessDefinitions(processDefinitions);
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            ((ProcessEngineConfigurationImpl)this.engineConfiguration).getProcessDefinitionDeploymentDeletionManager().deleteDefinitionForDeployment(processDefinition, deploymentId);
        }
        this.deleteProcessDefinitionsForDeployment(deploymentId);
        this.getResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete((DeploymentEntity)this.findById(deploymentId), false);
    }

    protected void updateRelatedModels(String deploymentId) {
        List models = new ModelQueryImpl().deploymentId(deploymentId).list();
        for (Model model : models) {
            ModelEntity modelEntity = (ModelEntity)model;
            modelEntity.setDeploymentId(null);
            this.getModelEntityManager().updateModel(modelEntity);
        }
    }

    protected void deleteProcessDefinitionsForDeployment(String deploymentId) {
        this.getProcessDefinitionEntityManager().deleteProcessDefinitionsByDeploymentId(deploymentId);
    }

    protected void deleteProcessInstancesForProcessDefinitions(List<ProcessDefinition> processDefinitions) {
        for (ProcessDefinition processDefinition : processDefinitions) {
            this.getExecutionEntityManager().deleteProcessInstancesByProcessDefinition(processDefinition.getId(), "deleted deployment", true);
        }
    }

    protected void deleteHistoricTaskEventLogEntriesForProcessDefinitions(List<ProcessDefinition> processDefinitions) {
        for (ProcessDefinition processDefinition : processDefinitions) {
            ((ProcessEngineConfigurationImpl)this.engineConfiguration).getTaskServiceConfiguration().getHistoricTaskService().deleteHistoricTaskLogEntriesForProcessDefinition(processDefinition.getId());
        }
    }

    @Override
    public long findDeploymentCountByQueryCriteria(DeploymentQueryImpl deploymentQuery) {
        return ((DeploymentDataManager)this.dataManager).findDeploymentCountByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<Deployment> findDeploymentsByQueryCriteria(DeploymentQueryImpl deploymentQuery) {
        return ((DeploymentDataManager)this.dataManager).findDeploymentsByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return ((DeploymentDataManager)this.dataManager).getDeploymentResourceNames(deploymentId);
    }

    @Override
    public List<Deployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap) {
        return ((DeploymentDataManager)this.dataManager).findDeploymentsByNativeQuery(parameterMap);
    }

    @Override
    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return ((DeploymentDataManager)this.dataManager).findDeploymentCountByNativeQuery(parameterMap);
    }

    protected ResourceEntityManager getResourceEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getResourceEntityManager();
    }

    protected ModelEntityManager getModelEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getModelEntityManager();
    }

    protected ProcessDefinitionEntityManager getProcessDefinitionEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getProcessDefinitionEntityManager();
    }

    protected ProcessDefinitionInfoEntityManager getProcessDefinitionInfoEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getProcessDefinitionInfoEntityManager();
    }

    protected ExecutionEntityManager getExecutionEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getExecutionEntityManager();
    }
}

