/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity.data.impl;

import java.util.HashMap;
import java.util.List;
import org.flowable.engine.event.EventLogEntry;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.EventLogEntryEntity;
import org.flowable.engine.impl.persistence.entity.EventLogEntryEntityImpl;
import org.flowable.engine.impl.persistence.entity.data.AbstractProcessDataManager;
import org.flowable.engine.impl.persistence.entity.data.EventLogEntryDataManager;

public class MybatisEventLogEntryDataManager
extends AbstractProcessDataManager<EventLogEntryEntity>
implements EventLogEntryDataManager {
    public MybatisEventLogEntryDataManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public Class<? extends EventLogEntryEntity> getManagedEntityClass() {
        return EventLogEntryEntityImpl.class;
    }

    public EventLogEntryEntity create() {
        return new EventLogEntryEntityImpl();
    }

    @Override
    public List<EventLogEntry> findAllEventLogEntries() {
        return this.getDbSqlSession().selectList("selectAllEventLogEntries");
    }

    @Override
    public List<EventLogEntry> findEventLogEntries(long startLogNr, long pageSize) {
        HashMap<String, Long> params = new HashMap<String, Long>(2);
        params.put("startLogNr", startLogNr);
        if (pageSize > 0L) {
            params.put("endLogNr", startLogNr + pageSize + 1L);
        }
        return this.getDbSqlSession().selectList("selectEventLogEntries", params);
    }

    @Override
    public List<EventLogEntry> findEventLogEntriesByProcessInstanceId(String processInstanceId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("processInstanceId", processInstanceId);
        return this.getDbSqlSession().selectList("selectEventLogEntriesByProcessInstanceId", params);
    }

    @Override
    public void deleteEventLogEntry(long logNr) {
        this.getDbSqlSession().getSqlSession().delete("deleteEventLogEntry", (Object)logNr);
    }
}

