/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.Signal;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.bpmn.model.VariableListenerEventDefinition;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.callback.CallbackData;
import org.flowable.common.engine.impl.callback.RuntimeInstanceStateChangeCallback;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.event.EventDefinitionExpressionUtil;
import org.flowable.engine.impl.jobexecutor.TimerEventHandler;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.BpmnLoggingSessionUtil;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CorrelationUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.EventInstanceBpmnUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.IdentityLinkUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.TimerUtil;
import org.flowable.engine.interceptor.StartProcessInstanceAfterContext;
import org.flowable.engine.interceptor.StartProcessInstanceBeforeContext;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;

public class ProcessInstanceHelper {
    public ProcessInstance createProcessInstance(ProcessDefinition processDefinition, String businessKey, String businessStatus, String processInstanceName, Map<String, Object> variables, Map<String, Object> transientVariables, String ownerId, String assigneeId) {
        return this.createProcessInstance(processDefinition, businessKey, businessStatus, processInstanceName, null, null, null, variables, transientVariables, null, null, null, null, ownerId, assigneeId, null, false);
    }

    public ProcessInstance createProcessInstance(ProcessDefinition processDefinition, String businessKey, String businessStatus, String processInstanceName, String startEventId, String overrideDefinitionTenantId, String predefinedProcessInstanceId, Map<String, Object> variables, Map<String, Object> transientVariables, String callbackId, String callbackType, String referenceId, String referenceType, String ownerId, String assigneeId, String stageInstanceId, boolean startProcessInstance) {
        CommandContext commandContext = Context.getCommandContext();
        if (Flowable5Util.isFlowable5ProcessDefinition(processDefinition, commandContext)) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            return compatibilityHandler.startProcessInstance(processDefinition.getKey(), processDefinition.getId(), variables, transientVariables, businessKey, processDefinition.getTenantId(), processInstanceName);
        }
        if (ProcessDefinitionUtil.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new FlowableException("Cannot start process instance. Process definition " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") is suspended");
        }
        Process process = ProcessDefinitionUtil.getProcess(processDefinition.getId());
        if (process == null) {
            throw new FlowableException("Cannot start process instance. Process model " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") could not be found");
        }
        FlowElement initialFlowElement = null;
        if (StringUtils.isNotEmpty((CharSequence)startEventId)) {
            FlowElement startEventFlowElement = process.getFlowElement(startEventId);
            if (startEventFlowElement == null) {
                throw new FlowableException("No start element found with id " + startEventId + " for process definition " + processDefinition.getId());
            }
            if (!(startEventFlowElement instanceof StartEvent)) {
                throw new FlowableException("Provide start event id is not a start event " + startEventId + " for process definition " + processDefinition.getId());
            }
            initialFlowElement = startEventFlowElement;
        } else {
            initialFlowElement = process.getInitialFlowElement();
        }
        if (initialFlowElement == null) {
            throw new FlowableException("No start element found for process definition " + processDefinition.getId());
        }
        return this.createAndStartProcessInstanceWithInitialFlowElement(processDefinition, businessKey, businessStatus, processInstanceName, overrideDefinitionTenantId, predefinedProcessInstanceId, initialFlowElement, process, variables, transientVariables, callbackId, callbackType, referenceId, referenceType, ownerId, assigneeId, stageInstanceId, startProcessInstance);
    }

    public ProcessInstance createAndStartProcessInstanceByMessage(ProcessDefinition processDefinition, String messageName, String businessKey, String businessStatus, Map<String, Object> variables, Map<String, Object> transientVariables, String callbackId, String callbackType, String referenceId, String referenceType, String ownerId, String assigneeId) {
        CommandContext commandContext = Context.getCommandContext();
        if (Flowable5Util.isFlowable5ProcessDefinition(processDefinition, commandContext)) {
            return CommandContextUtil.getProcessEngineConfiguration(commandContext).getFlowable5CompatibilityHandler().startProcessInstanceByMessage(messageName, variables, transientVariables, businessKey, processDefinition.getTenantId());
        }
        if (ProcessDefinitionUtil.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new FlowableException("Cannot start process instance. Process definition " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") is suspended");
        }
        Process process = ProcessDefinitionUtil.getProcess(processDefinition.getId());
        if (process == null) {
            throw new FlowableException("Cannot start process instance. Process model " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") could not be found");
        }
        FlowElement initialFlowElement = null;
        for (FlowElement flowElement : process.getFlowElements()) {
            MessageEventDefinition messageEventDefinition;
            String actualMessageName;
            StartEvent startEvent;
            if (!(flowElement instanceof StartEvent) || !CollectionUtil.isNotEmpty((Collection)(startEvent = (StartEvent)flowElement).getEventDefinitions()) || !(startEvent.getEventDefinitions().get(0) instanceof MessageEventDefinition) || !Objects.equals(actualMessageName = EventDefinitionExpressionUtil.determineMessageName(commandContext, messageEventDefinition = (MessageEventDefinition)startEvent.getEventDefinitions().get(0), null), messageName)) continue;
            initialFlowElement = flowElement;
            break;
        }
        if (initialFlowElement == null) {
            throw new FlowableException("No message start event found for process definition " + processDefinition.getId() + " and message name " + messageName);
        }
        return this.createAndStartProcessInstanceWithInitialFlowElement(processDefinition, businessKey, businessStatus, null, null, null, initialFlowElement, process, variables, transientVariables, callbackId, callbackType, referenceId, referenceType, ownerId, assigneeId, null, true);
    }

    public ProcessInstance createAndStartProcessInstanceWithInitialFlowElement(ProcessDefinition processDefinition, String businessKey, String businessStatus, String processInstanceName, FlowElement initialFlowElement, Process process, Map<String, Object> variables, Map<String, Object> transientVariables, String ownerId, String assigneeId, boolean startProcessInstance) {
        return this.createAndStartProcessInstanceWithInitialFlowElement(processDefinition, businessKey, businessStatus, processInstanceName, null, null, initialFlowElement, process, variables, transientVariables, null, null, null, null, ownerId, assigneeId, null, startProcessInstance);
    }

    public ProcessInstance createAndStartProcessInstanceWithInitialFlowElement(ProcessDefinition processDefinition, String businessKey, String businessStatus, String processInstanceName, String overrideDefinitionTenantId, String predefinedProcessInstanceId, FlowElement initialFlowElement, Process process, Map<String, Object> variables, Map<String, Object> transientVariables, String callbackId, String callbackType, String referenceId, String referenceType, String ownerId, String assigneeId, String stageInstanceId, boolean startProcessInstance) {
        FlowableEventDispatcher eventDispatcher;
        boolean eventDispatcherEnabled;
        CommandContext commandContext = Context.getCommandContext();
        String initiatorVariableName = null;
        if (initialFlowElement instanceof StartEvent) {
            initiatorVariableName = ((StartEvent)initialFlowElement).getInitiator();
        }
        String tenantId = overrideDefinitionTenantId != null ? overrideDefinitionTenantId : processDefinition.getTenantId();
        StartProcessInstanceBeforeContext startInstanceBeforeContext = new StartProcessInstanceBeforeContext(businessKey, businessStatus, processInstanceName, callbackId, callbackType, referenceId, referenceType, variables, transientVariables, tenantId, ownerId, assigneeId, initiatorVariableName, initialFlowElement.getId(), initialFlowElement, process, processDefinition, overrideDefinitionTenantId, predefinedProcessInstanceId);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        if (processEngineConfiguration.getStartProcessInstanceInterceptor() != null) {
            processEngineConfiguration.getStartProcessInstanceInterceptor().beforeStartProcessInstance(startInstanceBeforeContext);
        }
        ExecutionEntity processInstance = processEngineConfiguration.getExecutionEntityManager().createProcessInstanceExecution(startInstanceBeforeContext.getProcessDefinition(), startInstanceBeforeContext.getPredefinedProcessInstanceId(), startInstanceBeforeContext.getBusinessKey(), startInstanceBeforeContext.getBusinessStatus(), startInstanceBeforeContext.getProcessInstanceName(), startInstanceBeforeContext.getCallbackId(), startInstanceBeforeContext.getCallbackType(), startInstanceBeforeContext.getReferenceId(), startInstanceBeforeContext.getReferenceType(), stageInstanceId, startInstanceBeforeContext.getTenantId(), startInstanceBeforeContext.getInitiatorVariableName(), startInstanceBeforeContext.getInitialActivityId());
        processEngineConfiguration.getHistoryManager().recordProcessInstanceStart(processInstance);
        if (processEngineConfiguration.isLoggingSessionEnabled()) {
            BpmnLoggingSessionUtil.addLoggingData("processStarted", "Started process instance with id " + processInstance.getId(), processInstance);
        }
        if (StringUtils.isNotEmpty((CharSequence)startInstanceBeforeContext.getOwnerId())) {
            IdentityLinkUtil.createProcessInstanceIdentityLink(processInstance, ownerId, null, "owner");
        }
        if (StringUtils.isNotEmpty((CharSequence)startInstanceBeforeContext.getAssigneeId())) {
            IdentityLinkUtil.createProcessInstanceIdentityLink(processInstance, assigneeId, null, "assignee");
        }
        boolean bl = eventDispatcherEnabled = (eventDispatcher = processEngineConfiguration.getEventDispatcher()) != null && eventDispatcher.isEnabled();
        if (eventDispatcherEnabled) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.PROCESS_CREATED, processInstance), processEngineConfiguration.getEngineCfgKey());
        }
        processInstance.setVariables(this.processDataObjects(process.getDataObjects()));
        if (startInstanceBeforeContext.getVariables() != null) {
            for (String string : startInstanceBeforeContext.getVariables().keySet()) {
                processInstance.setVariable(string, startInstanceBeforeContext.getVariables().get(string));
            }
        }
        if (startInstanceBeforeContext.getTransientVariables() != null) {
            Object eventInstance = startInstanceBeforeContext.getTransientVariables().get("eventInstance");
            if (eventInstance instanceof EventInstance) {
                EventInstanceBpmnUtil.handleEventInstanceOutParameters(processInstance, (BaseElement)startInstanceBeforeContext.getInitialFlowElement(), (EventInstance)eventInstance);
            }
            for (String varName : startInstanceBeforeContext.getTransientVariables().keySet()) {
                processInstance.setTransientVariable(varName, startInstanceBeforeContext.getTransientVariables().get(varName));
            }
        }
        if (eventDispatcherEnabled) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityWithVariablesEvent(FlowableEngineEventType.ENTITY_INITIALIZED, processInstance, startInstanceBeforeContext.getVariables(), false), processEngineConfiguration.getEngineCfgKey());
        }
        ExecutionEntity execution = processEngineConfiguration.getExecutionEntityManager().createChildExecution(processInstance);
        execution.setCurrentFlowElement(startInstanceBeforeContext.getInitialFlowElement());
        processEngineConfiguration.getActivityInstanceEntityManager().recordActivityStart(execution);
        if (startProcessInstance) {
            this.startProcessInstance(processInstance, commandContext, startInstanceBeforeContext.getVariables());
        }
        if (callbackId != null) {
            this.callCaseInstanceStateChangeCallbacks(commandContext, processInstance, null, "running");
        }
        if (processEngineConfiguration.getStartProcessInstanceInterceptor() != null) {
            StartProcessInstanceAfterContext startProcessInstanceAfterContext = new StartProcessInstanceAfterContext(processInstance, execution, startInstanceBeforeContext.getVariables(), startInstanceBeforeContext.getTransientVariables(), startInstanceBeforeContext.getInitialFlowElement(), startInstanceBeforeContext.getProcess(), startInstanceBeforeContext.getProcessDefinition());
            processEngineConfiguration.getStartProcessInstanceInterceptor().afterStartProcessInstance(startProcessInstanceAfterContext);
        }
        return processInstance;
    }

    public void startProcessInstance(ExecutionEntity processInstance, CommandContext commandContext, Map<String, Object> variables) {
        Process process = ProcessDefinitionUtil.getProcess(processInstance.getProcessDefinitionId());
        this.processAvailableEventSubProcesses(processInstance, (FlowElementsContainer)process, commandContext);
        ExecutionEntity execution = processInstance.getExecutions().get(0);
        CommandContextUtil.getAgenda(commandContext).planContinueProcessOperation(execution);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createProcessStartedEvent(execution, variables, false), processEngineConfiguration.getEngineCfgKey());
        }
    }

    public void processAvailableEventSubProcesses(ExecutionEntity parentExecution, FlowElementsContainer parentContainer, CommandContext commandContext) {
        for (FlowElement flowElement : parentContainer.getFlowElements()) {
            if (!(flowElement instanceof EventSubProcess)) continue;
            this.processEventSubProcess(parentExecution, (EventSubProcess)flowElement, commandContext);
        }
    }

    public void processEventSubProcess(ExecutionEntity parentExecution, EventSubProcess eventSubProcess, CommandContext commandContext) {
        LinkedList<EventSubscriptionEntity> messageEventSubscriptions = new LinkedList<EventSubscriptionEntity>();
        LinkedList<EventSubscriptionEntity> signalEventSubscriptions = new LinkedList<EventSubscriptionEntity>();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        for (FlowElement subElement : eventSubProcess.getFlowElements()) {
            if (!(subElement instanceof StartEvent)) continue;
            this.processEventSubProcessStartEvent(subElement, parentExecution, messageEventSubscriptions, signalEventSubscriptions, processEngineConfiguration, commandContext);
        }
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            for (EventSubscriptionEntity messageEventSubscription : messageEventSubscriptions) {
                processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createMessageEvent(FlowableEngineEventType.ACTIVITY_MESSAGE_WAITING, messageEventSubscription.getActivityId(), messageEventSubscription.getEventName(), null, messageEventSubscription.getExecutionId(), messageEventSubscription.getProcessInstanceId(), messageEventSubscription.getProcessDefinitionId()), processEngineConfiguration.getEngineCfgKey());
            }
            for (EventSubscriptionEntity signalEventSubscription : signalEventSubscriptions) {
                processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createSignalEvent(FlowableEngineEventType.ACTIVITY_SIGNAL_WAITING, signalEventSubscription.getActivityId(), signalEventSubscription.getEventName(), null, signalEventSubscription.getExecutionId(), signalEventSubscription.getProcessInstanceId(), signalEventSubscription.getProcessDefinitionId()), processEngineConfiguration.getEngineCfgKey());
            }
        }
    }

    public void processEventSubProcessStartEvent(FlowElement subElement, ExecutionEntity parentExecution, ProcessEngineConfigurationImpl processEngineConfiguration, CommandContext commandContext) {
        this.processEventSubProcessStartEvent(subElement, parentExecution, null, null, processEngineConfiguration, commandContext);
    }

    public void processEventSubProcessStartEvent(FlowElement subElement, ExecutionEntity parentExecution, List<EventSubscriptionEntity> messageEventSubscriptions, List<EventSubscriptionEntity> signalEventSubscriptions, ProcessEngineConfigurationImpl processEngineConfiguration, CommandContext commandContext) {
        StartEvent startEvent = (StartEvent)subElement;
        if (CollectionUtil.isEmpty((Collection)startEvent.getEventDefinitions())) {
            String eventType;
            List eventTypeElements = (List)startEvent.getExtensionElements().get("eventType");
            if (eventTypeElements != null && !eventTypeElements.isEmpty() && StringUtils.isNotEmpty((CharSequence)(eventType = ((ExtensionElement)eventTypeElements.get(0)).getElementText()))) {
                ExecutionEntity eventRegistryExecution = processEngineConfiguration.getExecutionEntityManager().createChildExecution(parentExecution);
                eventRegistryExecution.setCurrentFlowElement((FlowElement)startEvent);
                eventRegistryExecution.setEventScope(true);
                eventRegistryExecution.setActive(false);
                EventSubscriptionEntity eventSubscription = (EventSubscriptionEntity)processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService().createEventSubscriptionBuilder().eventType(eventType).executionId(eventRegistryExecution.getId()).processInstanceId(eventRegistryExecution.getProcessInstanceId()).activityId(eventRegistryExecution.getCurrentActivityId()).processDefinitionId(eventRegistryExecution.getProcessDefinitionId()).scopeType("bpmn").tenantId(eventRegistryExecution.getTenantId()).configuration(CorrelationUtil.getCorrelationKey("eventCorrelationParameter", commandContext, eventRegistryExecution)).create();
                CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)eventSubscription);
            }
            return;
        }
        EventDefinition eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0);
        if (eventDefinition instanceof MessageEventDefinition) {
            this.handleMessageEventSubscription(eventDefinition, startEvent, parentExecution, messageEventSubscriptions, processEngineConfiguration, commandContext);
        } else if (eventDefinition instanceof SignalEventDefinition) {
            this.handleSignalEventSubscription(eventDefinition, startEvent, parentExecution, signalEventSubscriptions, processEngineConfiguration, commandContext);
        } else if (eventDefinition instanceof TimerEventDefinition) {
            this.handleTimerEvent(eventDefinition, startEvent, parentExecution, processEngineConfiguration);
        } else if (eventDefinition instanceof VariableListenerEventDefinition) {
            this.handleVariableListenerEventSubscription(eventDefinition, startEvent, parentExecution, processEngineConfiguration, commandContext);
        }
    }

    protected void handleMessageEventSubscription(EventDefinition eventDefinition, StartEvent startEvent, ExecutionEntity parentExecution, List<EventSubscriptionEntity> messageEventSubscriptions, ProcessEngineConfigurationImpl processEngineConfiguration, CommandContext commandContext) {
        MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentExecution.getProcessDefinitionId());
        if (bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
            messageEventDefinition.setMessageRef(bpmnModel.getMessage(messageEventDefinition.getMessageRef()).getName());
        }
        ExecutionEntity messageExecution = processEngineConfiguration.getExecutionEntityManager().createChildExecution(parentExecution);
        messageExecution.setCurrentFlowElement((FlowElement)startEvent);
        messageExecution.setEventScope(true);
        messageExecution.setActive(false);
        String messageName = EventDefinitionExpressionUtil.determineMessageName(commandContext, messageEventDefinition, parentExecution);
        EventSubscriptionEntity eventSubscription = (EventSubscriptionEntity)processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService().createEventSubscriptionBuilder().eventType("message").eventName(messageName).executionId(messageExecution.getId()).processInstanceId(messageExecution.getProcessInstanceId()).activityId(messageExecution.getCurrentActivityId()).processDefinitionId(messageExecution.getProcessDefinitionId()).tenantId(messageExecution.getTenantId()).create();
        CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)eventSubscription);
        if (messageEventSubscriptions != null) {
            messageEventSubscriptions.add(eventSubscription);
        }
        messageExecution.getEventSubscriptions().add(eventSubscription);
    }

    protected void handleSignalEventSubscription(EventDefinition eventDefinition, StartEvent startEvent, ExecutionEntity parentExecution, List<EventSubscriptionEntity> signalEventSubscriptions, ProcessEngineConfigurationImpl processEngineConfiguration, CommandContext commandContext) {
        SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentExecution.getProcessDefinitionId());
        Signal signal = bpmnModel.getSignal(signalEventDefinition.getSignalRef());
        if (signal != null) {
            signalEventDefinition.setSignalRef(signal.getName());
        }
        ExecutionEntity signalExecution = processEngineConfiguration.getExecutionEntityManager().createChildExecution(parentExecution);
        signalExecution.setCurrentFlowElement((FlowElement)startEvent);
        signalExecution.setEventScope(true);
        signalExecution.setActive(false);
        String eventName = EventDefinitionExpressionUtil.determineSignalName(commandContext, signalEventDefinition, bpmnModel, null);
        EventSubscriptionEntity eventSubscription = (EventSubscriptionEntity)processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService().createEventSubscriptionBuilder().eventType("signal").eventName(eventName).signal(signal).executionId(signalExecution.getId()).processInstanceId(signalExecution.getProcessInstanceId()).activityId(signalExecution.getCurrentActivityId()).processDefinitionId(signalExecution.getProcessDefinitionId()).tenantId(signalExecution.getTenantId()).create();
        CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)eventSubscription);
        if (signalEventSubscriptions != null) {
            signalEventSubscriptions.add(eventSubscription);
        }
        signalExecution.getEventSubscriptions().add(eventSubscription);
    }

    protected void handleTimerEvent(EventDefinition eventDefinition, StartEvent startEvent, ExecutionEntity parentExecution, ProcessEngineConfigurationImpl processEngineConfiguration) {
        TimerEventDefinition timerEventDefinition = (TimerEventDefinition)eventDefinition;
        ExecutionEntity timerExecution = processEngineConfiguration.getExecutionEntityManager().createChildExecution(parentExecution);
        timerExecution.setCurrentFlowElement((FlowElement)startEvent);
        timerExecution.setEventScope(true);
        timerExecution.setActive(false);
        TimerJobEntity timerJob = TimerUtil.createTimerEntityForTimerEventDefinition(timerEventDefinition, (FlowElement)startEvent, false, timerExecution, "trigger-timer", TimerEventHandler.createConfiguration(startEvent.getId(), timerEventDefinition.getEndDate(), timerEventDefinition.getCalendarName()));
        if (timerJob != null) {
            processEngineConfiguration.getJobServiceConfiguration().getTimerJobService().scheduleTimerJob(timerJob);
        }
    }

    protected void handleVariableListenerEventSubscription(EventDefinition eventDefinition, StartEvent startEvent, ExecutionEntity parentExecution, ProcessEngineConfigurationImpl processEngineConfiguration, CommandContext commandContext) {
        VariableListenerEventDefinition variableListenerEventDefinition = (VariableListenerEventDefinition)eventDefinition;
        ExecutionEntity variableListenerExecution = processEngineConfiguration.getExecutionEntityManager().createChildExecution(parentExecution);
        variableListenerExecution.setCurrentFlowElement((FlowElement)startEvent);
        variableListenerExecution.setEventScope(true);
        variableListenerExecution.setActive(false);
        String configuration = null;
        if (StringUtils.isNotEmpty((CharSequence)variableListenerEventDefinition.getVariableChangeType())) {
            ObjectNode configurationNode = processEngineConfiguration.getObjectMapper().createObjectNode();
            configurationNode.put("changeType", variableListenerEventDefinition.getVariableChangeType());
            configuration = configurationNode.toString();
        }
        EventSubscriptionEntity eventSubscription = (EventSubscriptionEntity)processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService().createEventSubscriptionBuilder().eventType("variable").eventName(variableListenerEventDefinition.getVariableName()).configuration(configuration).executionId(variableListenerExecution.getId()).processInstanceId(variableListenerExecution.getProcessInstanceId()).activityId(variableListenerExecution.getCurrentActivityId()).processDefinitionId(variableListenerExecution.getProcessDefinitionId()).tenantId(variableListenerExecution.getTenantId()).create();
        CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)eventSubscription);
        variableListenerExecution.getEventSubscriptions().add(eventSubscription);
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }

    public void callCaseInstanceStateChangeCallbacks(CommandContext commandContext, ProcessInstance processInstance, String oldState, String newState) {
        Map<String, List<RuntimeInstanceStateChangeCallback>> caseInstanceCallbacks;
        if (processInstance.getCallbackId() != null && processInstance.getCallbackType() != null && (caseInstanceCallbacks = CommandContextUtil.getProcessEngineConfiguration(commandContext).getProcessInstanceStateChangedCallbacks()) != null && caseInstanceCallbacks.containsKey(processInstance.getCallbackType())) {
            for (RuntimeInstanceStateChangeCallback caseInstanceCallback : caseInstanceCallbacks.get(processInstance.getCallbackType())) {
                caseInstanceCallback.stateChanged(new CallbackData(processInstance.getCallbackId(), processInstance.getCallbackType(), processInstance.getId(), oldState, newState));
            }
        }
    }
}

