/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.commons.LdapConstants;
import net.tirasa.connid.bundles.ldap.search.LdapSearches;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorSecurityException;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;
import org.identityconnectors.framework.common.exceptions.PasswordExpiredException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.Uid;

public class LdapAuthenticate {
    protected final LdapConnection conn;
    protected final ObjectClass oclass;
    protected final String username;
    protected final OperationOptions options;

    public LdapAuthenticate(LdapConnection conn, ObjectClass oclass, String username, OperationOptions options) {
        this.conn = conn;
        this.oclass = oclass;
        this.username = username;
        this.options = options;
    }

    public Uid authenticate(GuardedString password) {
        ConnectorObject authnObject = this.getObjectToAuthenticate();
        LdapConnection.AuthenticationResult authnResult = null;
        if (authnObject != null) {
            String entryDN = authnObject.getAttributeByName(this.conn.getConfiguration().getDnAttribute()).getValue().get(0).toString();
            authnResult = this.conn.authenticate(entryDN, password);
        }
        if (authnResult == null || !LdapAuthenticate.isSuccess(authnResult)) {
            throw new InvalidCredentialException(this.conn.format("authenticationFailed", null, this.username));
        }
        try {
            authnResult.propagate();
        }
        catch (PasswordExpiredException e) {
            e.initUid(authnObject.getUid());
            throw e;
        }
        return authnObject.getUid();
    }

    public Uid resolveUsername() {
        ConnectorObject authnObject = this.getObjectToAuthenticate();
        if (authnObject == null) {
            throw new InvalidCredentialException(this.conn.format("cannotResolveUsername", null, this.username));
        }
        return authnObject.getUid();
    }

    protected ConnectorObject getObjectToAuthenticate() {
        List<String> userNameAttrs = this.getUserNameAttributes();
        HashMap<String, ConnectorObject> entryDN2Object = new HashMap<String, ConnectorObject>();
        String dnAttributeName = this.conn.getConfiguration().getDnAttribute();
        for (String baseContext : this.conn.getConfiguration().getBaseContexts()) {
            for (String userNameAttr : userNameAttrs) {
                Attribute attr = AttributeBuilder.build((String)userNameAttr, (Object[])new Object[]{this.username});
                for (ConnectorObject object : LdapSearches.findObjects(this.conn, this.oclass, baseContext, attr, dnAttributeName)) {
                    String entryDN = object.getAttributeByName(dnAttributeName).getValue().get(0).toString();
                    entryDN2Object.put(entryDN, object);
                }
                if (entryDN2Object.size() <= 1) continue;
                throw new ConnectorSecurityException(this.conn.format("moreThanOneEntryMatched", null, this.username));
            }
        }
        if (!entryDN2Object.isEmpty()) {
            return (ConnectorObject)entryDN2Object.values().iterator().next();
        }
        return null;
    }

    protected List<String> getUserNameAttributes() {
        String[] result = LdapConstants.getLdapUidAttributes(this.options);
        if (result != null && result.length > 0) {
            return Arrays.asList(result);
        }
        return this.conn.getSchema().getUserNameLdapAttributes(this.oclass);
    }

    protected static boolean isSuccess(LdapConnection.AuthenticationResult authResult) {
        return authResult.getType() != null && (authResult.getType().equals((Object)LdapConnection.AuthenticationResultType.SUCCESS) || authResult.getType().equals((Object)LdapConnection.AuthenticationResultType.PASSWORD_EXPIRED));
    }
}

