/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jakarta.annotation.Nonnull;
import java.util.List;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlanConfigurer;
import org.apereo.cas.throttle.ThrottledRequestFilter;
import org.apereo.cas.util.spring.RefreshableHandlerInterceptor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.OpenIDConnect, CasFeatureModule.FeatureCatalog.Throttling})
@Configuration(value="OidcThrottleConfiguration", proxyBeanMethods=false)
class OidcThrottleConfiguration {
    OidcThrottleConfiguration() {
    }

    @Configuration(value="OidcThrottleFilterConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcThrottleFilterConfiguration {
        private static final List<String> THROTTLED_ENDPOINTS = List.of("oidcAccessToken", "oidcAuthorize", "oidcToken", "oidcProfile", "jwks", "clientConfig", "revoke", "introspect");

        OidcThrottleFilterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcThrottledRequestFilter"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ThrottledRequestFilter oidcThrottledRequestFilter(@Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService) {
            return (request, response) -> {
                JEEContext webContext = new JEEContext(request, response);
                return THROTTLED_ENDPOINTS.stream().anyMatch(endpoint -> oidcIssuerService.validateIssuer((WebContext)webContext, endpoint));
            };
        }
    }

    @Configuration(value="OidcThrottleExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcThrottleExecutionPlanConfiguration {
        OidcThrottleExecutionPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"oidcAuthenticationThrottlingExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationThrottlingExecutionPlanConfigurer oidcAuthenticationThrottlingExecutionPlanConfigurer(@Qualifier(value="oidcThrottledRequestFilter") ThrottledRequestFilter oidcThrottledRequestFilter) {
            return plan -> plan.registerAuthenticationThrottleFilter(oidcThrottledRequestFilter);
        }
    }

    @Configuration(value="OidcThrottleWebMvcConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcThrottleWebMvcConfiguration {
        OidcThrottleWebMvcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcThrottleWebMvcConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WebMvcConfigurer oidcThrottleWebMvcConfigurer(final @Qualifier(value="authenticationThrottlingExecutionPlan") ObjectProvider<AuthenticationThrottlingExecutionPlan> authenticationThrottlingExecutionPlan) {
            return new WebMvcConfigurer(){

                public void addInterceptors(@Nonnull InterceptorRegistry registry) {
                    authenticationThrottlingExecutionPlan.ifAvailable(plan -> {
                        RefreshableHandlerInterceptor handler = new RefreshableHandlerInterceptor(() -> ((AuthenticationThrottlingExecutionPlan)plan).getAuthenticationThrottleInterceptors());
                        registry.addInterceptor((HandlerInterceptor)handler).order(0).addPathPatterns(new String[]{"/oidc/**"});
                    });
                }
            };
        }
    }
}

