/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.http.ajax;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.HttpConstants;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.core.http.ajax.AjaxRequestResolver;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.core.util.Pac4jConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAjaxRequestResolver
implements AjaxRequestResolver,
HttpConstants,
Pac4jConstants {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAjaxRequestResolver.class);
    private boolean addRedirectionUrlAsHeader = false;

    @Override
    public boolean isAjax(CallContext ctx) {
        WebContext webContext = ctx.webContext();
        boolean xmlHttpRequest = "XMLHttpRequest".equalsIgnoreCase(webContext.getRequestHeader("X-Requested-With").orElse(null));
        boolean hasDynamicAjaxParameter = Boolean.TRUE.toString().equalsIgnoreCase(webContext.getRequestHeader("is_ajax_request").orElse(null));
        boolean hasDynamicAjaxHeader = Boolean.TRUE.toString().equalsIgnoreCase(webContext.getRequestParameter("is_ajax_request").orElse(null));
        return xmlHttpRequest || hasDynamicAjaxParameter || hasDynamicAjaxHeader;
    }

    @Override
    public HttpAction buildAjaxResponse(CallContext ctx, RedirectionActionBuilder redirectionActionBuilder) {
        WebContext webContext;
        RedirectionAction action;
        String url = null;
        if (this.addRedirectionUrlAsHeader && (action = (RedirectionAction)redirectionActionBuilder.getRedirectionAction(ctx).orElse(null)) instanceof WithLocationAction) {
            url = ((WithLocationAction)((Object)action)).getLocation();
        }
        if ((webContext = ctx.webContext()).getRequestParameter("javax.faces.partial.ajax").isEmpty()) {
            if (StringUtils.isNotBlank(url)) {
                webContext.setResponseHeader("Location", url);
            }
            LOGGER.debug("Faces is not used: returning unauthenticated error for url: {}", (Object)url);
            return HttpActionHelper.buildUnauthenticatedAction(webContext);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version='1.0' encoding='UTF-8'?>");
        buffer.append("<partial-response>");
        if (StringUtils.isNotBlank((CharSequence)url)) {
            buffer.append("<redirect url=\"" + url.replaceAll("&", "&amp;") + "\"></redirect>");
        }
        buffer.append("</partial-response>");
        LOGGER.debug("Faces is used: returning partial response content for url: {}", (Object)url);
        return HttpActionHelper.buildFormPostContentAction(webContext, buffer.toString());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAddRedirectionUrlAsHeader() {
        return this.addRedirectionUrlAsHeader;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAddRedirectionUrlAsHeader(boolean addRedirectionUrlAsHeader) {
        this.addRedirectionUrlAsHeader = addRedirectionUrlAsHeader;
    }
}

