/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.core;

import com.yubico.webauthn.data.ByteArray;
import jakarta.servlet.http.HttpServletRequest;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;
import org.apereo.cas.util.RandomUtils;

public interface SessionManager {
    public static final String BEAN_NAME = "webAuthnSessionManager";

    public static ByteArray generateRandom(int length) {
        SecureRandom random = RandomUtils.getNativeInstance();
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return new ByteArray(bytes);
    }

    public ByteArray createSession(HttpServletRequest var1, @NonNull ByteArray var2);

    public Optional<ByteArray> getSession(HttpServletRequest var1, @NonNull ByteArray var2);

    default public boolean isSessionForUser(HttpServletRequest request, @NonNull ByteArray claimedUserHandle, @NonNull ByteArray token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        Objects.requireNonNull(claimedUserHandle);
        return this.getSession(request, token).map(arg_0 -> ((ByteArray)claimedUserHandle).equals(arg_0)).orElse(false);
    }

    default public boolean isSessionForUser(HttpServletRequest request, @NonNull ByteArray claimedUserHandle, @NonNull Optional<ByteArray> token) {
        if (claimedUserHandle == null) {
            throw new NullPointerException("claimedUserHandle is marked non-null but is null");
        }
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        return token.map(givenToken -> this.isSessionForUser(request, claimedUserHandle, (ByteArray)givenToken)).orElse(false);
    }
}

