/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.support;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FormProperty;
import org.flowable.bpmn.model.FormValue;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;
import org.flowable.editor.language.json.converter.UserTaskJsonConverter;
import org.flowable.editor.language.json.converter.util.JsonConverterUtil;

public class DropdownAwareUserTaskJsonConverter
extends UserTaskJsonConverter {
    protected void convertJsonToFormProperties(JsonNode objectNode, BaseElement element) {
        JsonNode propertiesArray;
        JsonNode formPropertiesNode = JsonConverterUtil.getProperty((String)"formproperties", (JsonNode)objectNode);
        if (formPropertiesNode != null && (propertiesArray = (formPropertiesNode = BpmnJsonConverterUtil.validateIfNodeIsTextual((JsonNode)formPropertiesNode)).get("formProperties")) != null) {
            for (JsonNode formNode : propertiesArray) {
                JsonNode enumValuesNode;
                JsonNode formIdNode = formNode.get("id");
                if (formIdNode == null || !StringUtils.isNotEmpty((CharSequence)formIdNode.asText())) continue;
                FormProperty formProperty = new FormProperty();
                formProperty.setId(formIdNode.asText());
                formProperty.setName(DropdownAwareUserTaskJsonConverter.getValueAsString((String)"name", (JsonNode)formNode));
                formProperty.setType(DropdownAwareUserTaskJsonConverter.getValueAsString((String)"type", (JsonNode)formNode));
                formProperty.setExpression(DropdownAwareUserTaskJsonConverter.getValueAsString((String)"expression", (JsonNode)formNode));
                formProperty.setVariable(DropdownAwareUserTaskJsonConverter.getValueAsString((String)"variable", (JsonNode)formNode));
                if ("date".equalsIgnoreCase(formProperty.getType())) {
                    formProperty.setDatePattern(DropdownAwareUserTaskJsonConverter.getValueAsString((String)"datePattern", (JsonNode)formNode));
                } else if (("enum".equalsIgnoreCase(formProperty.getType()) || "dropdown".equalsIgnoreCase(formProperty.getType())) && (enumValuesNode = formNode.get("enumValues")) != null) {
                    ArrayList<FormValue> formValueList = new ArrayList<FormValue>();
                    for (JsonNode enumNode : enumValuesNode) {
                        FormValue formValue;
                        if (enumNode.get("id") != null && !enumNode.get("id").isNull() && enumNode.get("name") != null && !enumNode.get("name").isNull()) {
                            formValue = new FormValue();
                            formValue.setId(enumNode.get("id").asText());
                            formValue.setName(enumNode.get("name").asText());
                            formValueList.add(formValue);
                            continue;
                        }
                        if (enumNode.get("value") == null || enumNode.get("value").isNull()) continue;
                        formValue = new FormValue();
                        formValue.setId(enumNode.get("value").asText());
                        formValue.setName(enumNode.get("value").asText());
                        formValueList.add(formValue);
                    }
                    formProperty.setFormValues(formValueList);
                }
                formProperty.setRequired(DropdownAwareUserTaskJsonConverter.getValueAsBoolean((String)"required", (JsonNode)formNode));
                formProperty.setReadable(DropdownAwareUserTaskJsonConverter.getValueAsBoolean((String)"readable", (JsonNode)formNode));
                formProperty.setWriteable(DropdownAwareUserTaskJsonConverter.getValueAsBoolean((String)"writable", (JsonNode)formNode));
                if (element instanceof StartEvent) {
                    StartEvent startEvent = (StartEvent)element;
                    startEvent.getFormProperties().add(formProperty);
                    continue;
                }
                if (!(element instanceof UserTask)) continue;
                UserTask userTask = (UserTask)element;
                userTask.getFormProperties().add(formProperty);
            }
        }
    }
}

