/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.ott.reactive;

import java.util.function.Function;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.ott.InvalidOneTimeTokenException;
import org.springframework.security.authentication.ott.OneTimeTokenAuthenticationToken;
import org.springframework.security.authentication.ott.reactive.ReactiveOneTimeTokenService;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class OneTimeTokenReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private final ReactiveOneTimeTokenService oneTimeTokenService;
    private final ReactiveUserDetailsService userDetailsService;

    public OneTimeTokenReactiveAuthenticationManager(ReactiveOneTimeTokenService oneTimeTokenService, ReactiveUserDetailsService userDetailsService) {
        Assert.notNull((Object)oneTimeTokenService, (String)"oneTimeTokenService cannot be null");
        Assert.notNull((Object)userDetailsService, (String)"userDetailsService cannot be null");
        this.oneTimeTokenService = oneTimeTokenService;
        this.userDetailsService = userDetailsService;
    }

    @Override
    public Mono<Authentication> authenticate(Authentication authentication) {
        if (!(authentication instanceof OneTimeTokenAuthenticationToken)) {
            return Mono.empty();
        }
        OneTimeTokenAuthenticationToken otpAuthenticationToken = (OneTimeTokenAuthenticationToken)authentication;
        return this.oneTimeTokenService.consume(otpAuthenticationToken).switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)new InvalidOneTimeTokenException("Invalid token")))).flatMap(consumed -> this.userDetailsService.findByUsername(consumed.getUsername())).map(this.onSuccess(otpAuthenticationToken));
    }

    private Function<UserDetails, OneTimeTokenAuthenticationToken> onSuccess(OneTimeTokenAuthenticationToken token) {
        return user -> {
            OneTimeTokenAuthenticationToken authenticated = OneTimeTokenAuthenticationToken.authenticated(user, user.getAuthorities());
            authenticated.setDetails(token.getDetails());
            return authenticated;
        };
    }
}

