/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Nonnull;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageChannelSecurityContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.impl.AbstractMessageChannelSecurity;
import org.opensaml.profile.context.ProfileRequestContext;

public class HttpServletRequestMessageChannelSecurity
extends AbstractMessageChannelSecurity {
    private boolean defaultPortInsecure = true;

    public void setDefaultPortInsecure(boolean flag) {
        this.checkSetterPreconditions();
        this.defaultPortInsecure = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getHttpServletRequest() == null) {
            throw new ComponentInitializationException("HttpServletRequest is required");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        BaseContext parent = this.getParentContext();
        HttpServletRequest request = this.getHttpServletRequest();
        if (parent == null || request == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        MessageChannelSecurityContext channelContext = (MessageChannelSecurityContext)parent.ensureSubcontext(MessageChannelSecurityContext.class);
        if (request.isSecure() && (!this.defaultPortInsecure || request.getLocalPort() != 443)) {
            channelContext.setConfidentialityActive(true);
            channelContext.setIntegrityActive(true);
        } else {
            channelContext.setConfidentialityActive(false);
            channelContext.setIntegrityActive(false);
        }
    }
}

