/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.log.LogManager$;
import kafka.raft.KafkaRaftManager;
import kafka.raft.KafkaRaftManager$;
import kafka.server.KafkaConfig;
import kafka.tools.TestRaftServer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f\u0001\u0002\t\u0012\u0001YAQ!\b\u0001\u0005\u0002yAQ!\t\u0001\u0005\n\tBQ\u0001\u0015\u0001\u0005\nECQ!\u001b\u0001\u0005\n)DQA \u0001\u0005\u0002}Dq!a\u0011\u0001\t\u0003\t)\u0005C\u0004\u0002^\u0001!\t!a\u0018\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBAC\u0001\u0011\u0005\u0011q\f\u0005\b\u0003\u0013\u0003A\u0011AA0\u0011\u001d\ti\t\u0001C\u0001\u0003?Bq!!%\u0001\t\u0003\ty\u0006C\u0004\u0002\u0016\u0002!\t!a\u0018\t\u000f\u0005e\u0005\u0001\"\u0003\u0002\u001c\ny!+\u00194u\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0013'\u0005!!/\u00194u\u0015\u0005!\u0012!B6bM.\f7\u0001A\n\u0003\u0001]\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0012\u0003Q\u0019'/Z1uKj['I]8lKJ\u001cuN\u001c4jOR)1%\u000b\u00184\u0017B\u0011AeJ\u0007\u0002K)\u0011aeE\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005!*#aC&bM.\f7i\u001c8gS\u001eDQA\u000b\u0002A\u0002-\n\u0001#\\5he\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0011\u0005aa\u0013BA\u0017\u001a\u0005\u001d\u0011un\u001c7fC:DQa\f\u0002A\u0002A\naA\\8eK&#\u0007C\u0001\r2\u0013\t\u0011\u0014DA\u0002J]RDQ\u0001\u000e\u0002A\u0002U\na\u0001\\8h\t&\u0014\bc\u0001\u001c?\u0003:\u0011q\u0007\u0010\b\u0003qmj\u0011!\u000f\u0006\u0003uU\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005uJ\u0012a\u00029bG.\fw-Z\u0005\u0003\u007f\u0001\u00131aU3r\u0015\ti\u0014\u0004\u0005\u0002C\u00136\t1I\u0003\u0002E\u000b\u0006!a-\u001b7f\u0015\t1u)A\u0002oS>T\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002K\u0007\n!\u0001+\u0019;i\u0011\u0015a%\u00011\u0001N\u0003-iW\r^1eCR\fG)\u001b:\u0011\u0007aq\u0015)\u0003\u0002P3\t1q\n\u001d;j_:\fAb\u0019:fCR,7i\u001c8gS\u001e$Ra\t*gO\"DQaU\u0002A\u0002Q\u000bA\u0002\u001d:pG\u0016\u001c8OU8mKN\u00042!V-]\u001d\t1v\u000b\u0005\u000293%\u0011\u0001,G\u0001\u0007!J,G-\u001a4\n\u0005i[&aA*fi*\u0011\u0001,\u0007\t\u0003;\u0012l\u0011A\u0018\u0006\u0003M}S!\u0001\u00061\u000b\u0005\u0005\u0014\u0017AB1qC\u000eDWMC\u0001d\u0003\ry'oZ\u0005\u0003Kz\u00131\u0002\u0015:pG\u0016\u001c8OU8mK\")qf\u0001a\u0001a!)Ag\u0001a\u0001k!)Aj\u0001a\u0001\u001b\u0006\t2M]3bi\u0016\u0014\u0016M\u001a;NC:\fw-\u001a:\u0015\u0007-$H\u0010E\u0002!Y:L!!\\\t\u0003!-\u000bgm[1SC\u001a$X*\u00198bO\u0016\u0014\bc\u0001\rpc&\u0011\u0001/\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00031IL!a]\r\u0003\t\tKH/\u001a\u0005\u0006k\u0012\u0001\rA^\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\t9(0D\u0001y\u0015\tIx,\u0001\u0004d_6lwN\\\u0005\u0003wb\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0003~\t\u0001\u00071%\u0001\u0004d_:4\u0017nZ\u0001\u0012i\u0016\u001cHOT8eK&#\u0007K]3tK:$H\u0003BA\u0001\u0003\u000f\u00012\u0001GA\u0002\u0013\r\t)!\u0007\u0002\u0005+:LG\u000f\u0003\u0004T\u000b\u0001\u0007\u0011\u0011\u0002\t\u0004+\u0006-\u0011bAA\u00077\n11\u000b\u001e:j]\u001eD3!BA\t!\u0011\t\u0019\"!\t\u000e\u0005\u0005U!\u0002BA\f\u00033\ta\u0001]1sC6\u001c(\u0002BA\u000e\u0003;\tqA[;qSR,'OC\u0002\u0002 \t\fQA[;oSRLA!a\t\u0002\u0016\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;)\u000f\u0015\t9#a\r\u00026A!\u0011\u0011FA\u0018\u001b\t\tYC\u0003\u0003\u0002.\u0005U\u0011\u0001\u00039s_ZLG-\u001a:\n\t\u0005E\u00121\u0006\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\r\u0005]\u00121HA C\t\tI$\u0001\u0004ce>\\WM]\u0011\u0003\u0003{\t!bY8oiJ|G\u000e\\3sC\t\t\t%A\tce>\\WM\u001d\u0017d_:$(o\u001c7mKJ\f\u0001\u0005^3ti2{w\rR5s\u0019>\u001c7n\u00165f]\u000e{g\u000e\u001e:pY2,'o\u00148msR!\u0011\u0011AA$\u0011\u001d\tIE\u0002a\u0001\u0003\u0013\tq\u0001Z5s)f\u0004X\rK\u0002\u0007\u0003#AsABA\u0014\u0003g\ty\u0005\f\u0004\u0002R\u0005U\u0013\u0011L\u0011\u0003\u0003'\nQ\"\\3uC\u0012\fG/Y\u0017p]2L\u0018EAA,\u0003!awnZ\u0017p]2L\u0018EAA.\u0003\u0011\u0011w\u000e\u001e5\u0002gQ,7\u000f\u001e'pO\u0012K'\u000fT8dW^CWM\u001c\"s_.,'o\u00148ms^KG\u000f[*fa\u0006\u0014\u0018\r^3NKR\fG-\u0019;b\t&\u0014HCAA\u0001Q\r9\u00111\r\t\u0005\u0003K\nY'\u0004\u0002\u0002h)!\u0011\u0011NA\r\u0003\r\t\u0007/[\u0005\u0005\u0003[\n9G\u0001\u0003UKN$\u0018!E2sK\u0006$X-T3uC\u0012\fG/\u0019'pOR!\u0011\u0011AA:\u0011\u0015i\b\u00021\u0001$\u0003I\t7o]3si2{w\rR5sg\u0016C\u0018n\u001d;\u0015\u0011\u0005\u0005\u0011\u0011PA?\u0003\u0003Ca!a\u001f\n\u0001\u0004)\u0014a\u00027pO\u0012K'o\u001d\u0005\u0007\u0003\u007fJ\u0001\u0019A'\u0002\u001d5,G/\u00193bi\u0006dun\u001a#je\"1\u00111Q\u0005A\u0002-\n\u0011#\u001a=qK\u000e$X*\u001a;bI\u0006$\u0018\rT8h\u0003\u001d\"Xm\u001d;NS\u001e\u0014\u0018\r^5oOj['I]8lKJ$U\r\\3uKNlU\r^1eCR\fGj\\4)\u0007)\t\u0019'\u0001\u0019uKN$hj\u001c8NS\u001e\u0014\u0018\r^5oOj['I]8lKJ$u.Z:O_R$U\r\\3uK6+G/\u00193bi\u0006dun\u001a\u0015\u0004\u0017\u0005\r\u0014\u0001\u000b;fgRT6N\u0011:pW\u0016\u0014Hi\\3t\u001d>$H)\u001a7fi\u0016\u001cV\r]1sCR,Gj\\4ESJ\u001c\bf\u0001\u0007\u0002d\u0005\u0019C/Z:u5.\u0014%o\\6fe\u0012{Wm\u001d(pi\u0012+G.\u001a;f'\u0006lW\rT8h\t&\u0014\bfA\u0007\u0002d\u00059C/Z:u\u0017J\u000bg\r\u001e\"s_.,'\u000fR8fg:{G\u000fR3mKR,W*\u001a;bI\u0006$\u0018\rT8hQ\rq\u00111M\u0001\u000bM&dW\rT8dW\u0016$GcA\u0016\u0002\u001e\"1\u0011qT\bA\u0002\u0005\u000bA\u0001]1uQ\u0002")
public class RaftManagerTest {
    private KafkaConfig createZkBrokerConfig(boolean migrationEnabled, int nodeId, Seq<Path> logDir, Option<Path> metadataDir) {
        Properties props = new Properties();
        logDir.foreach((Function1 & Serializable)value -> props.setProperty("log.dir", ((Object)value).toString()));
        if (migrationEnabled) {
            metadataDir.foreach((Function1 & Serializable)value -> props.setProperty("metadata.log.dir", ((Object)value).toString()));
            props.setProperty("zookeeper.metadata.migration.enable", "true");
            props.setProperty("controller.quorum.voters", new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
            props.setProperty("controller.listener.names", "SSL");
        }
        props.setProperty("zookeeper.connect", "localhost:2181");
        props.setProperty("broker.id", Integer.toString(nodeId));
        return new KafkaConfig((Map)props);
    }

    private KafkaConfig createConfig(Set<ProcessRole> processRoles, int nodeId, Seq<Path> logDir, Option<Path> metadataDir) {
        Properties props = new Properties();
        logDir.foreach((Function1 & Serializable)value -> props.setProperty("log.dir", ((Object)value).toString()));
        metadataDir.foreach((Function1 & Serializable)value -> props.setProperty("metadata.log.dir", ((Object)value).toString()));
        props.setProperty("process.roles", processRoles.mkString(","));
        props.setProperty("node.id", Integer.toString(nodeId));
        props.setProperty("controller.listener.names", "SSL");
        if (processRoles.contains((Object)ProcessRole.BrokerRole)) {
            props.setProperty("inter.broker.listener.name", "PLAINTEXT");
            if (processRoles.contains((Object)ProcessRole.ControllerRole)) {
                props.setProperty("listeners", "PLAINTEXT://localhost:9092,SSL://localhost:9093");
                props.setProperty("controller.quorum.voters", new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
            } else {
                int voterId = nodeId + 1;
                props.setProperty("controller.quorum.voters", new StringBuilder(15).append(voterId).append("@localhost:9093").toString());
            }
        } else if (processRoles.contains((Object)ProcessRole.ControllerRole)) {
            props.setProperty("listeners", "SSL://localhost:9093");
            props.setProperty("controller.quorum.voters", new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
        }
        return new KafkaConfig((Map)props);
    }

    private KafkaRaftManager<byte[]> createRaftManager(TopicPartition topicPartition, KafkaConfig config) {
        Uuid topicId = new Uuid(0L, 2L);
        return new KafkaRaftManager(Uuid.randomUuid().toString(), config, Uuid.randomUuid(), (RecordSerde)new TestRaftServer.ByteArraySerde(), topicPartition, topicId, Time.SYSTEM, new Metrics(Time.SYSTEM), Option$.MODULE$.empty(), CompletableFuture.completedFuture(QuorumConfig.parseVoterConnections((java.util.List)config.quorumVoters())), (Collection)QuorumConfig.parseBootstrapServers((java.util.List)config.quorumBootstrapServers()), (FaultHandler)Mockito.mock(FaultHandler.class));
    }

    @ParameterizedTest
    @ValueSource(strings={"broker", "controller", "broker,controller"})
    public void testNodeIdPresent(String processRoles) {
        Set processRolesSet = Predef$.MODULE$.Set().empty();
        if (processRoles.contains("broker")) {
            processRolesSet = (Set)processRolesSet.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.BrokerRole})));
        }
        if (processRoles.contains("controller")) {
            processRolesSet = (Set)processRolesSet.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.ControllerRole})));
        }
        File logDir = TestUtils.tempDirectory(null, null);
        int nodeId = 1;
        KafkaRaftManager<byte[]> raftManager = this.createRaftManager(new TopicPartition("__raft_id_test", 0), this.createConfig((Set<ProcessRole>)processRolesSet, nodeId, (Seq<Path>)new .colon.colon((Object)logDir.toPath(), (List)Nil$.MODULE$), (Option<Path>)None$.MODULE$));
        Assertions.assertEquals((int)nodeId, (int)raftManager.client().nodeId().getAsInt());
        raftManager.shutdown();
    }

    @ParameterizedTest
    @ValueSource(strings={"metadata-only", "log-only", "both"})
    public void testLogDirLockWhenControllerOnly(String dirType) {
        .colon.colon logDir;
        Object object = dirType.equals("metadata-only") ? (Seq)package$.MODULE$.Seq().empty() : (logDir = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$));
        None$ metadataDir = dirType.equals("log-only") ? None$.MODULE$ : new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaRaftManager<byte[]> raftManager = this.createRaftManager(new TopicPartition("__raft_id_test", 0), this.createConfig((Set<ProcessRole>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.ControllerRole}))), nodeId, (Seq<Path>)logDir, (Option<Path>)metadataDir));
        Path lockPath = ((Path)metadataDir.getOrElse(() -> RaftManagerTest.$anonfun$testLogDirLockWhenControllerOnly$1((Seq)logDir))).resolve(LogManager$.MODULE$.LockFileName());
        Assertions.assertTrue((boolean)this.fileLocked(lockPath));
        raftManager.shutdown();
        Assertions.assertFalse((boolean)this.fileLocked(lockPath));
    }

    @Test
    public void testLogDirLockWhenBrokerOnlyWithSeparateMetadataDir() {
        .colon.colon logDir = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$);
        Some metadataDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaRaftManager<byte[]> raftManager = this.createRaftManager(new TopicPartition("__raft_id_test", 0), this.createConfig((Set<ProcessRole>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.BrokerRole}))), nodeId, (Seq<Path>)logDir, (Option<Path>)metadataDir));
        Path lockPath = ((Path)metadataDir.getOrElse(() -> RaftManagerTest.$anonfun$testLogDirLockWhenBrokerOnlyWithSeparateMetadataDir$1((Seq)logDir))).resolve(LogManager$.MODULE$.LockFileName());
        Assertions.assertTrue((boolean)this.fileLocked(lockPath));
        raftManager.shutdown();
        Assertions.assertFalse((boolean)this.fileLocked(lockPath));
    }

    public void createMetadataLog(KafkaConfig config) {
        this.createRaftManager(new TopicPartition("__cluster_metadata", 0), config).shutdown();
    }

    public void assertLogDirsExist(Seq<Path> logDirs, Option<Path> metadataLogDir, boolean expectMetadataLog) {
        Assertions.assertTrue((boolean)Files.exists((Path)metadataLogDir.get(), new LinkOption[0]));
        logDirs.foreach((Function1 & Serializable)logDir -> {
            RaftManagerTest.$anonfun$assertLogDirsExist$1(logDir);
            return BoxedUnit.UNIT;
        });
        if (expectMetadataLog) {
            Assertions.assertTrue((boolean)Files.exists(((Path)metadataLogDir.get()).resolve("__cluster_metadata-0"), new LinkOption[0]));
            return;
        }
        Assertions.assertFalse((boolean)Files.exists(((Path)metadataLogDir.get()).resolve("__cluster_metadata-0"), new LinkOption[0]));
    }

    @Test
    public void testMigratingZkBrokerDeletesMetadataLog() {
        .colon.colon logDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$);
        Some metadataLogDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaConfig config = this.createZkBrokerConfig(true, nodeId, (Seq<Path>)logDirs, (Option<Path>)metadataLogDir);
        this.createMetadataLog(config);
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config);
        this.assertLogDirsExist((Seq<Path>)logDirs, (Option<Path>)metadataLogDir, false);
    }

    @Test
    public void testNonMigratingZkBrokerDoesNotDeleteMetadataLog() {
        .colon.colon logDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$);
        Some metadataLogDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaConfig config = this.createZkBrokerConfig(false, nodeId, (Seq<Path>)logDirs, (Option<Path>)metadataLogDir);
        Files.createDirectory(((Path)metadataLogDir.get()).resolve("__cluster_metadata-0"), new FileAttribute[0]);
        RuntimeException err = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config), (String)"Should have not deleted the metadata log");
        Assertions.assertEquals((Object)"Not deleting metadata log dir since migrations are not enabled.", (Object)err.getMessage());
        this.assertLogDirsExist((Seq<Path>)logDirs, (Option<Path>)metadataLogDir, true);
    }

    @Test
    public void testZkBrokerDoesNotDeleteSeparateLogDirs() {
        .colon.colon logDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$));
        Some metadataLogDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaConfig config = this.createZkBrokerConfig(true, nodeId, (Seq<Path>)logDirs, (Option<Path>)metadataLogDir);
        this.createMetadataLog(config);
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config);
        this.assertLogDirsExist((Seq<Path>)logDirs, (Option<Path>)metadataLogDir, false);
    }

    @Test
    public void testZkBrokerDoesNotDeleteSameLogDir() {
        .colon.colon logDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$));
        Option metadataLogDir = logDirs.headOption();
        int nodeId = 1;
        KafkaConfig config = this.createZkBrokerConfig(true, nodeId, (Seq<Path>)logDirs, (Option<Path>)metadataLogDir);
        this.createMetadataLog(config);
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config);
        this.assertLogDirsExist((Seq<Path>)logDirs, (Option<Path>)metadataLogDir, false);
    }

    @Test
    public void testKRaftBrokerDoesNotDeleteMetadataLog() {
        .colon.colon logDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$);
        Some metadataLogDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaConfig config = this.createConfig((Set<ProcessRole>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.BrokerRole}))), nodeId, (Seq<Path>)logDirs, (Option<Path>)metadataLogDir);
        this.createMetadataLog(config);
        Assertions.assertThrows(RuntimeException.class, () -> KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config), (String)"Should not have deleted metadata log");
        this.assertLogDirsExist((Seq<Path>)logDirs, (Option<Path>)metadataLogDir, true);
    }

    private boolean fileLocked(Path path) {
        return BoxesRunTime.unboxToBoolean((Object)Using$.MODULE$.resource((Object)FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE), (Function1 & Serializable)channel -> BoxesRunTime.boxToBoolean((boolean)RaftManagerTest.$anonfun$fileLocked$1(channel)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
    }

    public static final /* synthetic */ Path $anonfun$testLogDirLockWhenControllerOnly$1(Seq logDir$1) {
        return (Path)logDir$1.head();
    }

    public static final /* synthetic */ Path $anonfun$testLogDirLockWhenBrokerOnlyWithSeparateMetadataDir$1(Seq logDir$2) {
        return (Path)logDir$2.head();
    }

    public static final /* synthetic */ void $anonfun$assertLogDirsExist$1(Path logDir) {
        Assertions.assertTrue((boolean)Files.exists(logDir, new LinkOption[0]), (String)"Should not delete log dir");
    }

    public static final /* synthetic */ boolean $anonfun$fileLocked$1(FileChannel channel) {
        try {
            Option$.MODULE$.apply((Object)channel.tryLock()).foreach((Function1 & Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
            return false;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            return true;
        }
    }
}

