/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.server.BrokerLifecycleManager;
import kafka.server.BrokerLifecycleManager$;
import kafka.server.RegistrationTestContext;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@Timeout(value=12L)
@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001B\u0007\u000f\u0001MAQA\u0007\u0001\u0005\u0002mAQA\b\u0001\u0005\u0002}AQ\u0001\u000b\u0001\u0005\u0002%BQA\u000f\u0001\u0005\u0002%BQ\u0001\u0010\u0001\u0005\u0002%BQA\u0010\u0001\u0005\u0002%BQ\u0001\u0011\u0001\u0005\u0002%BQA\u0011\u0001\u0005\u0002\rCQ\u0001\u001b\u0001\u0005\u0002%DQA\u001f\u0001\u0005\u0002%BQ\u0001 \u0001\u0005\u0002%BQA \u0001\u0005\u0002%\u0012!D\u0011:pW\u0016\u0014H*\u001b4fGf\u001cG.Z'b]\u0006<WM\u001d+fgRT!a\u0004\t\u0002\rM,'O^3s\u0015\u0005\t\u0012!B6bM.\f7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001d!\ti\u0002!D\u0001\u000f\u0003A\u0019wN\u001c4jOB\u0013x\u000e]3si&,7/F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003vi&d'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003I!Xm\u001d;De\u0016\fG/Z!oI\u000ecwn]3\u0015\u0003)\u0002\"!F\u0016\n\u000512\"\u0001B+oSRD#a\u0001\u0018\u0011\u0005=BT\"\u0001\u0019\u000b\u0005E\u0012\u0014aA1qS*\u00111\u0007N\u0001\bUV\u0004\u0018\u000e^3s\u0015\t)d'A\u0003kk:LGOC\u00018\u0003\ry'oZ\u0005\u0003sA\u0012A\u0001V3ti\u00069B/Z:u\u0007J,\u0017\r^3Ti\u0006\u0014H/\u00118e\u00072|7/\u001a\u0015\u0003\t9\n!\u0004^3tiN+8mY3tg\u001a,HNU3hSN$(/\u0019;j_:D#!\u0002\u0018\u0002/Q,7\u000f\u001e*fO&\u001cHO]1uS>tG+[7f_V$\bF\u0001\u0004/\u0003Y!Xm\u001d;D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0007FA\u0004/\u0003=\u0001(/\u001a9be\u0016\u0014Vm\u001d9p]N,WC\u0001#N)\r)el\u0019\t\u0004\r&[U\"A$\u000b\u0005!\u0013\u0013AC2p]\u000e,(O]3oi&\u0011!j\u0012\u0002\u0007\rV$XO]3\u0011\u00051kE\u0002\u0001\u0003\u0006\u001d\"\u0011\ra\u0014\u0002\u0002)F\u0011\u0001k\u0015\t\u0003+EK!A\u0015\f\u0003\u000f9{G\u000f[5oOB\u0011A\u000bX\u0007\u0002+*\u0011akV\u0001\te\u0016\fX/Z:ug*\u0011\u0001,W\u0001\u0007G>lWn\u001c8\u000b\u0005EQ&BA.7\u0003\u0019\t\u0007/Y2iK&\u0011Q,\u0016\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti\")q\f\u0003a\u0001A\u0006\u00191\r\u001e=\u0011\u0005u\t\u0017B\u00012\u000f\u0005]\u0011VmZ5tiJ\fG/[8o)\u0016\u001cHoQ8oi\u0016DH\u000fC\u0003e\u0011\u0001\u0007Q-\u0001\u0005sKN\u0004xN\\:f!\t!f-\u0003\u0002h+\n\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/Z\u0001\u0005a>dG.\u0006\u0002kYR!1.\u001d:x!\taE\u000eB\u0003O\u0013\t\u0007Q.\u0005\u0002Q]B\u0011Qc\\\u0005\u0003aZ\u00111!\u00118z\u0011\u0015y\u0016\u00021\u0001a\u0011\u0015\u0019\u0018\u00021\u0001u\u0003\u001di\u0017M\\1hKJ\u0004\"!H;\n\u0005Yt!A\u0006\"s_.,'\u000fT5gK\u000eL8\r\\3NC:\fw-\u001a:\t\u000baL\u0001\u0019A=\u0002\r\u0019,H/\u001e:f!\r1\u0015j[\u0001&i\u0016\u001cH/\u00117xCf\u001c8+\u001a8eg\u0006\u001b7-^7vY\u0006$X\rZ(gM2Lg.\u001a#jeND#A\u0003\u0018\u00029Q,7\u000f\u001e*fO&\u001cHO]1uS>t\u0017J\\2mk\u0012,7\u000fR5sg\"\u00121BL\u0001(i\u0016\u001cHo\u0013:bMRT%i\u0014#NKR\fG-\u0019;b-\u0016\u00148/[8o+B$\u0017\r^3Fm\u0016tG\u000f\u000b\u0002\r]!:\u0001!a\u0001\u0002\n\u0005-\u0001cA\u0018\u0002\u0006%\u0019\u0011q\u0001\u0019\u0003\u000fQKW.Z8vi\u0006)a/\u00197vKz\tA\u0002")
public class BrokerLifecycleManagerTest {
    public Properties configProperties() {
        Properties properties = new Properties();
        properties.setProperty("log.dirs", "/tmp/foo");
        properties.setProperty("process.roles", "broker");
        properties.setProperty("node.id", "1");
        properties.setProperty("controller.quorum.voters", "2@localhost:9093");
        properties.setProperty("controller.listener.names", "SSL");
        properties.setProperty("initial.broker.registration.timeout.ms", "300000");
        properties.setProperty("broker.heartbeat.interval.ms", "100");
        return properties;
    }

    @Test
    public void testCreateAndClose() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        new BrokerLifecycleManager(context.config(), (Time)context.time(), "create-and-close-", false, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"oFoTeS9QT0aAyCyH41v45A")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()).close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateStartAndClose() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "create-start-and-close-", false, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"uiUADXZWTPixVvp6UWFWnw")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6());
        Assertions.assertEquals((Object)BrokerState.NOT_RUNNING, (Object)manager.state());
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testCreateStartAndClose$2(manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var9_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var3_4 = null;
        Object var8_8 = null;
        manager.close();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)manager.state());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulRegistration() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "successful-registration-", false, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"gCpDJgRlS2CBCpxoP2VMsQ")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6());
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.of(10L));
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testSuccessfulRegistration$2(context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var16_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_5 = null;
        Object var9_10 = null;
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testSuccessfulRegistration$3(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var17_17 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var10_12 = null;
        Object var15_16 = null;
        manager.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRegistrationTimeout() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        Node controllerNode = new Node(3000, "localhost", 8021);
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "registration-timeout-", false, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"9XBOAtr4T0Wbx2sbiWh6xg")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6());
        context.controllerNodeProvider().node().set(controllerNode);
        BrokerLifecycleManagerTest.newDuplicateRegistrationResponse$1(context, controllerNode);
        Assertions.assertEquals((int)1, (int)context.mockClient().futureResponses().size());
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$2(context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var22_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_5 = null;
        Object var9_10 = null;
        BrokerLifecycleManagerTest.newDuplicateRegistrationResponse$1(context, controllerNode);
        long l3 = 60000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$3(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var23_17 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var10_12 = null;
        Object var15_16 = null;
        context.time().sleep(300000L);
        long l5 = 60000L;
        TestUtils$ retry_this3 = TestUtils$.MODULE$;
        long l6 = 1L;
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$4(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l6).append(", and then retrying.").toString();
                    Object var24_24 = null;
                    retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l6);
                l6 += package$.MODULE$.min(l6, 1000L);
                continue;
            }
            break;
        }
        Object var16_19 = null;
        Object var21_23 = null;
        manager.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControlledShutdown() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "controlled-shutdown-", false, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"B4RtUz1ySGip3A7ZFYB2dg")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6());
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setIsCaughtUp(true)), controllerNode);
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$2(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var28_10 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_5 = null;
        Object var9_9 = null;
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setIsFenced(false)), controllerNode);
        context.time().sleep(20L);
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$3(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var29_17 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var10_12 = null;
        Object var15_16 = null;
        manager.beginControlledShutdown();
        long l5 = 10000L;
        TestUtils$ retry_this3 = TestUtils$.MODULE$;
        long l6 = 1L;
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$4(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l6).append(", and then retrying.").toString();
                    Object var30_24 = null;
                    retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l6);
                l6 += package$.MODULE$.min(l6, 1000L);
                continue;
            }
            break;
        }
        Object var16_19 = null;
        Object var21_23 = null;
        context.mockClient().respond(body -> {
            if (body instanceof BrokerHeartbeatRequest) {
                Assertions.assertTrue((boolean)((BrokerHeartbeatRequest)body).data().wantShutDown());
                return true;
            }
            return false;
        }, (AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setShouldShutDown(true)));
        long l7 = 10000L;
        TestUtils$ retry_this4 = TestUtils$.MODULE$;
        long l8 = 1L;
        long retry_startTime4 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$6(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime4 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this4.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l8).append(", and then retrying.").toString();
                    Object var31_31 = null;
                    retry_this4.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this4, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l8);
                l8 += package$.MODULE$.min(l8, 1000L);
                continue;
            }
            break;
        }
        Object var22_26 = null;
        Object var27_30 = null;
        manager.controlledShutdownFuture().get();
        manager.close();
    }

    public <T extends AbstractRequest> Future<T> prepareResponse(RegistrationTestContext ctx, AbstractResponse response) {
        CompletableFuture result = new CompletableFuture();
        ctx.mockClient().prepareResponseFrom(body -> result.complete(body), response, ctx.controllerNodeProvider().node().get());
        return result;
    }

    public <T> T poll(RegistrationTestContext ctx, BrokerLifecycleManager manager, Future<T> future) {
        while (ctx.mockChannelManager().unsentQueue().isEmpty()) {
            manager.eventQueue().cancelDeferred("initialRegistrationTimeout");
            if (manager.eventQueue().firstDeferredIfIdling().isPresent()) {
                ctx.time().sleep(5L);
            }
            manager.eventQueue().wakeup();
        }
        while (!future.isDone()) {
            ctx.poll();
        }
        return future.get();
    }

    @Test
    public void testAlwaysSendsAccumulatedOfflineDirs() {
        RegistrationTestContext ctx = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(ctx.config(), (Time)ctx.time(), "offline-dirs-sent-in-heartbeat-", false, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"0IbF1sjhSGG6FNvnrPbqQg")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6());
        Node controllerNode = new Node(3000, "localhost", 8021);
        ctx.controllerNodeProvider().node().set(controllerNode);
        Future registration = this.prepareResponse(ctx, (AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)));
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> ctx.highestMetadataOffset().get(), (NodeToControllerChannelManager)ctx.mockChannelManager(), ctx.clusterId(), ctx.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        this.poll(ctx, manager, registration);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)this.nextHeartbeatDirs$1(ctx, manager));
        manager.propagateDirectoryFailure(Uuid.fromString((String)"h3sC4Yk-Q9-fd0ntJTocCA"), Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"h3sC4Yk-Q9-fd0ntJTocCA"})), (Object)this.nextHeartbeatDirs$1(ctx, manager));
        manager.propagateDirectoryFailure(Uuid.fromString((String)"ej8Q9_d2Ri6FXNiTxKFiow"), Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"h3sC4Yk-Q9-fd0ntJTocCA", "ej8Q9_d2Ri6FXNiTxKFiow"})), (Object)this.nextHeartbeatDirs$1(ctx, manager));
        manager.propagateDirectoryFailure(Uuid.fromString((String)"1iF76HVNRPqC7Y4r6647eg"), Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"h3sC4Yk-Q9-fd0ntJTocCA", "ej8Q9_d2Ri6FXNiTxKFiow", "1iF76HVNRPqC7Y4r6647eg"})), (Object)this.nextHeartbeatDirs$1(ctx, manager));
        manager.close();
    }

    @Test
    public void testRegistrationIncludesDirs() {
        Set logDirs = (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ad5FLIeCTnaQdai5vOjeng", "ybdzUKmYSLK6oiIpI6CPlw"}))).map((Function1 & Serializable)x$1 -> Uuid.fromString((String)x$1));
        RegistrationTestContext ctx = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(ctx.config(), (Time)ctx.time(), "registration-includes-dirs-", false, logDirs, BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6());
        Node controllerNode = new Node(3000, "localhost", 8021);
        ctx.controllerNodeProvider().node().set(controllerNode);
        Future registration = this.prepareResponse(ctx, (AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)));
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> ctx.highestMetadataOffset().get(), (NodeToControllerChannelManager)ctx.mockChannelManager(), ctx.clusterId(), ctx.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        BrokerRegistrationRequest request = (BrokerRegistrationRequest)this.poll(ctx, manager, registration);
        Assertions.assertEquals((Object)logDirs, (Object)CollectionConverters$.MODULE$.ListHasAsScala(request.data().logDirs()).asScala().toSet());
        manager.close();
    }

    @Test
    public void testKraftJBODMetadataVersionUpdateEvent() {
        RegistrationTestContext ctx = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(ctx.config(), (Time)ctx.time(), "jbod-metadata-version-update", false, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"gCpDJgRlS2CBCpxoP2VMsQ")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6());
        Node controllerNode = new Node(3000, "localhost", 8021);
        ctx.controllerNodeProvider().node().set(controllerNode);
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> ctx.highestMetadataOffset().get(), (NodeToControllerChannelManager)ctx.mockChannelManager(), ctx.clusterId(), ctx.advertisedListeners(), Collections.emptyMap(), OptionalLong.of(10L));
        Assertions.assertEquals((long)10L, (long)this.nextRegistrationRequest$1(1000L, ctx, manager).data().previousBrokerEpoch());
        this.nextHeartbeatRequest$1(ctx, manager);
        Assertions.assertEquals((long)1000L, (long)manager.brokerEpoch());
        manager.resendBrokerRegistrationUnlessZkMode();
        this.nextRegistrationRequest$1(1200L, ctx, manager);
        this.nextHeartbeatRequest$1(ctx, manager);
        Assertions.assertEquals((long)1200L, (long)manager.brokerEpoch());
        manager.close();
    }

    public static final /* synthetic */ void $anonfun$testCreateStartAndClose$2(BrokerLifecycleManager manager$1) {
        Assertions.assertEquals((Object)BrokerState.STARTING, (Object)manager$1.state());
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulRegistration$2(RegistrationTestContext context$2) {
        Assertions.assertEquals((int)1, (int)context$2.mockChannelManager().unsentQueue().size());
        Assertions.assertEquals((long)10L, (long)((BrokerRegistrationRequest)context$2.mockChannelManager().unsentQueue().getFirst().request().build()).data().previousBrokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulRegistration$3(RegistrationTestContext context$2, BrokerLifecycleManager manager$2) {
        context$2.poll();
        Assertions.assertEquals((long)1000L, (long)manager$2.brokerEpoch());
    }

    private static final void newDuplicateRegistrationResponse$1(RegistrationTestContext context$3, Node controllerNode$1) {
        context$3.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setErrorCode(Errors.DUPLICATE_BROKER_REGISTRATION.code())), controllerNode$1);
        context$3.mockChannelManager().poll();
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$2(RegistrationTestContext context$3) {
        context$3.poll();
        Assertions.assertEquals((int)0, (int)context$3.mockClient().futureResponses().size());
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$3(RegistrationTestContext context$3, BrokerLifecycleManager manager$3) {
        context$3.time().sleep(100L);
        context$3.poll();
        manager$3.eventQueue().wakeup();
        Assertions.assertEquals((int)0, (int)context$3.mockClient().futureResponses().size());
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$4(RegistrationTestContext context$3, BrokerLifecycleManager manager$3) {
        context$3.poll();
        manager$3.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)manager$3.state());
        Assertions.assertTrue((boolean)manager$3.initialCatchUpFuture().isCompletedExceptionally());
        Assertions.assertEquals((long)-1L, (long)manager$3.brokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$2(RegistrationTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.RECOVERY, (Object)manager$4.state());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$3(RegistrationTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)manager$4.state());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$4(RegistrationTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.PENDING_CONTROLLED_SHUTDOWN, (Object)manager$4.state());
        Assertions.assertTrue((boolean)context$4.mockClient().hasInFlightRequests());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$6(RegistrationTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)manager$4.state());
    }

    private final Set nextHeartbeatDirs$1(RegistrationTestContext ctx$1, BrokerLifecycleManager manager$5) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((BrokerHeartbeatRequest)this.poll(ctx$1, manager$5, this.prepareResponse(ctx$1, (AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData())))).data().offlineLogDirs()).asScala().map((Function1 & Serializable)x$1 -> x$1.toString())).toSet();
    }

    private final AbstractRequest doPoll$1(AbstractResponse response, RegistrationTestContext ctx$3, BrokerLifecycleManager manager$6) {
        return (AbstractRequest)this.poll(ctx$3, manager$6, this.prepareResponse(ctx$3, response));
    }

    private final AbstractRequest nextHeartbeatRequest$1(RegistrationTestContext ctx$3, BrokerLifecycleManager manager$6) {
        return this.doPoll$1((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData()), ctx$3, manager$6);
    }

    private final BrokerRegistrationRequest nextRegistrationRequest$1(long epoch, RegistrationTestContext ctx$3, BrokerLifecycleManager manager$6) {
        return (BrokerRegistrationRequest)this.doPoll$1((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(epoch)), ctx$3, manager$6);
    }
}

