/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import kafka.server.GroupCoordinatorBaseRequestTest;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupDescribeRequestData;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ConsumerGroupDescribeRequest;
import org.apache.kafka.common.requests.ConsumerGroupDescribeResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.security.authorizer.AclEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(types={Type.KRAFT}, brokers=1)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005Q4A!\u0002\u0004\u0001\u0017!A\u0001\u0003\u0001B\u0001B\u0003%\u0011\u0003C\u0003\u0018\u0001\u0011\u0005\u0001\u0004C\u0003\u001c\u0001\u0011\u0005A\u0004C\u00032\u0001\u0011\u0005ADA\u0011D_:\u001cX/\\3s\u000fJ|W\u000f\u001d#fg\u000e\u0014\u0018NY3SKF,Xm\u001d;t)\u0016\u001cHO\u0003\u0002\b\u0011\u000511/\u001a:wKJT\u0011!C\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\ta!\u0003\u0002\u0010\r\tyrI]8va\u000e{wN\u001d3j]\u0006$xN\u001d\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\u000f\rdWo\u001d;feB\u0011!#F\u0007\u0002')\u0011A\u0003C\u0001\u0005i\u0016\u001cH/\u0003\u0002\u0017'\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u00033i\u0001\"!\u0004\u0001\t\u000bA\u0011\u0001\u0019A\t\u0002[Q,7\u000f^\"p]N,X.\u001a:He>,\b\u000fR3tGJL'-Z,ji\"Tvn\\6fKB,'o\u00117vgR,'\u000fF\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0011)f.\u001b;)\t\r!#f\u000b\t\u0003K!j\u0011A\n\u0006\u0003OM\t!\"\u00198o_R\fG/[8o\u0013\tIcEA\u0006DYV\u001cH/\u001a:UKN$\u0018!\u0002;za\u0016\u001cH&\u0001\u0017%\u00035J!AL\u0018\u0002\u0005i[%B\u0001\u0019'\u0003\u0011!\u0016\u0010]3\u0002aQ,7\u000f^\"p]N,X.\u001a:He>,\b\u000fR3tGJL'-Z,ji\"tUm^$s_V\u00048i\\8sI&t\u0017\r^8sQ\u0019!AEK\u001a8q1\nA\u0007J\u00016\u0013\t1t&A\u0003L%\u00063E+\u0001\ttKJ4XM\u001d)s_B,'\u000f^5fg2\u001a\u0011h\u0011%,\u000bijd\bQ!\u0011\u0005\u0015Z\u0014B\u0001\u001f'\u0005U\u0019E.^:uKJ\u001cuN\u001c4jOB\u0013x\u000e]3sif\f1a[3zC\u0005y\u0014!J4s_V\u0004hfY8pe\u0012Lg.\u0019;pe:\u0012XMY1mC:\u001cWM\f9s_R|7m\u001c7t\u0003\u00151\u0018\r\\;fC\u0005\u0011\u0015\u0001E2mCN\u001c\u0018n\u0019\u0017d_:\u001cX/\\3sW\u0015QT\b\u0012!GC\u0005)\u0015\u0001H8gMN,Go\u001d\u0018u_BL7M\f8v[:\u0002\u0018M\u001d;ji&|gn]\u0011\u0002\u000f\u0006\t\u0011gK\u0003;{%\u0003e)I\u0001K\u0003\u0001zgMZ:fiNtCo\u001c9jG:\u0012X\r\u001d7jG\u0006$\u0018n\u001c8/M\u0006\u001cGo\u001c:)\t\u0001a\u0005\t\u0017\t\u0003\u001bZk\u0011A\u0014\u0006\u0003\u001fB\u000b1!\u00199j\u0015\t\t&+A\u0004kkBLG/\u001a:\u000b\u0005M#\u0016!\u00026v]&$(\"A+\u0002\u0007=\u0014x-\u0003\u0002X\u001d\n9A+[7f_V$h$\u0001=)\t\u0001Q\u0006\t\u0019\t\u00037zk\u0011\u0001\u0018\u0006\u0003;:\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005}c&AC#yi\u0016tGmV5uQ2\n\u0011mI\u0001c!\t\u0019W-D\u0001e\u0015\t\u00196#\u0003\u0002gI\n)2\t\\;ti\u0016\u0014H+Z:u\u000bb$XM\\:j_:\u001c\bF\u0002\u0001iU-dW\u000e\u0005\u0002&S&\u0011!N\n\u0002\u0014\u00072,8\u000f^3s)\u0016\u001cH\u000fR3gCVdGo\u001d\u0017\u0002i\u00059!M]8lKJ\u001cX$A\u0001)\t\u0001y\u0007I\u001d\t\u0003\u001bBL!!\u001d(\u0003\u0007Q\u000bw-I\u0001t\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8")
public class ConsumerGroupDescribeRequestsTest
extends GroupCoordinatorBaseRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest(types={Type.ZK})
    public void testConsumerGroupDescribeWithZookeeperCluster() {
        ConsumerGroupDescribeRequest consumerGroupDescribeRequest = new ConsumerGroupDescribeRequest.Builder(new ConsumerGroupDescribeRequestData().setGroupIds(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"grp-1", (List)new .colon.colon((Object)"grp-2", (List)Nil$.MODULE$))).asJava())).build(ApiKeys.CONSUMER_GROUP_DESCRIBE.latestVersion(this.isUnstableApiEnabled()));
        ConsumerGroupDescribeResponse consumerGroupDescribeResponse = (ConsumerGroupDescribeResponse)this.connectAndReceive((AbstractRequest)consumerGroupDescribeRequest, ClassTag$.MODULE$.apply(ConsumerGroupDescribeResponse.class));
        ConsumerGroupDescribeResponseData expectedResponse = new ConsumerGroupDescribeResponseData();
        expectedResponse.groups().add(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("grp-1").setErrorCode(Errors.UNSUPPORTED_VERSION.code()));
        expectedResponse.groups().add(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("grp-2").setErrorCode(Errors.UNSUPPORTED_VERSION.code()));
        Assertions.assertEquals((Object)expectedResponse, (Object)consumerGroupDescribeResponse.data());
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testConsumerGroupDescribeWithNewGroupCoordinator() {
        this.createOffsetsTopic();
        Admin admin = this.cluster.createAdminClient();
        Uuid topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        int timeoutMs = 300000;
        String clientId = "client-id";
        String clientHost = "/127.0.0.1";
        int authorizedOperationsInt = Utils.to32BitField((Set)CollectionConverters$.MODULE$.MutableSetHasAsJava((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(AclEntry.supportedOperations((ResourceType)ResourceType.GROUP)).asScala().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToByte((byte)x$1.code()))).asJava());
        ObjectRef grp1Member1Response = ObjectRef.create(null);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            .colon.colon $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$3 = new .colon.colon((Object)"bar", (List)Nil$.MODULE$);
            List $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$4 = package$.MODULE$.List().empty();
            String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$5 = this.consumerGroupHeartbeat$default$2();
            int $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$6 = this.consumerGroupHeartbeat$default$3();
            String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$7 = this.consumerGroupHeartbeat$default$4();
            String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$8 = this.consumerGroupHeartbeat$default$5();
            String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$9 = this.consumerGroupHeartbeat$default$7();
            Errors $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$10 = this.consumerGroupHeartbeat$default$10();
            grp1Member1Response.elem = this.consumerGroupHeartbeat("grp-1", $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$5, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$6, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$7, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$8, timeoutMs, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$9, (List<String>)$anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$3, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)$anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$4, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$10);
            Object var28_15 = null;
            Object var29_16 = null;
            Object var30_17 = null;
            Object var32_11 = null;
            Object var33_12 = null;
            Object var34_13 = null;
            Object var35_14 = null;
            if (((ConsumerGroupHeartbeatResponseData)grp1Member1Response.elem).errorCode() == Errors.NONE.code()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(54).append("Could not join the group successfully. Last response ").append((ConsumerGroupHeartbeatResponseData)grp1Member1Response.elem).append(".").toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ObjectRef grp2Member1Response = ObjectRef.create(null);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            .colon.colon $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$15 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
            List $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$16 = package$.MODULE$.List().empty();
            int $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$17 = this.consumerGroupHeartbeat$default$3();
            String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$18 = this.consumerGroupHeartbeat$default$4();
            String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$19 = this.consumerGroupHeartbeat$default$5();
            Errors $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$20 = this.consumerGroupHeartbeat$default$10();
            grp2Member1Response.elem = this.consumerGroupHeartbeat("grp-2", "member-1", $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$17, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$18, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$19, timeoutMs, "range", (List<String>)$anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$15, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)$anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$16, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$20);
            Object var36_23 = null;
            Object var37_24 = null;
            Object var39_26 = null;
            Object var40_27 = null;
            Object var41_28 = null;
            if (((ConsumerGroupHeartbeatResponseData)grp2Member1Response.elem).assignment() != null && !((ConsumerGroupHeartbeatResponseData)grp2Member1Response.elem).assignment().topicPartitions().isEmpty()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)new StringBuilder(54).append("Could not join the group successfully. Last response ").append((ConsumerGroupHeartbeatResponseData)grp2Member1Response.elem).append(".").toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        .colon.colon x$25 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$26 = package$.MODULE$.List().empty();
        int x$27 = this.consumerGroupHeartbeat$default$3();
        String x$28 = this.consumerGroupHeartbeat$default$4();
        String x$29 = this.consumerGroupHeartbeat$default$5();
        Errors x$30 = this.consumerGroupHeartbeat$default$10();
        ConsumerGroupHeartbeatResponseData grp2Member2Response = this.consumerGroupHeartbeat("grp-2", "member-2", x$27, x$28, x$29, timeoutMs, "range", (List<String>)x$25, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$26, x$30);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.CONSUMER_GROUP_DESCRIBE.oldestVersion()), (int)ApiKeys.CONSUMER_GROUP_DESCRIBE.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            .colon.colon expected = new .colon.colon((Object)new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("grp-1").setGroupState(ConsumerGroupState.STABLE.toString()).setGroupEpoch(1).setAssignmentEpoch(1).setAssignorName("uniform").setAuthorizedOperations(authorizedOperationsInt).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupDescribeResponseData.Member().setMemberId(((ConsumerGroupHeartbeatResponseData)grp1Member1Response$1.elem).memberId()).setMemberEpoch(((ConsumerGroupHeartbeatResponseData)grp1Member1Response$1.elem).memberEpoch()).setClientId(clientId).setClientHost(clientHost).setSubscribedTopicRegex("").setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"bar", (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("grp-2").setGroupState(ConsumerGroupState.RECONCILING.toString()).setGroupEpoch(grp2Member2Response.memberEpoch()).setAssignmentEpoch(grp2Member2Response.memberEpoch()).setAssignorName("range").setAuthorizedOperations(authorizedOperationsInt).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupDescribeResponseData.Member().setMemberId(grp2Member2Response.memberId()).setMemberEpoch(grp2Member2Response.memberEpoch()).setClientId(clientId).setClientHost(clientHost).setSubscribedTopicRegex("").setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setAssignment(new ConsumerGroupDescribeResponseData.Assignment()).setTargetAssignment(new ConsumerGroupDescribeResponseData.Assignment().setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupDescribeResponseData.TopicPartitions().setTopicId(topicId).setTopicName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava())), (List)new .colon.colon((Object)new ConsumerGroupDescribeResponseData.Member().setMemberId(((ConsumerGroupHeartbeatResponseData)grp2Member1Response$1.elem).memberId()).setMemberEpoch(((ConsumerGroupHeartbeatResponseData)grp2Member1Response$1.elem).memberEpoch()).setClientId(clientId).setClientHost(clientHost).setSubscribedTopicRegex("").setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setAssignment(new ConsumerGroupDescribeResponseData.Assignment().setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupDescribeResponseData.TopicPartitions().setTopicId(topicId).setTopicName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava()), (List)Nil$.MODULE$)).asJava())).setTargetAssignment(new ConsumerGroupDescribeResponseData.Assignment().setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupDescribeResponseData.TopicPartitions().setTopicId(topicId).setTopicName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$)).asJava())), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$));
            List<ConsumerGroupDescribeResponseData.DescribedGroup> actual = this.consumerGroupDescribe((List<String>)new .colon.colon((Object)"grp-1", (List)new .colon.colon((Object)"grp-2", (List)Nil$.MODULE$)), true, (short)version);
            Assertions.assertEquals((Object)expected, actual);
        });
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2(ConsumerGroupDescribeRequestsTest $this, ObjectRef grp1Member1Response$1, int timeoutMs$1) {
        .colon.colon x$3 = new .colon.colon((Object)"bar", (List)Nil$.MODULE$);
        List x$4 = package$.MODULE$.List().empty();
        String x$5 = $this.consumerGroupHeartbeat$default$2();
        int x$6 = $this.consumerGroupHeartbeat$default$3();
        String x$7 = $this.consumerGroupHeartbeat$default$4();
        String x$8 = $this.consumerGroupHeartbeat$default$5();
        String x$9 = $this.consumerGroupHeartbeat$default$7();
        Errors x$10 = $this.consumerGroupHeartbeat$default$10();
        grp1Member1Response$1.elem = $this.consumerGroupHeartbeat("grp-1", x$5, x$6, x$7, x$8, timeoutMs$1, x$9, (List<String>)x$3, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$4, x$10);
        return ((ConsumerGroupHeartbeatResponseData)grp1Member1Response$1.elem).errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$3(ObjectRef grp1Member1Response$1) {
        return new StringBuilder(54).append("Could not join the group successfully. Last response ").append((ConsumerGroupHeartbeatResponseData)grp1Member1Response$1.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4(ConsumerGroupDescribeRequestsTest $this, ObjectRef grp2Member1Response$1, int timeoutMs$1) {
        .colon.colon x$15 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$16 = package$.MODULE$.List().empty();
        int x$17 = $this.consumerGroupHeartbeat$default$3();
        String x$18 = $this.consumerGroupHeartbeat$default$4();
        String x$19 = $this.consumerGroupHeartbeat$default$5();
        Errors x$20 = $this.consumerGroupHeartbeat$default$10();
        grp2Member1Response$1.elem = $this.consumerGroupHeartbeat("grp-2", "member-1", x$17, x$18, x$19, timeoutMs$1, "range", (List<String>)x$15, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$16, x$20);
        return ((ConsumerGroupHeartbeatResponseData)grp2Member1Response$1.elem).assignment() != null && !((ConsumerGroupHeartbeatResponseData)grp2Member1Response$1.elem).assignment().topicPartitions().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$5(ObjectRef grp2Member1Response$1) {
        return new StringBuilder(54).append("Could not join the group successfully. Last response ").append((ConsumerGroupHeartbeatResponseData)grp2Member1Response$1.elem).append(".").toString();
    }

    public ConsumerGroupDescribeRequestsTest(ClusterInstance cluster) {
        this.cluster = cluster;
        super(cluster);
    }
}

