/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.zk.ReassignPartitionsZNode$;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u00194A!\u0005\n\u0001/!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0013\u0019\u0003B\u0002\u0017\u0001A\u0003%A\u0005C\u0004.\u0001\t\u0007I\u0011\u0002\u0018\t\rI\u0002\u0001\u0015!\u00030\u0011\u001d\u0019\u0004A1A\u0005\n9Ba\u0001\u000e\u0001!\u0002\u0013y\u0003bB\u001b\u0001\u0005\u0004%IA\f\u0005\u0007m\u0001\u0001\u000b\u0011B\u0018\t\u000f]\u0002!\u0019!C\u0005q!1q\n\u0001Q\u0001\neBq\u0001\u0015\u0001C\u0002\u0013%1\u0005\u0003\u0004R\u0001\u0001\u0006I\u0001\n\u0005\u0006%\u0002!\ta\u0015\u0005\u0006E\u0002!\ta\u0015\u0005\u0006I\u0002!\ta\u0015\u0002\u001c%\u0016\f7o]5h]B\u000b'\u000f^5uS>t7O\u0017(pI\u0016$Vm\u001d;\u000b\u0005M!\u0012A\u0001>l\u0015\u0005)\u0012!B6bM.\f7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u0013\u0003\u0015!x\u000e]5d+\u0005!\u0003CA\u0013+\u001b\u00051#BA\u0014)\u0003\u0011a\u0017M\\4\u000b\u0003%\nAA[1wC&\u00111F\n\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003)\u0001\u0018M\u001d;ji&|g.M\u000b\u0002_A\u0011\u0011\u0004M\u0005\u0003ci\u00111!\u00138u\u0003-\u0001\u0018M\u001d;ji&|g.\r\u0011\u0002\u0011I,\u0007\u000f\\5dCF\n\u0011B]3qY&\u001c\u0017-\r\u0011\u0002\u0011I,\u0007\u000f\\5dCJ\n\u0011B]3qY&\u001c\u0017M\r\u0011\u0002+I,\u0017m]:jO:\u0004\u0016M\u001d;ji&|g\u000eR1uCV\t\u0011\b\u0005\u0003;\u007f\u0005cU\"A\u001e\u000b\u0005qj\u0014!C5n[V$\u0018M\u00197f\u0015\tq$$\u0001\u0006d_2dWm\u0019;j_:L!\u0001Q\u001e\u0003\u00075\u000b\u0007\u000f\u0005\u0002C\u00156\t1I\u0003\u0002E\u000b\u000611m\\7n_:T!!\u0006$\u000b\u0005\u001dC\u0015AB1qC\u000eDWMC\u0001J\u0003\ry'oZ\u0005\u0003\u0017\u000e\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002;\u001b>J!AT\u001e\u0003\u0007M+\u0017/\u0001\fsK\u0006\u001c8/[4o!\u0006\u0014H/\u001b;j_:$\u0015\r^1!\u0003A\u0011X-Y:tS\u001etW.\u001a8u\u0015N|g.A\tsK\u0006\u001c8/[4o[\u0016tGOS:p]\u0002\n!\u0002^3ti\u0016s7m\u001c3f)\u0005!\u0006CA\rV\u0013\t1&D\u0001\u0003V]&$\bF\u0001\bY!\tI\u0006-D\u0001[\u0015\tYF,A\u0002ba&T!!\u00180\u0002\u000f),\b/\u001b;fe*\u0011q\fS\u0001\u0006UVt\u0017\u000e^\u0005\u0003Cj\u0013A\u0001V3ti\u0006)B/Z:u\t\u0016\u001cw\u000eZ3J]Z\fG.\u001b3Kg>t\u0007FA\bY\u0003M!Xm\u001d;EK\u000e|G-\u001a,bY&$'j]8oQ\t\u0001\u0002\f")
public class ReassignPartitionsZNodeTest {
    private final String topic;
    private final int partition1;
    private final int replica1;
    private final int replica2;
    private final Map<TopicPartition, scala.collection.immutable.Seq<Object>> reassignPartitionData = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), this.partition1())), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.replica1(), this.replica2()})))}));
    private final String reassignmentJson;

    private String topic() {
        return this.topic;
    }

    private int partition1() {
        return this.partition1;
    }

    private int replica1() {
        return this.replica1;
    }

    private int replica2() {
        return this.replica2;
    }

    private Map<TopicPartition, scala.collection.immutable.Seq<Object>> reassignPartitionData() {
        return this.reassignPartitionData;
    }

    private String reassignmentJson() {
        return this.reassignmentJson;
    }

    @Test
    public void testEncode() {
        String encodedJsonString = new String(ReassignPartitionsZNode$.MODULE$.encode(this.reassignPartitionData()), StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)this.reassignmentJson(), (Object)encodedJsonString);
    }

    @Test
    public void testDecodeInvalidJson() {
        Either result = ReassignPartitionsZNode$.MODULE$.decode("invalid json".getBytes());
        Assertions.assertTrue((boolean)((JsonProcessingException)result.left().getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(34).append("decode should have failed, result ").append(result).toString());
        }) instanceof JsonProcessingException));
    }

    @Test
    public void testDecodeValidJson() {
        Either replicas = ReassignPartitionsZNode$.MODULE$.decode(this.reassignmentJson().getBytes()).map((Function1 & Serializable)assignmentMap -> (Seq)assignmentMap.apply((Object)new TopicPartition(this.topic(), this.partition1())));
        Assertions.assertEquals((Object)new Right((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.replica1(), this.replica2()}))), (Object)replicas);
    }

    public ReassignPartitionsZNodeTest() {
        this.topic = "foo";
        this.partition1 = 0;
        this.replica1 = 1;
        this.replica2 = 2;
        this.reassignmentJson = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[1,2]}]}";
    }
}

