/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.splitter;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.widget.splitter.IBorderLayout;
import com.googlecode.wicket.kendo.ui.widget.splitter.ISplitterListener;
import com.googlecode.wicket.kendo.ui.widget.splitter.SplitterBehavior;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;

public class BorderLayout
extends WebMarkupContainer
implements IBorderLayout,
ISplitterListener {
    private static final long serialVersionUID = 1L;

    public BorderLayout(String id) {
        super(id);
    }

    @Override
    public boolean isExpandEventEnabled() {
        return false;
    }

    @Override
    public boolean isCollapseEventEnabled() {
        return false;
    }

    @Override
    public void addBorderLayout(MarkupContainer container) {
        container.add(new Behavior[]{this.newVerticalSplitterBehavior("#vertical", this.getVerticalPanes())});
        container.add(new Behavior[]{this.newHorizontalSplitterBehavior("#horizontal", this.getHorizontalPanes())});
    }

    public void expand(IPartialPageRequestHandler handler, String selector, String pane) {
        handler.appendJavaScript((CharSequence)String.format("$('%s').data('%s').expand('%s');", selector, "kendoSplitter", pane));
    }

    public void collapse(IPartialPageRequestHandler handler, String selector, String pane) {
        handler.appendJavaScript((CharSequence)String.format("$('%s').data('%s').collapse('%s');", selector, "kendoSplitter", pane));
    }

    protected void onInitialize() {
        super.onInitialize();
        this.addBorderLayout((MarkupContainer)this);
    }

    @Override
    public void onExpand(AjaxRequestTarget target, String paneId) {
    }

    @Override
    public void onCollapse(AjaxRequestTarget target, String paneId) {
    }

    @Override
    public String getVerticalPanes() {
        return "[ { resizable: false, size: '15%' }, {  }, { collapsible: true, size: '15%' } ]";
    }

    @Override
    public String getHorizontalPanes() {
        return "[ { size: '15%' }, { }, { size: '15%' } ]";
    }

    protected SplitterBehavior newVerticalSplitterBehavior(String selector, String panes) {
        Options options = new Options();
        options.set("panes", (Object)panes);
        options.set("orientation", (Object)Options.asString((String)"vertical"));
        return new SplitterBehavior(selector, options, this);
    }

    protected SplitterBehavior newHorizontalSplitterBehavior(String selector, String panes) {
        Options options = new Options();
        options.set("panes", (Object)panes);
        return new SplitterBehavior(selector, options, this);
    }
}

