/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.dao.search;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;

public class SearchCond
extends AbstractSearchCond {
    private static final long serialVersionUID = 661560782247499526L;
    private Type type;
    private AbstractSearchCond leaf;
    private SearchCond left;
    private SearchCond right;

    public static SearchCond of(AbstractSearchCond leaf) {
        SearchCond cond;
        if (leaf instanceof SearchCond) {
            SearchCond searchCond;
            cond = searchCond = (SearchCond)leaf;
        } else {
            cond = new SearchCond();
            cond.leaf = leaf;
        }
        cond.type = Type.LEAF;
        return cond;
    }

    public static SearchCond negate(AbstractSearchCond leaf) {
        SearchCond cond = SearchCond.of(leaf);
        cond.type = Type.NOT_LEAF;
        return cond;
    }

    private static SearchCond and(SearchCond left, SearchCond right) {
        SearchCond cond = new SearchCond();
        cond.type = Type.AND;
        cond.left = left;
        cond.right = right;
        return cond;
    }

    public static SearchCond and(List<SearchCond> conditions) {
        if (conditions.size() == 1) {
            return conditions.getFirst();
        }
        if (conditions.size() > 2) {
            return SearchCond.and(conditions.getFirst(), SearchCond.and(conditions.subList(1, conditions.size())));
        }
        return SearchCond.and(conditions.get(0), conditions.get(1));
    }

    public static SearchCond and(SearchCond ... conditions) {
        return SearchCond.and(Arrays.asList(conditions));
    }

    private static SearchCond or(SearchCond left, SearchCond right) {
        SearchCond cond = new SearchCond();
        cond.type = Type.OR;
        cond.left = left;
        cond.right = right;
        return cond;
    }

    public static SearchCond or(List<SearchCond> conditions) {
        if (conditions.size() == 1) {
            return conditions.getFirst();
        }
        if (conditions.size() > 2) {
            return SearchCond.or(conditions.getFirst(), SearchCond.or(conditions.subList(1, conditions.size())));
        }
        return SearchCond.or(conditions.get(0), conditions.get(1));
    }

    public static SearchCond or(SearchCond ... conditions) {
        return SearchCond.or(Arrays.asList(conditions));
    }

    public Optional<AnyTypeCond> getAnyTypeCond() {
        AnyTypeCond anyTypeCond;
        AbstractSearchCond abstractSearchCond = this.leaf;
        return Optional.ofNullable(abstractSearchCond instanceof AnyTypeCond ? (anyTypeCond = (AnyTypeCond)abstractSearchCond) : null);
    }

    public String hasAnyTypeCond() {
        String anyTypeName = null;
        if (this.type == null) {
            return null;
        }
        switch (this.type.ordinal()) {
            case 0: 
            case 1: {
                AbstractSearchCond abstractSearchCond = this.leaf;
                if (!(abstractSearchCond instanceof AnyTypeCond)) break;
                AnyTypeCond anyTypeCond = (AnyTypeCond)abstractSearchCond;
                anyTypeName = anyTypeCond.getAnyTypeKey();
                break;
            }
            case 2: 
            case 3: {
                if (this.left != null) {
                    anyTypeName = this.left.hasAnyTypeCond();
                }
                if (anyTypeName != null || this.right == null) break;
                anyTypeName = this.right.hasAnyTypeCond();
                break;
            }
        }
        return anyTypeName;
    }

    public <T extends AbstractSearchCond> Optional<T> asLeaf(Class<T> clazz) {
        return Optional.ofNullable(clazz.isInstance(this.leaf) ? this.leaf : null);
    }

    public SearchCond getLeft() {
        return this.left;
    }

    public SearchCond getRight() {
        return this.right;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isValid() {
        boolean isValid = false;
        if (this.type == null) {
            return false;
        }
        switch (this.type.ordinal()) {
            case 0: 
            case 1: {
                isValid = this.leaf != null && this.leaf.isValid();
                break;
            }
            case 2: 
            case 3: {
                isValid = this.left != null && this.right != null && this.left.isValid() && this.right.isValid();
                break;
            }
        }
        return isValid;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.type).append((Object)this.leaf).append((Object)this.left).append((Object)this.right).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchCond other = (SearchCond)obj;
        return new EqualsBuilder().append((Object)this.type, (Object)other.type).append((Object)this.leaf, (Object)other.leaf).append((Object)this.left, (Object)other.left).append((Object)this.right, (Object)other.right).build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.type).append((Object)this.leaf).append((Object)this.left).append((Object)this.right).build();
    }

    public static enum Type {
        LEAF,
        NOT_LEAF,
        AND,
        OR;

    }
}

