/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.SimpleObjectProvider;
import org.springframework.cloud.client.loadbalancer.reactive.DeferringLoadBalancerExchangeFilterFunction;
import org.springframework.context.ApplicationContext;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

public class LoadBalancerWebClientBuilderBeanPostProcessor
implements BeanPostProcessor {
    private final ObjectProvider<DeferringLoadBalancerExchangeFilterFunction> exchangeFilterFunctionObjectProvider;
    private final ApplicationContext context;

    @Deprecated(forRemoval=true)
    public LoadBalancerWebClientBuilderBeanPostProcessor(DeferringLoadBalancerExchangeFilterFunction exchangeFilterFunction, ApplicationContext context) {
        this.exchangeFilterFunctionObjectProvider = new SimpleObjectProvider<DeferringLoadBalancerExchangeFilterFunction>(exchangeFilterFunction);
        this.context = context;
    }

    public LoadBalancerWebClientBuilderBeanPostProcessor(ObjectProvider<DeferringLoadBalancerExchangeFilterFunction> exchangeFilterFunction, ApplicationContext context) {
        this.exchangeFilterFunctionObjectProvider = exchangeFilterFunction;
        this.context = context;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof WebClient.Builder) {
            if (this.context.findAnnotationOnBean(beanName, LoadBalanced.class) == null) {
                return bean;
            }
            DeferringLoadBalancerExchangeFilterFunction exchangeFilterFunction = (DeferringLoadBalancerExchangeFilterFunction)this.exchangeFilterFunctionObjectProvider.getIfAvailable();
            if (exchangeFilterFunction == null) {
                throw new IllegalStateException("LoadBalancerExchangeFilterFunction not found");
            }
            ((WebClient.Builder)bean).filter((ExchangeFilterFunction)this.exchangeFilterFunctionObjectProvider.getIfAvailable());
        }
        return bean;
    }
}

