/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.OAuth20TokenExchangeTypes;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.token.device.InvalidOAuth20DeviceTokenException;
import org.apereo.cas.support.oauth.validator.token.device.ThrottledOAuth20DeviceUserCodeApprovalException;
import org.apereo.cas.support.oauth.validator.token.device.UnapprovedOAuth20DeviceUserCodeException;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCode;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCodeFactory;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20DefaultTokenGenerator
implements OAuth20TokenGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20DefaultTokenGenerator.class);
    protected final TicketFactory ticketFactory;
    protected final TicketRegistry ticketRegistry;
    protected final PrincipalResolver principalResolver;
    protected final OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter;
    protected final CasConfigurationProperties casProperties;

    private static OAuth20TokenGeneratedResult generateAccessTokenResult(AccessTokenRequestContext tokenRequestContext, AccessAndRefreshTokens accessAndRefreshTokens) {
        return OAuth20TokenGeneratedResult.builder().registeredService((RegisteredService)tokenRequestContext.getRegisteredService()).accessToken(accessAndRefreshTokens.accessToken()).refreshToken(accessAndRefreshTokens.refreshToken()).grantType(tokenRequestContext.getGrantType()).responseType(tokenRequestContext.getResponseType()).build();
    }

    public OAuth20TokenGeneratedResult generate(AccessTokenRequestContext tokenRequestContext) throws Throwable {
        if (OAuth20ResponseTypes.DEVICE_CODE == tokenRequestContext.getResponseType()) {
            return this.generateAccessTokenOAuthDeviceCodeResponseType(tokenRequestContext);
        }
        AccessAndRefreshTokens accessAndRefreshTokens = this.generateAccessTokenOAuthGrantTypes(tokenRequestContext);
        return OAuth20DefaultTokenGenerator.generateAccessTokenResult(tokenRequestContext, accessAndRefreshTokens);
    }

    protected OAuth20TokenGeneratedResult generateAccessTokenOAuthDeviceCodeResponseType(AccessTokenRequestContext tokenRequestContext) throws Throwable {
        String deviceCode = tokenRequestContext.getDeviceCode();
        if (StringUtils.isNotBlank((CharSequence)deviceCode)) {
            OAuth20DeviceToken deviceCodeTicket = this.getDeviceTokenFromTicketRegistry(deviceCode);
            OAuth20DeviceUserCode deviceUserCode = this.getDeviceUserCodeFromRegistry(deviceCodeTicket);
            if (deviceUserCode.isUserCodeApproved()) {
                LOGGER.debug("Provided user code [{}] linked to device code [{}] is approved", (Object)deviceCodeTicket.getId(), (Object)deviceCode);
                this.ticketRegistry.deleteTicket(deviceCode);
                AccessTokenRequestContext deviceResult = AccessTokenRequestContext.builder().service(tokenRequestContext.getService()).authentication(tokenRequestContext.getAuthentication()).registeredService(tokenRequestContext.getRegisteredService()).ticketGrantingTicket(tokenRequestContext.getTicketGrantingTicket()).grantType(tokenRequestContext.getGrantType()).scopes(new LinkedHashSet(0)).responseType(tokenRequestContext.getResponseType()).generateRefreshToken(tokenRequestContext.getRegisteredService() != null && tokenRequestContext.isGenerateRefreshToken()).build();
                AccessAndRefreshTokens ticketPair = this.generateAccessTokenOAuthGrantTypes(deviceResult);
                return OAuth20DefaultTokenGenerator.generateAccessTokenResult(deviceResult, ticketPair);
            }
            if (deviceCodeTicket.getLastTimeUsed() != null) {
                long interval = Beans.newDuration((String)this.casProperties.getAuthn().getOauth().getDeviceToken().getRefreshInterval()).toSeconds();
                boolean shouldSlowDown = deviceCodeTicket.getLastTimeUsed().plusSeconds(interval).isAfter(ZonedDateTime.now(ZoneOffset.UTC));
                if (shouldSlowDown) {
                    LOGGER.error("Request for user code approval is greater than the configured refresh interval of [{}] second(s)", (Object)interval);
                    throw new ThrottledOAuth20DeviceUserCodeApprovalException(deviceCodeTicket.getId());
                }
            }
            deviceCodeTicket.update();
            this.ticketRegistry.updateTicket((Ticket)deviceCodeTicket);
            LOGGER.error("Provided user code [{}] linked to device code [{}] is NOT approved yet", (Object)deviceCodeTicket.getId(), (Object)deviceCode);
            throw new UnapprovedOAuth20DeviceUserCodeException(deviceCodeTicket.getId());
        }
        DeviceTokens deviceTokens = this.createDeviceTokensInTicketRegistry(tokenRequestContext);
        return OAuth20TokenGeneratedResult.builder().responseType(tokenRequestContext.getResponseType()).registeredService((RegisteredService)tokenRequestContext.getRegisteredService()).deviceCode(deviceTokens.deviceCode().getId()).userCode(deviceTokens.userCode().getId()).build();
    }

    protected AuthenticationBuilder prepareAuthentication(AccessTokenRequestContext tokenRequestContext) {
        Ticket ticketGrantingTicket = tokenRequestContext.getTicketGrantingTicket();
        Authentication existingAuthn = tokenRequestContext.getAuthentication();
        if (existingAuthn == null && ticketGrantingTicket instanceof AuthenticationAwareTicket) {
            AuthenticationAwareTicket aat = (AuthenticationAwareTicket)ticketGrantingTicket;
            existingAuthn = aat.getAuthentication();
        }
        AuthenticationBuilder authnBuilder = DefaultAuthenticationBuilder.newInstance((Authentication)existingAuthn).setAuthenticationDate(ZonedDateTime.now(ZoneOffset.UTC)).addAttribute("grant_type", (Object)tokenRequestContext.getGrantType().getType()).addAttribute("scope", (Object)tokenRequestContext.getScopes());
        Map requestedClaims = tokenRequestContext.getClaims().getOrDefault("userinfo", new HashMap());
        requestedClaims.forEach((arg_0, arg_1) -> ((AuthenticationBuilder)authnBuilder).addAttribute(arg_0, arg_1));
        FunctionUtils.doIfNotNull((Object)tokenRequestContext.getDpop(), __ -> authnBuilder.addAttribute("DPoP", (Object)tokenRequestContext.getDpop()));
        FunctionUtils.doIfNotNull((Object)tokenRequestContext.getDpopConfirmation(), __ -> authnBuilder.addAttribute("DPoPConfirmation", (Object)tokenRequestContext.getDpopConfirmation()));
        return authnBuilder;
    }

    protected AccessAndRefreshTokens generateAccessTokenOAuthGrantTypes(AccessTokenRequestContext tokenRequestContext) throws Throwable {
        LOGGER.debug("Creating access token for [{}]", (Object)tokenRequestContext.getService());
        if (tokenRequestContext.getGrantType() == OAuth20GrantTypes.TOKEN_EXCHANGE) {
            return this.generateAccessTokenForTokenExchange(tokenRequestContext);
        }
        Authentication authentication = this.finalizeAuthentication(tokenRequestContext, this.prepareAuthentication(tokenRequestContext));
        LOGGER.debug("Creating access token for [{}]", (Object)tokenRequestContext);
        OAuth20AccessToken accessToken = this.createAccessToken(tokenRequestContext, authentication);
        Ticket addedAccessToken = this.addAccessToken(tokenRequestContext, accessToken);
        Ticket refreshToken = (Ticket)FunctionUtils.doIf((boolean)tokenRequestContext.isGenerateRefreshToken(), (Supplier)Unchecked.supplier(() -> this.generateRefreshToken(tokenRequestContext, accessToken.getId())), () -> {
            LOGGER.debug("Service [{}] is not able/allowed to receive refresh tokens", (Object)tokenRequestContext.getService());
            return null;
        }).get();
        return new AccessAndRefreshTokens(addedAccessToken, refreshToken);
    }

    protected Authentication finalizeAuthentication(AccessTokenRequestContext tokenRequestContext, AuthenticationBuilder authenticationBuilder) {
        return authenticationBuilder.build();
    }

    protected AccessAndRefreshTokens generateAccessTokenForTokenExchange(AccessTokenRequestContext tokenRequestContext) throws Throwable {
        Service targetService = Objects.requireNonNullElseGet(tokenRequestContext.getTokenExchangeResource(), () -> ((AccessTokenRequestContext)tokenRequestContext).getService());
        return switch (tokenRequestContext.getRequestedTokenType()) {
            case OAuth20TokenExchangeTypes.ACCESS_TOKEN, OAuth20TokenExchangeTypes.JWT -> {
                OAuth20AccessToken subjectToken = (OAuth20AccessToken)tokenRequestContext.getSubjectToken();
                OAuth20AccessToken exchangedAccessToken = this.exchangeTokenForAccessToken(targetService, subjectToken, tokenRequestContext);
                Ticket addedAccessToken = this.addAccessToken(tokenRequestContext, exchangedAccessToken);
                yield new AccessAndRefreshTokens(addedAccessToken, null);
            }
            default -> {
                OAuth20AccessToken subjectToken = (OAuth20AccessToken)tokenRequestContext.getSubjectToken();
                OAuth20AccessToken exchangedAccessToken = this.exchangeTokenForAccessToken(targetService, subjectToken, tokenRequestContext);
                yield new AccessAndRefreshTokens((Ticket)exchangedAccessToken, null);
            }
        };
    }

    private OAuth20AccessToken createAccessToken(AccessTokenRequestContext tokenRequestContext, Authentication authentication) throws Throwable {
        String clientId = Optional.ofNullable(tokenRequestContext.getRegisteredService()).map(OAuthRegisteredService::getClientId).orElse("");
        OAuth20AccessTokenFactory accessTokenFactory = (OAuth20AccessTokenFactory)this.ticketFactory.get(OAuth20AccessToken.class);
        Ticket ticketGrantingTicket = tokenRequestContext.getTicketGrantingTicket() == null || tokenRequestContext.getTicketGrantingTicket().isExpired() ? null : tokenRequestContext.getTicketGrantingTicket();
        LOGGER.debug("Creating access token for client id [{}] and authentication [{}]", (Object)clientId, (Object)authentication);
        return accessTokenFactory.create(tokenRequestContext.getService(), authentication, ticketGrantingTicket, (Collection)tokenRequestContext.getScopes(), (String)Optional.ofNullable(tokenRequestContext.getToken()).map(Ticket::getId).orElse(null), clientId, tokenRequestContext.getClaims(), tokenRequestContext.getResponseType(), tokenRequestContext.getGrantType());
    }

    private OAuth20AccessToken exchangeTokenForAccessToken(Service service, OAuth20AccessToken accessToken, AccessTokenRequestContext tokenRequestContext) throws Throwable {
        HashSet<String> scopes = new HashSet<String>(tokenRequestContext.getScopes());
        scopes.retainAll(tokenRequestContext.getRegisteredService().getScopes());
        BasicIdentifiableCredential credential = new BasicIdentifiableCredential(accessToken.getAuthentication().getPrincipal().getId());
        Principal resolvedPrincipal = this.principalResolver.resolve((Credential)credential);
        if (resolvedPrincipal instanceof NullPrincipal) {
            resolvedPrincipal = accessToken.getAuthentication().getPrincipal();
        }
        Principal exchangedPrincipal = this.profileScopeToAttributesFilter.filter(service, resolvedPrincipal, (RegisteredService)tokenRequestContext.getRegisteredService(), scopes, accessToken);
        AuthenticationBuilder exchangedAuthentication = DefaultAuthenticationBuilder.newInstance((Principal)exchangedPrincipal).addAttribute("grant_type", (Object)accessToken.getGrantType().getType());
        if (tokenRequestContext.getActorToken() != null) {
            exchangedAuthentication.addAttribute("act", (Object)CollectionUtils.wrap((String)"sub", (Object)tokenRequestContext.getActorToken().getPrincipal().getId()));
        }
        OAuth20AccessTokenFactory accessTokenFactory = (OAuth20AccessTokenFactory)this.ticketFactory.get(OAuth20AccessToken.class);
        Ticket ticketGrantingTicket = tokenRequestContext.getTicketGrantingTicket() == null || tokenRequestContext.getTicketGrantingTicket().isExpired() ? null : tokenRequestContext.getTicketGrantingTicket();
        return accessTokenFactory.create(service, exchangedAuthentication.build(), ticketGrantingTicket, scopes, accessToken.getId(), accessToken.getClientId(), accessToken.getClaims(), accessToken.getResponseType(), accessToken.getGrantType());
    }

    protected Ticket addAccessToken(AccessTokenRequestContext tokenRequestContext, OAuth20AccessToken accessToken) throws Exception {
        OAuth20AccessToken finalAccessToken = accessToken;
        if (tokenRequestContext.getResponseType() != OAuth20ResponseTypes.ID_TOKEN && accessToken.getExpiresIn() > 0L) {
            LOGGER.debug("Created access token [{}]", (Object)accessToken);
            finalAccessToken = this.addTicketToRegistry((Ticket)accessToken, tokenRequestContext.getTicketGrantingTicket());
            LOGGER.debug("Added access token [{}] to registry", (Object)finalAccessToken);
            this.updateRefreshToken(tokenRequestContext, (Ticket)finalAccessToken);
        }
        this.updateOAuthCode(tokenRequestContext);
        return finalAccessToken;
    }

    private void updateRefreshToken(AccessTokenRequestContext tokenRequestContext, Ticket accessToken) throws Exception {
        if (tokenRequestContext.isRefreshToken() && !tokenRequestContext.getToken().isStateless()) {
            OAuth20RefreshToken refreshToken = (OAuth20RefreshToken)tokenRequestContext.getToken();
            LOGGER.trace("Tracking access token [{}] linked to refresh token [{}]", (Object)accessToken.getId(), (Object)refreshToken.getId());
            refreshToken.getAccessTokens().add(accessToken.getId());
            this.ticketRegistry.updateTicket((Ticket)refreshToken);
        }
    }

    private void updateOAuthCode(AccessTokenRequestContext tokenRequestContext) throws Exception {
        OAuth20Token token = tokenRequestContext.getToken();
        if (tokenRequestContext.isCodeToken() && !token.isStateless()) {
            token.update();
            LOGGER.trace("Updated OAuth code [{}]", (Object)token.getId());
            if (token.isExpired()) {
                this.ticketRegistry.deleteTicket((Ticket)token);
            } else {
                this.ticketRegistry.updateTicket((Ticket)token);
            }
            this.updateTicketGrantingTicket(tokenRequestContext.getTicketGrantingTicket());
        }
    }

    protected Ticket addTicketToRegistry(Ticket ticket, Ticket ticketGrantingTicket) throws Exception {
        LOGGER.debug("Adding ticket [{}] to registry", (Object)ticket);
        Ticket addedToken = this.ticketRegistry.addTicket(ticket);
        this.updateTicketGrantingTicket(ticketGrantingTicket);
        return addedToken;
    }

    protected Ticket addTicketToRegistry(Ticket ticket) throws Exception {
        return this.addTicketToRegistry(ticket, null);
    }

    protected void updateTicketGrantingTicket(Ticket ticketGrantingTicket) throws Exception {
        if (ticketGrantingTicket != null && !ticketGrantingTicket.isExpired()) {
            LOGGER.debug("Updating parent ticket-granting ticket [{}]", (Object)ticketGrantingTicket);
            ticketGrantingTicket.update();
            this.ticketRegistry.updateTicket(ticketGrantingTicket);
        }
    }

    protected Ticket generateRefreshToken(AccessTokenRequestContext tokenRequestContext, String accessTokenId) throws Throwable {
        LOGGER.debug("Creating refresh token for [{}]", (Object)tokenRequestContext.getService());
        OAuth20RefreshTokenFactory refreshTokenFactory = (OAuth20RefreshTokenFactory)this.ticketFactory.get(OAuth20RefreshToken.class);
        Ticket ticketGrantingTicket = tokenRequestContext.getTicketGrantingTicket() == null || tokenRequestContext.getTicketGrantingTicket().isExpired() ? null : tokenRequestContext.getTicketGrantingTicket();
        Set scopes = tokenRequestContext.getGrantType() == OAuth20GrantTypes.REFRESH_TOKEN ? tokenRequestContext.getToken().getScopes() : tokenRequestContext.getScopes();
        OAuth20RefreshToken refreshToken = refreshTokenFactory.create(tokenRequestContext.getService(), tokenRequestContext.getAuthentication(), ticketGrantingTicket, (Collection)scopes, tokenRequestContext.getRegisteredService().getClientId(), accessTokenId, tokenRequestContext.getClaims(), tokenRequestContext.getResponseType(), tokenRequestContext.getGrantType());
        if (refreshToken.getExpirationPolicy().getTimeToLive() > 0L) {
            LOGGER.debug("Adding refresh token [{}] to the registry", (Object)refreshToken);
            Ticket addedRefreshToken = this.addTicketToRegistry((Ticket)refreshToken, ticketGrantingTicket);
            if (tokenRequestContext.isExpireOldRefreshToken()) {
                this.expireOldRefreshToken(tokenRequestContext);
            }
            return addedRefreshToken;
        }
        LOGGER.debug("Refresh token expiration policy for [{}] does not allow refresh tokens to be added to the registry", (Object)refreshToken.getId());
        return null;
    }

    private OAuth20DeviceUserCode getDeviceUserCodeFromRegistry(OAuth20DeviceToken deviceCodeTicket) {
        return (OAuth20DeviceUserCode)FunctionUtils.doAndHandle(() -> (OAuth20DeviceUserCode)this.ticketRegistry.getTicket(deviceCodeTicket.getUserCode(), OAuth20DeviceUserCode.class), throwable -> {
            LOGGER.error("Provided user code [{}] is invalid or expired and cannot be found in the ticket registry", (Object)deviceCodeTicket.getUserCode());
            throw new InvalidOAuth20DeviceTokenException(deviceCodeTicket.getUserCode());
        }).get();
    }

    private OAuth20DeviceToken getDeviceTokenFromTicketRegistry(String deviceCode) {
        return (OAuth20DeviceToken)FunctionUtils.doAndHandle(() -> (OAuth20DeviceToken)this.ticketRegistry.getTicket(deviceCode, OAuth20DeviceToken.class), throwable -> {
            LoggingUtils.error((Logger)LOGGER, (Throwable)throwable);
            throw new InvalidOAuth20DeviceTokenException(deviceCode);
        }).get();
    }

    private DeviceTokens createDeviceTokensInTicketRegistry(AccessTokenRequestContext tokenRequestContext) throws Throwable {
        OAuth20DeviceTokenFactory deviceTokenFactory = (OAuth20DeviceTokenFactory)this.ticketFactory.get(OAuth20DeviceToken.class);
        OAuth20DeviceUserCodeFactory deviceUserCodeFactory = (OAuth20DeviceUserCodeFactory)this.ticketFactory.get(OAuth20DeviceUserCode.class);
        OAuth20DeviceToken deviceToken = deviceTokenFactory.createDeviceCode(tokenRequestContext.getService());
        LOGGER.debug("Created device code token [{}]", (Object)deviceToken.getId());
        OAuth20DeviceUserCode deviceUserCode = deviceUserCodeFactory.createDeviceUserCode(deviceToken.getService());
        LOGGER.debug("Created device user code token [{}]", (Object)deviceUserCode.getId());
        Ticket addedDeviceUserCode = this.addTicketToRegistry((Ticket)deviceUserCode);
        LOGGER.debug("Added device user code [{}] to registry", (Object)addedDeviceUserCode);
        deviceToken.setUserCode(addedDeviceUserCode.getId());
        Ticket addedDeviceToken = this.addTicketToRegistry((Ticket)deviceToken);
        LOGGER.debug("Added device token [{}] to registry", (Object)addedDeviceToken);
        return new DeviceTokens(addedDeviceToken, addedDeviceUserCode);
    }

    private void expireOldRefreshToken(AccessTokenRequestContext tokenRequestContext) throws Exception {
        OAuth20Token oldRefreshToken = tokenRequestContext.getToken();
        if (!oldRefreshToken.isStateless()) {
            LOGGER.debug("Expiring old refresh token [{}]", (Object)oldRefreshToken);
            oldRefreshToken.markTicketExpired();
            this.ticketRegistry.deleteTicket((Ticket)oldRefreshToken);
        }
    }

    @Generated
    public OAuth20DefaultTokenGenerator(TicketFactory ticketFactory, TicketRegistry ticketRegistry, PrincipalResolver principalResolver, OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter, CasConfigurationProperties casProperties) {
        this.ticketFactory = ticketFactory;
        this.ticketRegistry = ticketRegistry;
        this.principalResolver = principalResolver;
        this.profileScopeToAttributesFilter = profileScopeToAttributesFilter;
        this.casProperties = casProperties;
    }

    protected record AccessAndRefreshTokens(Ticket accessToken, Ticket refreshToken) {
    }

    protected record DeviceTokens(Ticket deviceCode, Ticket userCode) {
    }
}

