/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.views;

import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.attribute.AttributeDefinition;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.configuration.model.support.oauth.OAuthCoreProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.CollectionUtils;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public class OAuth20DefaultUserProfileViewRenderer
implements OAuth20UserProfileViewRenderer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20DefaultUserProfileViewRenderer.class);
    protected final ServicesManager servicesManager;
    private final OAuthProperties oauthProperties;
    private final AttributeDefinitionStore attributeDefinitionStore;

    @Override
    public ResponseEntity render(Map<String, Object> model, OAuth20AccessToken accessToken, HttpServletResponse response) {
        Map<String, Object> userProfile = this.getRenderedUserProfile(model, accessToken, response);
        return this.renderProfileForModel(userProfile, accessToken, response);
    }

    protected ResponseEntity renderProfileForModel(Map<String, Object> userProfile, OAuth20AccessToken accessToken, HttpServletResponse response) {
        JwtClaims claims = this.convertUserProfileIntoClaims(userProfile);
        return new ResponseEntity((Object)claims.getClaimsMap(), (HttpStatusCode)HttpStatus.OK);
    }

    protected Map<String, Object> getRenderedUserProfile(Map<String, Object> model, OAuth20AccessToken accessToken, HttpServletResponse response) {
        OAuthCoreProperties.UserProfileViewTypes type = this.determineUserProfileType(accessToken);
        LOGGER.debug("User profile view type for client [{}] is set to [{}]", (Object)accessToken.getClientId(), (Object)type);
        if (type == OAuthCoreProperties.UserProfileViewTypes.FLAT) {
            return this.flattenUserProfile(model);
        }
        return model;
    }

    protected OAuthCoreProperties.UserProfileViewTypes determineUserProfileType(OAuth20AccessToken accessToken) {
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, accessToken.getClientId());
        return registeredService != null && registeredService.getUserProfileViewType() != null ? registeredService.getUserProfileViewType() : this.oauthProperties.getCore().getUserProfileViewType();
    }

    protected Map<String, Object> flattenUserProfile(Map<String, Object> model) {
        LinkedHashMap<String, Object> flattened = new LinkedHashMap<String, Object>();
        if (model.containsKey("attributes")) {
            Map attributes = (Map)model.get("attributes");
            flattened.putAll(attributes);
        }
        model.keySet().stream().filter(attributeName -> !attributeName.equalsIgnoreCase("attributes")).forEach(attributeName -> flattened.put((String)attributeName, model.get(attributeName)));
        LOGGER.trace("Flattened user profile attributes with the final model as [{}]", model);
        return flattened;
    }

    protected JwtClaims convertUserProfileIntoClaims(Map<String, Object> userProfile) {
        JwtClaims claims = new JwtClaims();
        userProfile.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith(CentralAuthenticationService.NAMESPACE)).forEach(entry -> {
            if ("attributes".equals(entry.getKey())) {
                Map attributes = (Map)entry.getValue();
                HashMap newAttributes = new HashMap();
                attributes.forEach((attrName, attrValue) -> newAttributes.put(attrName, this.determineAttributeValue((String)attrName, attrValue)));
                claims.setClaim((String)entry.getKey(), newAttributes);
            } else {
                claims.setClaim((String)entry.getKey(), this.determineAttributeValue((String)entry.getKey(), entry.getValue()));
            }
        });
        return claims;
    }

    protected Object determineAttributeValue(String name, Object attrValue) {
        ArrayList values = (ArrayList)CollectionUtils.toCollection((Object)attrValue, ArrayList.class);
        Optional result = this.attributeDefinitionStore.locateAttributeDefinition(name, AttributeDefinition.class);
        return result.map(defn -> defn.toAttributeValue((Object)values)).orElseGet(() -> values.size() == 1 ? values.getFirst() : values);
    }

    @Generated
    public OAuth20DefaultUserProfileViewRenderer(ServicesManager servicesManager, OAuthProperties oauthProperties, AttributeDefinitionStore attributeDefinitionStore) {
        this.servicesManager = servicesManager;
        this.oauthProperties = oauthProperties;
        this.attributeDefinitionStore = attributeDefinitionStore;
    }
}

