/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.device;

import java.time.Instant;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenFactory;
import org.apereo.cas.ticket.expiration.FixedInstantExpirationPolicy;
import org.apereo.cas.ticket.registry.TicketCompactor;
import org.apereo.cas.util.DateTimeUtils;
import org.springframework.beans.factory.ObjectProvider;

public class OAuth20DeviceTokenCompactor
implements TicketCompactor<OAuth20DeviceToken> {
    private final ObjectProvider<TicketFactory> ticketFactory;
    private final ServiceFactory serviceFactory;
    private long maximumTicketLength = 256L;

    public String compact(StringBuilder builder, Ticket ticket) throws Exception {
        OAuth20DeviceToken code = (OAuth20DeviceToken)ticket;
        builder.append(String.format("%s%s", ",", code.getService().getShortenedId()));
        builder.append(String.format("%s%s", ",", code.getUserCode()));
        return builder.toString();
    }

    public Class<OAuth20DeviceToken> getTicketType() {
        return OAuth20DeviceToken.class;
    }

    public Ticket expand(String ticketId) throws Throwable {
        TicketCompactor.CompactTicket structure = this.parse(ticketId);
        Service service = this.serviceFactory.createService((String)structure.ticketElements().get(TicketCompactor.CompactTicketIndexes.SERVICE.getIndex()));
        String userCode = (String)structure.ticketElements().get(3);
        OAuth20DeviceTokenFactory codeFactory = (OAuth20DeviceTokenFactory)((TicketFactory)this.ticketFactory.getObject()).get(this.getTicketType());
        OAuth20DeviceToken code = codeFactory.createDeviceCode(service);
        code.setUserCode(StringUtils.trimToNull((String)userCode));
        code.setExpirationPolicy((ExpirationPolicy)new FixedInstantExpirationPolicy(structure.expirationTime()));
        code.setCreationTime(DateTimeUtils.zonedDateTimeOf((Instant)structure.creationTime()));
        return code;
    }

    @Generated
    public OAuth20DeviceTokenCompactor(ObjectProvider<TicketFactory> ticketFactory, ServiceFactory serviceFactory) {
        this.ticketFactory = ticketFactory;
        this.serviceFactory = serviceFactory;
    }

    @Generated
    public long getMaximumTicketLength() {
        return this.maximumTicketLength;
    }
}

