/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression.spel;

import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class MessageSourcePropertyAccessor
implements PropertyAccessor {
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{MessageSource.class};
    }

    public boolean canRead(EvaluationContext context, Object target, String name) {
        return this.getMessage(target, name) != null;
    }

    public TypedValue read(EvaluationContext context, Object target, String name) {
        return new TypedValue((Object)this.getMessage(target, name));
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) {
        return false;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        throw new AccessException("The flow MessageSource is not writable.");
    }

    private String getMessage(Object target, String name) {
        return ((MessageSource)target).getMessage(name, null, null, this.getLocale());
    }

    private Locale getLocale() {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        return requestContext != null ? requestContext.getExternalContext().getLocale() : LocaleContextHolder.getLocale();
    }
}

