/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.factory;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.expiration.AlwaysExpiresExpirationPolicy;

public class DefaultTicketFactory
implements TicketFactory {
    private final Map<String, Object> factoryMap = new HashMap<String, Object>(0);

    public TicketFactory get(Class<? extends Ticket> clazz) {
        return (TicketFactory)this.factoryMap.get(clazz.getCanonicalName());
    }

    public Class<? extends Ticket> getTicketType() {
        return Ticket.class;
    }

    @CanIgnoreReturnValue
    public DefaultTicketFactory addTicketFactory(@NonNull Class<? extends Ticket> ticketClass, @NonNull TicketFactory factory) {
        if (ticketClass == null) {
            throw new NullPointerException("ticketClass is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        this.factoryMap.put(ticketClass.getCanonicalName(), factory);
        return this;
    }

    public ExpirationPolicyBuilder getExpirationPolicyBuilder() {
        return new ExpirationPolicyBuilder<Ticket>(){
            private static final long serialVersionUID = -8720633582482747264L;

            public ExpirationPolicy buildTicketExpirationPolicy() {
                return AlwaysExpiresExpirationPolicy.INSTANCE;
            }
        };
    }

    @Generated
    public DefaultTicketFactory() {
    }
}

