/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api;

import java.text.ParseException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.springframework.transaction.annotation.Transactional;

public class IntAttrNameParser {
    protected static final String END_PATTERN = "\\]\\.(.+)";
    protected static final Pattern ENCLOSING_GROUP_PATTERN = Pattern.compile("^groups\\[([\\p{L}\\p{gc=Mn}\\p{gc=Me}\\p{gc=Mc}\\p{Digit}\\p{gc=Pc} \\-@.~]+)\\]\\.(.+)");
    protected static final Pattern RELATED_USER_PATTERN = Pattern.compile("^users\\[([\\p{L}\\p{gc=Mn}\\p{gc=Me}\\p{gc=Mc}\\p{Digit}\\p{gc=Pc} \\-@.~]+)\\]\\.(.+)");
    protected static final Pattern RELATED_ANY_OBJECT_PATTERN = Pattern.compile("^anyObjects\\[([\\p{L}\\p{gc=Mn}\\p{gc=Me}\\p{gc=Mc}\\p{Digit}\\p{gc=Pc} \\-@.~]+)\\]\\.(.+)");
    protected static final Pattern MEMBERSHIP_PATTERN = Pattern.compile("^memberships\\[([\\p{L}\\p{gc=Mn}\\p{gc=Me}\\p{gc=Mc}\\p{Digit}\\p{gc=Pc} \\-@.~]+)\\]\\.(.+)");
    protected static final Pattern RELATIONSHIP_PATTERN = Pattern.compile("^relationships\\[([\\p{L}\\p{gc=Mn}\\p{gc=Me}\\p{gc=Mc}\\p{Digit}\\p{gc=Pc} \\-@.~]+)\\]\\[([\\p{L}\\p{gc=Mn}\\p{gc=Me}\\p{gc=Mc}\\p{Digit}\\p{gc=Pc} \\-@.~]+)\\]\\.(.+)");
    protected static final CharSequence[] RESERVED_WORDS = new CharSequence[]{"groups", "users", "anyObjects", "memberships", "relationships"};
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final DerSchemaDAO derSchemaDAO;
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final RealmUtils realmUtils;

    public IntAttrNameParser(PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, AnyUtilsFactory anyUtilsFactory, RealmUtils realmUtils) {
        this.plainSchemaDAO = plainSchemaDAO;
        this.derSchemaDAO = derSchemaDAO;
        this.anyUtilsFactory = anyUtilsFactory;
        this.realmUtils = realmUtils;
    }

    protected Pair<Schema, SchemaType> find(String key) {
        Schema schema = this.plainSchemaDAO.findById(key).orElse(null);
        if (schema == null) {
            schema = this.derSchemaDAO.findById(key).orElse(null);
            if (schema == null) {
                return null;
            }
            return Pair.of((Object)schema, (Object)SchemaType.DERIVED);
        }
        return Pair.of((Object)schema, (Object)SchemaType.PLAIN);
    }

    protected void setFieldOrSchemaName(String fieldOrSchemaName, AnyTypeKind anyTypeKind, IntAttrName result) {
        this.anyUtilsFactory.getInstance(anyTypeKind).getField(fieldOrSchemaName).ifPresentOrElse(field -> result.setField(fieldOrSchemaName), () -> Optional.ofNullable(this.find(fieldOrSchemaName)).ifPresent(schemaInfo -> {
            result.setSchemaType((SchemaType)schemaInfo.getRight());
            result.setSchema((Schema)schemaInfo.getLeft());
        }));
    }

    @Transactional(readOnly=true)
    public IntAttrName parse(String intAttrName, AnyTypeKind provisionAnyTypeKind) throws ParseException {
        IntAttrName result = new IntAttrName();
        Matcher matcher = Pattern.compile(END_PATTERN).matcher(intAttrName);
        if (!matcher.matches() && !Strings.CS.containsAny((CharSequence)intAttrName, RESERVED_WORDS)) {
            result.setAnyTypeKind(provisionAnyTypeKind);
            this.setFieldOrSchemaName(intAttrName, result.getAnyTypeKind(), result);
        } else {
            matcher = ENCLOSING_GROUP_PATTERN.matcher(intAttrName);
            if (matcher.matches()) {
                result.setAnyTypeKind(AnyTypeKind.GROUP);
                result.setEnclosingGroup(matcher.group(1));
                this.setFieldOrSchemaName(matcher.group(2), result.getAnyTypeKind(), result);
            } else {
                matcher = RELATED_ANY_OBJECT_PATTERN.matcher(intAttrName);
                if (matcher.matches()) {
                    result.setAnyTypeKind(AnyTypeKind.ANY_OBJECT);
                    result.setRelatedAnyObject(matcher.group(1));
                    this.setFieldOrSchemaName(matcher.group(2), result.getAnyTypeKind(), result);
                } else {
                    matcher = MEMBERSHIP_PATTERN.matcher(intAttrName);
                    if (matcher.matches()) {
                        result.setAnyTypeKind(AnyTypeKind.USER);
                        result.setMembershipOfGroup(matcher.group(1));
                        this.setFieldOrSchemaName(matcher.group(2), result.getAnyTypeKind(), result);
                    } else {
                        matcher = RELATED_USER_PATTERN.matcher(intAttrName);
                        if (matcher.matches()) {
                            result.setAnyTypeKind(AnyTypeKind.USER);
                            result.setRelatedUser(matcher.group(1));
                            this.setFieldOrSchemaName(matcher.group(2), result.getAnyTypeKind(), result);
                        } else {
                            matcher = RELATIONSHIP_PATTERN.matcher(intAttrName);
                            if (matcher.matches()) {
                                result.setAnyTypeKind(AnyTypeKind.ANY_OBJECT);
                                result.setRelationshipType(matcher.group(1));
                                result.setRelationshipAnyType(matcher.group(2));
                                this.setFieldOrSchemaName(matcher.group(3), result.getAnyTypeKind(), result);
                            } else {
                                throw new ParseException("Unparsable expression: " + intAttrName, 0);
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    protected void setFieldOrSchemaName(String fieldOrSchemaName, IntAttrName result) {
        this.realmUtils.getField(fieldOrSchemaName).ifPresentOrElse(field -> result.setField(fieldOrSchemaName), () -> Optional.ofNullable(this.find(fieldOrSchemaName)).ifPresent(schemaInfo -> {
            result.setSchemaType((SchemaType)schemaInfo.getRight());
            result.setSchema((Schema)schemaInfo.getLeft());
        }));
    }

    @Transactional(readOnly=true)
    public IntAttrName parse(String intAttrName) throws ParseException {
        IntAttrName result = new IntAttrName();
        if (intAttrName.indexOf(46) != -1) {
            throw new ParseException("Unparsable expression: " + intAttrName, 0);
        }
        this.setFieldOrSchemaName(intAttrName, result);
        return result;
    }
}

