/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.spring;

import java.util.Map;
import org.flowable.common.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.spring.SpringIdmEngineConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class IdmEngineFactoryBean
implements FactoryBean<IdmEngine>,
DisposableBean,
ApplicationContextAware {
    protected IdmEngineConfiguration idmEngineConfiguration;
    protected ApplicationContext applicationContext;
    protected IdmEngine idmEngine;

    public void destroy() throws Exception {
        if (this.idmEngine != null) {
            this.idmEngine.close();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public IdmEngine getObject() throws Exception {
        this.configureExternallyManagedTransactions();
        if (this.idmEngineConfiguration.getBeans() == null) {
            this.idmEngineConfiguration.setBeans((Map)new SpringBeanFactoryProxyMap((BeanFactory)this.applicationContext));
        }
        this.idmEngine = this.idmEngineConfiguration.buildIdmEngine();
        return this.idmEngine;
    }

    protected void configureExternallyManagedTransactions() {
        SpringIdmEngineConfiguration engineConfiguration;
        if (this.idmEngineConfiguration instanceof SpringIdmEngineConfiguration && (engineConfiguration = (SpringIdmEngineConfiguration)this.idmEngineConfiguration).getTransactionManager() != null) {
            this.idmEngineConfiguration.setTransactionsExternallyManaged(true);
        }
    }

    public Class<IdmEngine> getObjectType() {
        return IdmEngine.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public IdmEngineConfiguration getIdmEngineConfiguration() {
        return this.idmEngineConfiguration;
    }

    public void setIdmEngineConfiguration(IdmEngineConfiguration idmEngineConfiguration) {
        this.idmEngineConfiguration = idmEngineConfiguration;
    }
}

