/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.cookie.TicketGrantingCookieProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.cookie.CookieGenerationContext;
import org.apereo.cas.web.cookie.CookieValueManager;
import org.apereo.cas.web.support.gen.CookieRetrievingCookieGenerator;

public final class CookieUtils {
    public static CasCookieBuilder buildCookieRetrievingGenerator(CookieProperties cookie, CookieValueManager cookieValueManager) {
        CookieGenerationContext context = CookieUtils.buildCookieGenerationContext(cookie);
        return CookieUtils.buildCookieRetrievingGenerator(cookieValueManager, context);
    }

    public static CookieRetrievingCookieGenerator buildCookieRetrievingGenerator(CookieValueManager cookieValueManager, CookieGenerationContext context) {
        return new CookieRetrievingCookieGenerator(context, cookieValueManager);
    }

    public static TicketGrantingTicket getTicketGrantingTicketFromRequest(CasCookieBuilder ticketGrantingTicketCookieGenerator, TicketRegistry ticketRegistry, HttpServletRequest request) {
        String cookieValue = ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        if (StringUtils.isNotBlank((CharSequence)cookieValue)) {
            return (TicketGrantingTicket)FunctionUtils.doAndHandle(() -> {
                TicketGrantingTicket state = (TicketGrantingTicket)ticketRegistry.getTicket(cookieValue, TicketGrantingTicket.class);
                return state == null || state.isExpired() ? null : state;
            });
        }
        return null;
    }

    public static CookieGenerationContext buildCookieGenerationContext(CookieProperties cookie) {
        return CookieUtils.buildCookieGenerationContextBuilder(cookie).build();
    }

    public static CookieGenerationContext buildCookieGenerationContext(TicketGrantingCookieProperties cookie) {
        int rememberMeMaxAge = CookieUtils.getCookieMaxAge(cookie.getRememberMeMaxAge());
        CookieGenerationContext.CookieGenerationContextBuilder builder = CookieUtils.buildCookieGenerationContextBuilder((CookieProperties)cookie);
        return builder.rememberMeMaxAge(rememberMeMaxAge).build();
    }

    public static int getCookieMaxAge(String maxAge) {
        if (NumberUtils.isCreatable((String)maxAge)) {
            return Integer.parseInt(maxAge);
        }
        return (int)Beans.newDuration((String)maxAge).toSeconds();
    }

    private static CookieGenerationContext.CookieGenerationContextBuilder buildCookieGenerationContextBuilder(CookieProperties cookie) {
        return CookieGenerationContext.builder().name(cookie.getName()).path(cookie.getPath()).maxAge(CookieUtils.getCookieMaxAge(cookie.getMaxAge())).secure(cookie.isSecure()).domain(cookie.getDomain()).sameSitePolicy(cookie.getSameSitePolicy()).httpOnly(cookie.isHttpOnly());
    }

    @Generated
    private CookieUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

