/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.web.flow;

import com.yubico.core.RegistrationStorage;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.otp.util.QRUtils;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.webauthn.WebAuthnMultifactorAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class WebAuthnStartAuthenticationAction
extends AbstractMultifactorAuthenticationAction<WebAuthnMultifactorAuthenticationProvider> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAuthnStartAuthenticationAction.class);
    private final CasConfigurationProperties casProperties;
    private final TicketRegistry ticketRegistry;
    private final TicketFactory ticketFactory;
    private final RegistrationStorage webAuthnCredentialRepository;

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = this.resolvePrincipal(authentication.getPrincipal(), requestContext);
        LOGGER.trace("Checking registration record for [{}]", (Object)principal.getId());
        Collection registrations = this.webAuthnCredentialRepository.getRegistrationsByUsername(principal.getId());
        if (registrations.isEmpty()) {
            LOGGER.warn("No registration records could be found for [{}]", (Object)principal.getId());
            return this.error();
        }
        if (this.casProperties.getAuthn().getMfa().getWebAuthn().getCore().isQrCodeAuthenticationEnabled()) {
            TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
            TransientSessionTicket ticket = transientFactory.create(Map.of(Principal.class.getName(), principal));
            Ticket storedTicket = this.ticketRegistry.addTicket((Ticket)ticket);
            URIBuilder urlBuilder = new URIBuilder(this.casProperties.getServer().getPrefix());
            urlBuilder.appendPath("/webauthn");
            urlBuilder.appendPath("/qrverify");
            requestContext.getFlowScope().put("QRCodeUri", (Object)urlBuilder.toString());
            urlBuilder.appendPath(storedTicket.getId());
            String qrCodeBase64 = QRUtils.generateQRCode((String)urlBuilder.toString(), (int)250, (int)250);
            requestContext.getFlowScope().put("QRCode", (Object)qrCodeBase64);
            requestContext.getFlowScope().put("QRCodeTicket", (Object)storedTicket);
            WebUtils.putPrincipal((RequestContext)requestContext, (Principal)principal);
        }
        return this.success();
    }

    @Generated
    public WebAuthnStartAuthenticationAction(CasConfigurationProperties casProperties, TicketRegistry ticketRegistry, TicketFactory ticketFactory, RegistrationStorage webAuthnCredentialRepository) {
        this.casProperties = casProperties;
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
        this.webAuthnCredentialRepository = webAuthnCredentialRepository;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public TicketRegistry getTicketRegistry() {
        return this.ticketRegistry;
    }

    @Generated
    public TicketFactory getTicketFactory() {
        return this.ticketFactory;
    }

    @Generated
    public RegistrationStorage getWebAuthnCredentialRepository() {
        return this.webAuthnCredentialRepository;
    }
}

