/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.clientapps;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.ClientAppRestClient;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSearchFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.PolicyRenderer;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.BinaryFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.WizardModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.OIDCScopeConstants;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.to.OIDCRPClientAppTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.ClientAppType;
import org.apache.syncope.common.lib.types.LogoutType;
import org.apache.syncope.common.lib.types.OIDCApplicationType;
import org.apache.syncope.common.lib.types.OIDCClientAuthenticationMethod;
import org.apache.syncope.common.lib.types.OIDCGrantType;
import org.apache.syncope.common.lib.types.OIDCResponseType;
import org.apache.syncope.common.lib.types.OIDCSubjectType;
import org.apache.syncope.common.lib.types.OIDCTokenEncryptionAlg;
import org.apache.syncope.common.lib.types.OIDCTokenEncryptionEncoding;
import org.apache.syncope.common.lib.types.OIDCTokenSigningAlg;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.syncope.common.lib.types.SAML2SPNameId;
import org.apache.syncope.common.lib.types.XmlSecAlgorithm;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;

public class ClientAppModalPanelBuilder<T extends ClientAppTO>
extends AbstractModalPanelBuilder<T> {
    private static final long serialVersionUID = 5945391813567245081L;
    protected final IModel<Map<String, String>> accessPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            return ClientAppModalPanelBuilder.this.policyRestClient.list(PolicyType.ACCESS).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName, (v1, v2) -> v1, LinkedHashMap::new));
        }
    };
    protected final IModel<Map<String, String>> attrReleasePolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            return ClientAppModalPanelBuilder.this.policyRestClient.list(PolicyType.ATTR_RELEASE).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName, (v1, v2) -> v1, LinkedHashMap::new));
        }
    };
    protected final IModel<Map<String, String>> authPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            return ClientAppModalPanelBuilder.this.policyRestClient.list(PolicyType.AUTH).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName, (v1, v2) -> v1, LinkedHashMap::new));
        }
    };
    protected final IModel<Map<String, String>> ticketExpirationPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            return ClientAppModalPanelBuilder.this.policyRestClient.list(PolicyType.TICKET_EXPIRATION).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName, (v1, v2) -> v1, LinkedHashMap::new));
        }
    };
    protected final BaseModal<T> modal;
    protected final ClientAppType type;
    protected final PolicyRestClient policyRestClient;
    protected final ClientAppRestClient clientAppRestClient;
    protected final RealmRestClient realmRestClient;

    public ClientAppModalPanelBuilder(ClientAppType type, T defaultItem, BaseModal<T> modal, PolicyRestClient policyRestClient, ClientAppRestClient clientAppRestClient, RealmRestClient realmRestClient, PageReference pageRef) {
        super(defaultItem, pageRef);
        this.type = type;
        this.modal = modal;
        this.policyRestClient = policyRestClient;
        this.clientAppRestClient = clientAppRestClient;
        this.realmRestClient = realmRestClient;
    }

    public WizardModalPanel<T> build(String id, int index, AjaxWizard.Mode mode) {
        return new Profile(this, (ClientAppTO)this.newModelObject(), this.modal, this.pageRef);
    }

    private static class Profile
    extends AbstractModalPanel<T> {
        private static final long serialVersionUID = 7647959917047450318L;
        private final T clientAppTO;
        final /* synthetic */ ClientAppModalPanelBuilder this$0;

        Profile(final T clientAppTO, BaseModal<T> modal, PageReference pageRef) {
            this.this$0 = var1_1;
            super(modal, pageRef);
            modal.setFormModel(clientAppTO);
            this.clientAppTO = clientAppTO;
            ArrayList<Object> fields = new ArrayList<Object>();
            final boolean fullRealmsTree = SyncopeWebApplication.get().fullRealmsTree(var1_1.realmRestClient);
            AutoCompleteSettings settings = new AutoCompleteSettings();
            settings.setShowCompleteListOnFocusGain(fullRealmsTree);
            settings.setShowListOnEmptyInput(fullRealmsTree);
            AjaxSearchFieldPanel realm = new AjaxSearchFieldPanel("field", "realm", (IModel)new PropertyModel(clientAppTO, "realm"), settings){
                private static final long serialVersionUID = -6390474600233486704L;

                protected Iterator<String> getChoices(String input) {
                    return Profile.this.this$0.realmRestClient.search(fullRealmsTree ? RealmsUtils.buildBaseQuery() : RealmsUtils.buildKeywordQuery((String)input)).getResult().stream().map(RealmTO::getFullPath).iterator();
                }
            };
            fields.add(realm.setOutputMarkupId(true));
            final AjaxTextFieldPanel name = new AjaxTextFieldPanel("field", "name", (IModel)new PropertyModel(clientAppTO, "name"), false);
            fields.add(name.setRequired(true));
            if (clientAppTO.getClientAppId() == null) {
                Stream.of(ClientAppType.values()).map(var1_1.clientAppRestClient::list).flatMap(Collection::stream).max(Comparator.comparing(ClientAppTO::getClientAppId)).ifPresent(app -> clientAppTO.setClientAppId(Long.valueOf(app.getClientAppId() + 1L)));
            }
            fields.add(new AjaxNumberFieldPanel.Builder().build("field", "clientAppId", Long.class, (IModel)new PropertyModel(clientAppTO, "clientAppId")).setRequired(true));
            fields.add(new AjaxNumberFieldPanel.Builder().build("field", "evaluationOrder", Integer.class, (IModel)new PropertyModel(clientAppTO, "evaluationOrder")).setRequired(true));
            fields.add(new AjaxTextFieldPanel("field", "description", (IModel)new PropertyModel(clientAppTO, "description"), false));
            fields.add(new AjaxTextFieldPanel("field", "logo", (IModel)new PropertyModel(clientAppTO, "logo"), false));
            fields.add(new AjaxTextFieldPanel("field", "theme", (IModel)new PropertyModel(clientAppTO, "theme"), false));
            AjaxTextFieldPanel informationUrl = new AjaxTextFieldPanel("field", "informationUrl", (IModel)new PropertyModel(clientAppTO, "informationUrl"), false);
            informationUrl.addValidator((IValidator)new UrlValidator());
            fields.add(informationUrl);
            AjaxTextFieldPanel privacyUrl = new AjaxTextFieldPanel("field", "privacyUrl", (IModel)new PropertyModel(clientAppTO, "privacyUrl"), false);
            privacyUrl.addValidator((IValidator)new UrlValidator());
            fields.add(privacyUrl);
            AjaxDropDownChoicePanel accessPolicy = new AjaxDropDownChoicePanel("field", "accessPolicy", (IModel)new PropertyModel(clientAppTO, "accessPolicy"), false);
            accessPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer((Map)var1_1.accessPolicies.getObject()));
            accessPolicy.setChoices(new ArrayList(((Map)var1_1.accessPolicies.getObject()).keySet()));
            ((AbstractSingleSelectChoice)accessPolicy.getField()).setNullValid(true);
            fields.add(accessPolicy);
            AjaxDropDownChoicePanel attrReleasePolicy = new AjaxDropDownChoicePanel("field", "attrReleasePolicy", (IModel)new PropertyModel(clientAppTO, "attrReleasePolicy"), false);
            attrReleasePolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer((Map)var1_1.attrReleasePolicies.getObject()));
            attrReleasePolicy.setChoices(new ArrayList(((Map)var1_1.attrReleasePolicies.getObject()).keySet()));
            ((AbstractSingleSelectChoice)attrReleasePolicy.getField()).setNullValid(true);
            fields.add(attrReleasePolicy);
            AjaxDropDownChoicePanel authPolicy = new AjaxDropDownChoicePanel("field", "authPolicy", (IModel)new PropertyModel(clientAppTO, "authPolicy"), false);
            authPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer((Map)var1_1.authPolicies.getObject()));
            authPolicy.setChoices(new ArrayList(((Map)var1_1.authPolicies.getObject()).keySet()));
            fields.add(authPolicy);
            AjaxDropDownChoicePanel ticketExpirationPolicy = new AjaxDropDownChoicePanel("field", "ticketExpirationPolicy", (IModel)new PropertyModel(clientAppTO, "ticketExpirationPolicy"), false);
            ticketExpirationPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer((Map)var1_1.ticketExpirationPolicies.getObject()));
            ticketExpirationPolicy.setChoices(new ArrayList(((Map)var1_1.ticketExpirationPolicies.getObject()).keySet()));
            ((AbstractSingleSelectChoice)ticketExpirationPolicy.getField()).setNullValid(true);
            fields.add(ticketExpirationPolicy);
            AjaxDropDownChoicePanel logoutType = new AjaxDropDownChoicePanel("field", "logoutType", (IModel)new PropertyModel(clientAppTO, "logoutType"), false);
            logoutType.setChoices(List.of(LogoutType.values()));
            fields.add(logoutType.setRequired(true));
            switch (var1_1.type) {
                case CASSP: {
                    fields.add(new AjaxTextFieldPanel("field", "serviceId", (IModel)new PropertyModel(clientAppTO, "serviceId"), false).setRequired(true));
                    break;
                }
                case OIDCRP: {
                    final AjaxTextFieldPanel clientId = new AjaxTextFieldPanel("field", "clientId", (IModel)new PropertyModel(clientAppTO, "clientId"), false);
                    fields.add(clientId.setRequired(true));
                    name.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                        private static final long serialVersionUID = -6139318907146065915L;

                        protected void onUpdate(AjaxRequestTarget target) {
                            if (StringUtils.isBlank((CharSequence)((CharSequence)((Object)clientId.getModelObject())))) {
                                clientId.setModelObject((Serializable)((Object)((String)((Object)name.getModelObject()))));
                                target.add(new Component[]{clientId});
                            }
                        }
                    }});
                    AjaxTextFieldPanel clientSecret = new AjaxTextFieldPanel("field", "clientSecret", (IModel)new PropertyModel(clientAppTO, "clientSecret"), false);
                    clientSecret.setChoices(List.of(RandomStringUtils.secure().nextNumeric(15)));
                    fields.add(clientSecret);
                    AjaxTextFieldPanel idTokenIssuer = new AjaxTextFieldPanel("field", "idTokenIssuer", (IModel)new PropertyModel(clientAppTO, "idTokenIssuer"), false);
                    fields.add(idTokenIssuer);
                    AjaxCheckBoxPanel signIdToken = new AjaxCheckBoxPanel("field", "signIdToken", (IModel)new PropertyModel(clientAppTO, "signIdToken"));
                    fields.add(signIdToken);
                    AjaxDropDownChoicePanel idTokenSigningAlg = new AjaxDropDownChoicePanel("field", "idTokenSigningAlg", (IModel)new PropertyModel(clientAppTO, "idTokenSigningAlg"), false);
                    idTokenSigningAlg.setChoices(List.of(OIDCTokenSigningAlg.values()));
                    fields.add(idTokenSigningAlg.addRequiredLabel());
                    fields.add(new AjaxCheckBoxPanel("field", "encryptIdToken", (IModel)new PropertyModel(clientAppTO, "encryptIdToken")));
                    AjaxDropDownChoicePanel idTokenEncryptionAlg = new AjaxDropDownChoicePanel("field", "idTokenEncryptionAlg", (IModel)new PropertyModel(clientAppTO, "idTokenEncryptionAlg"), false);
                    idTokenEncryptionAlg.setChoices(List.of(OIDCTokenEncryptionAlg.values()));
                    fields.add(idTokenEncryptionAlg.addRequiredLabel());
                    AjaxDropDownChoicePanel idTokenEncryptionEncoding = new AjaxDropDownChoicePanel("field", "idTokenEncryptionEncoding", (IModel)new PropertyModel(clientAppTO, "idTokenEncryptionEncoding"), false);
                    idTokenEncryptionEncoding.setChoices(List.of(OIDCTokenEncryptionEncoding.values()));
                    fields.add(idTokenEncryptionEncoding);
                    AjaxDropDownChoicePanel userInfoSigningAlg = new AjaxDropDownChoicePanel("field", "userInfoSigningAlg", (IModel)new PropertyModel(clientAppTO, "userInfoSigningAlg"), false);
                    userInfoSigningAlg.setChoices(List.of(OIDCTokenSigningAlg.values()));
                    fields.add(userInfoSigningAlg);
                    AjaxDropDownChoicePanel userInfoEncryptedResponseAlg = new AjaxDropDownChoicePanel("field", "userInfoEncryptedResponseAlg", (IModel)new PropertyModel(clientAppTO, "userInfoEncryptedResponseAlg"), false);
                    userInfoEncryptedResponseAlg.setChoices(List.of(OIDCTokenEncryptionAlg.values()));
                    fields.add(userInfoEncryptedResponseAlg);
                    AjaxDropDownChoicePanel userInfoEncryptedResponseEncoding = new AjaxDropDownChoicePanel("field", "userInfoEncryptedResponseEncoding", (IModel)new PropertyModel(clientAppTO, "userInfoEncryptedResponseEncoding"), false);
                    userInfoEncryptedResponseEncoding.setChoices(List.of(OIDCTokenEncryptionEncoding.values()));
                    fields.add(userInfoEncryptedResponseEncoding);
                    fields.add(new AjaxCheckBoxPanel("field", "jwtAccessToken", (IModel)new PropertyModel(clientAppTO, "jwtAccessToken")));
                    fields.add(new AjaxCheckBoxPanel("field", "bypassApprovalPrompt", (IModel)new PropertyModel(clientAppTO, "bypassApprovalPrompt")));
                    fields.add(new AjaxCheckBoxPanel("field", "generateRefreshToken", (IModel)new PropertyModel(clientAppTO, "generateRefreshToken")));
                    AjaxDropDownChoicePanel subjectType = new AjaxDropDownChoicePanel("field", "subjectType", (IModel)new PropertyModel(clientAppTO, "subjectType"), false);
                    subjectType.setChoices(List.of(OIDCSubjectType.values()));
                    fields.add(subjectType.addRequiredLabel().setEnabled(true));
                    AjaxDropDownChoicePanel applicationType = new AjaxDropDownChoicePanel("field", "applicationType", (IModel)new PropertyModel(clientAppTO, "applicationType"), false);
                    applicationType.setChoices(List.of(OIDCApplicationType.values()));
                    fields.add(applicationType.addRequiredLabel().setEnabled(true));
                    AjaxTextFieldPanel redirectUri = new AjaxTextFieldPanel("panel", "redirectUris", (IModel)new Model());
                    fields.add(new MultiFieldPanel.Builder((IModel)new PropertyModel(clientAppTO, "redirectUris")).build("field", "redirectUris", (FieldPanel)redirectUri));
                    fields.add(new AjaxPalettePanel.Builder().setName("supportedGrantTypes").build("field", (IModel)new PropertyModel(clientAppTO, "supportedGrantTypes"), (IModel)new ListModel(List.of(OIDCGrantType.values()))));
                    fields.add(new AjaxPalettePanel.Builder().setName("supportedResponseTypes").build("field", (IModel)new PropertyModel(clientAppTO, "supportedResponseTypes"), (IModel)new ListModel(List.of(OIDCResponseType.values()))));
                    AutoCompleteSettings scopesSettings = new AutoCompleteSettings();
                    scopesSettings.setShowCompleteListOnFocusGain(true);
                    scopesSettings.setShowListOnEmptyInput(true);
                    AjaxSearchFieldPanel scopes = new AjaxSearchFieldPanel("panel", "scopes", (IModel)new PropertyModel(clientAppTO, "scopes"), scopesSettings){
                        private static final long serialVersionUID = 7160878678968866138L;

                        protected Iterator<String> getChoices(String input) {
                            ArrayList<String> choices = new ArrayList<String>(OIDCScopeConstants.ALL_STANDARD_SCOPES);
                            choices.add("syncope");
                            return choices.iterator();
                        }
                    };
                    fields.add(new MultiFieldPanel.Builder((IModel)new PropertyModel(clientAppTO, "scopes")).build("field", "scopes", (FieldPanel)scopes));
                    AjaxTextFieldPanel logoutUri = new AjaxTextFieldPanel("field", "logoutUri", (IModel)new PropertyModel(clientAppTO, "logoutUri"), false);
                    logoutUri.addValidator((IValidator)new UrlValidator());
                    fields.add(logoutUri);
                    BinaryFieldPanel jwks = new BinaryFieldPanel("field", "jwks", (IModel)new Model<String>(){
                        private static final long serialVersionUID = 7666049400663637482L;

                        public String getObject() {
                            OIDCRPClientAppTO oidcRPCA = (OIDCRPClientAppTO)clientAppTO;
                            return StringUtils.isBlank((CharSequence)oidcRPCA.getJwks()) ? null : Base64.getEncoder().encodeToString(oidcRPCA.getJwks().getBytes(StandardCharsets.UTF_8));
                        }

                        public void setObject(String object) {
                            OIDCRPClientAppTO oidcRPCA = (OIDCRPClientAppTO)clientAppTO;
                            if (StringUtils.isBlank((CharSequence)object)) {
                                oidcRPCA.setJwks(null);
                            } else {
                                oidcRPCA.setJwks(new String(Base64.getDecoder().decode(object), StandardCharsets.UTF_8));
                            }
                        }
                    }, "application/json", "client-jwks");
                    fields.add(jwks);
                    AjaxTextFieldPanel jwksUri = new AjaxTextFieldPanel("field", "jwksUri", (IModel)new PropertyModel(clientAppTO, "jwksUri"), false);
                    jwksUri.addValidator((IValidator)new UrlValidator());
                    fields.add(jwksUri);
                    AjaxDropDownChoicePanel tokenEndpointAuthenticationMethod = new AjaxDropDownChoicePanel("field", "tokenEndpointAuthenticationMethod", (IModel)new PropertyModel(clientAppTO, "tokenEndpointAuthenticationMethod"), false);
                    tokenEndpointAuthenticationMethod.setChoices(List.of(OIDCClientAuthenticationMethod.values()));
                    fields.add(tokenEndpointAuthenticationMethod);
                    break;
                }
                case SAML2SP: {
                    AjaxTextFieldPanel entityId = new AjaxTextFieldPanel("field", "entityId", (IModel)new PropertyModel(clientAppTO, "entityId"), false);
                    fields.add(entityId.setRequired(true));
                    fields.add(new AjaxTextFieldPanel("field", "metadataLocation", (IModel)new PropertyModel(clientAppTO, "metadataLocation"), false).setRequired(true));
                    fields.add(new AjaxTextFieldPanel("field", "metadataSignatureLocation", (IModel)new PropertyModel(clientAppTO, "metadataSignatureLocation"), false));
                    fields.add(new AjaxCheckBoxPanel("field", "signAssertions", (IModel)new PropertyModel(clientAppTO, "signAssertions")));
                    fields.add(new AjaxCheckBoxPanel("field", "signResponses", (IModel)new PropertyModel(clientAppTO, "signResponses")));
                    fields.add(new AjaxCheckBoxPanel("field", "encryptionOptional", (IModel)new PropertyModel(clientAppTO, "encryptionOptional")));
                    fields.add(new AjaxCheckBoxPanel("field", "encryptAssertions", (IModel)new PropertyModel(clientAppTO, "encryptAssertions")));
                    fields.add(new AjaxTextFieldPanel("field", "requiredAuthenticationContextClass", (IModel)new PropertyModel(clientAppTO, "requiredAuthenticationContextClass"), false));
                    AjaxDropDownChoicePanel requiredNameIdFormat = new AjaxDropDownChoicePanel("field", "requiredNameIdFormat", (IModel)new PropertyModel(clientAppTO, "requiredNameIdFormat"), false);
                    requiredNameIdFormat.setChoices(List.of(SAML2SPNameId.values()));
                    requiredNameIdFormat.addRequiredLabel().setEnabled(true);
                    fields.add(requiredNameIdFormat);
                    fields.add(new AjaxNumberFieldPanel.Builder().min((Number)0).build("field", "skewAllowance", Integer.class, (IModel)new PropertyModel(clientAppTO, "skewAllowance")));
                    fields.add(new AjaxTextFieldPanel("field", "nameIdQualifier", (IModel)new PropertyModel(clientAppTO, "nameIdQualifier"), false));
                    AjaxTextFieldPanel assertionAudience = new AjaxTextFieldPanel("panel", "assertionAudience", (IModel)new Model());
                    assertionAudience.addValidator((IValidator)new UrlValidator());
                    fields.add(new MultiFieldPanel.Builder((IModel)new PropertyModel(clientAppTO, "assertionAudiences")).build("field", "assertionAudiences", (FieldPanel)assertionAudience));
                    fields.add(new AjaxTextFieldPanel("field", "serviceProviderNameIdQualifier", (IModel)new PropertyModel(clientAppTO, "serviceProviderNameIdQualifier"), false));
                    fields.add(new AjaxPalettePanel.Builder().setName("signingSignatureAlgorithms").build("field", (IModel)new PropertyModel(clientAppTO, "signingSignatureAlgorithms"), (IModel)new ListModel(List.of(XmlSecAlgorithm.values()))));
                    fields.add(new AjaxPalettePanel.Builder().setName("signingSignatureReferenceDigestMethods").build("field", (IModel)new PropertyModel(clientAppTO, "signingSignatureReferenceDigestMethods"), (IModel)new ListModel(List.of(XmlSecAlgorithm.values()))));
                    fields.add(new AjaxPalettePanel.Builder().setName("encryptionDataAlgorithms").build("field", (IModel)new PropertyModel(clientAppTO, "encryptionDataAlgorithms"), (IModel)new ListModel(List.of(XmlSecAlgorithm.values()))));
                    fields.add(new AjaxPalettePanel.Builder().setName("encryptionKeyAlgorithms").build("field", (IModel)new PropertyModel(clientAppTO, "encryptionKeyAlgorithms"), (IModel)new ListModel(List.of(XmlSecAlgorithm.values()))));
                    fields.add(new AjaxPalettePanel.Builder().setName("signingSignatureBlackListedAlgorithms").build("field", (IModel)new PropertyModel(clientAppTO, "signingSignatureBlackListedAlgorithms"), (IModel)new ListModel(List.of(XmlSecAlgorithm.values()))));
                    fields.add(new AjaxPalettePanel.Builder().setName("encryptionBlackListedAlgorithms").build("field", (IModel)new PropertyModel(clientAppTO, "encryptionBlackListedAlgorithms"), (IModel)new ListModel(List.of(XmlSecAlgorithm.values()))));
                    break;
                }
            }
            this.add(new Component[]{new ListView<Component>("fields", fields){
                private static final long serialVersionUID = -9180479401817023838L;

                protected void populateItem(ListItem<Component> item) {
                    item.add(new Component[]{(Component)item.getModelObject()});
                }
            }});
        }

        public void onSubmit(AjaxRequestTarget target) {
            try {
                if (this.clientAppTO.getKey() == null) {
                    this.this$0.clientAppRestClient.create(this.this$0.type, this.clientAppTO);
                } else {
                    this.this$0.clientAppRestClient.update(this.this$0.type, this.clientAppTO);
                }
                SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                this.modal.close((IPartialPageRequestHandler)target);
            }
            catch (Exception e) {
                LOG.error("While creating/updating clientApp", (Throwable)e);
                SyncopeConsoleSession.get().onException(e);
            }
            ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }
}

