/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class AtomicDouble
extends Number {
    private volatile long value;
    private static final AtomicLongFieldUpdater<AtomicDouble> VALUE_UPDATER = AtomicLongFieldUpdater.newUpdater(AtomicDouble.class, "value");

    public AtomicDouble() {
    }

    public AtomicDouble(double init) {
        this.value = Double.doubleToLongBits(init);
    }

    public double get() {
        return Double.longBitsToDouble(this.value);
    }

    public double addAndGet(double amount) {
        double d;
        double n;
        long next;
        long v;
        while (!VALUE_UPDATER.compareAndSet(this, v = this.value, next = Double.doubleToLongBits(n = (d = Double.longBitsToDouble(v)) + amount))) {
        }
        return n;
    }

    public double getAndAdd(double amount) {
        double d;
        double n;
        long next;
        long v;
        while (!VALUE_UPDATER.compareAndSet(this, v = this.value, next = Double.doubleToLongBits(n = (d = Double.longBitsToDouble(v)) + amount))) {
        }
        return d;
    }

    public double getAndSet(double amount) {
        long v = VALUE_UPDATER.getAndSet(this, Double.doubleToLongBits(amount));
        return Double.longBitsToDouble(v);
    }

    public boolean compareAndSet(double expect, double update) {
        long e = Double.doubleToLongBits(expect);
        long u = Double.doubleToLongBits(update);
        return VALUE_UPDATER.compareAndSet(this, e, u);
    }

    public void set(double amount) {
        this.value = Double.doubleToLongBits(amount);
    }

    private static boolean isLessThan(double v1, double v2) {
        return v1 < v2 || Double.isNaN(v2);
    }

    public void min(double v) {
        if (Double.isFinite(v)) {
            double min = this.get();
            while (AtomicDouble.isLessThan(v, min) && !this.compareAndSet(min, v)) {
                min = this.get();
            }
        }
    }

    private static boolean isGreaterThan(double v1, double v2) {
        return v1 > v2 || Double.isNaN(v2);
    }

    public void max(double v) {
        if (Double.isFinite(v)) {
            double max = this.get();
            while (AtomicDouble.isGreaterThan(v, max) && !this.compareAndSet(max, v)) {
                max = this.get();
            }
        }
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public float floatValue() {
        return (float)this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    public String toString() {
        return Double.toString(this.get());
    }
}

