/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldup.search;

import java.util.Objects;

public class LdUpFilter {
    protected final String nativeFilter;
    protected final String entryDN;

    public static LdUpFilter forEntryDN(String entryDN) {
        return new LdUpFilter(null, entryDN);
    }

    public static LdUpFilter forNativeFilter(String nativeFilter) {
        return new LdUpFilter(nativeFilter, null);
    }

    protected static String combine(String left, String right, char op) {
        if (left != null) {
            if (right != null) {
                StringBuilder builder = new StringBuilder();
                builder.append('(');
                builder.append(op);
                builder.append(left);
                builder.append(right);
                builder.append(')');
                return builder.toString();
            }
            return left;
        }
        return right;
    }

    protected LdUpFilter(String nativeFilter, String entryDN) {
        this.nativeFilter = nativeFilter;
        this.entryDN = entryDN;
    }

    public LdUpFilter withNativeFilter(String nativeFilter) {
        return new LdUpFilter(nativeFilter, this.entryDN);
    }

    public LdUpFilter and(LdUpFilter other) {
        if (this.entryDN == null || other.entryDN == null) {
            return new LdUpFilter(LdUpFilter.combine(this.nativeFilter, other.nativeFilter, '&'), this.entryDN == null ? other.entryDN : this.entryDN);
        }
        return null;
    }

    public LdUpFilter or(LdUpFilter other) {
        if (this.entryDN == null && other.entryDN == null) {
            return new LdUpFilter(LdUpFilter.combine(this.nativeFilter, other.nativeFilter, '|'), null);
        }
        return null;
    }

    public String getNativeFilter() {
        return this.nativeFilter;
    }

    public String getEntryDN() {
        return this.entryDN;
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + Objects.hashCode(this.nativeFilter);
        hash = 83 * hash + Objects.hashCode(this.entryDN);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LdUpFilter other = (LdUpFilter)obj;
        if (!Objects.equals(this.nativeFilter, other.nativeFilter)) {
            return false;
        }
        return Objects.equals(this.entryDN, other.entryDN);
    }

    public String toString() {
        return "LdUpFilter{nativeFilter=" + this.nativeFilter + ", entryDN=" + this.entryDN + "}";
    }
}

