/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.cache.CacheManager;
import org.springframework.cache.jcache.interceptor.JCacheOperationSource;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

final class JCacheOperationSourcePointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    @Nullable
    private JCacheOperationSource cacheOperationSource;

    public JCacheOperationSourcePointcut() {
        this.setClassFilter(new JCacheOperationSourceClassFilter());
    }

    public void setCacheOperationSource(@Nullable JCacheOperationSource cacheOperationSource) {
        this.cacheOperationSource = cacheOperationSource;
    }

    public boolean matches(Method method, Class<?> targetClass) {
        return this.cacheOperationSource == null || this.cacheOperationSource.hasCacheOperation(method, targetClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof JCacheOperationSourcePointcut)) return false;
        JCacheOperationSourcePointcut that = (JCacheOperationSourcePointcut)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.cacheOperationSource, (Object)that.cacheOperationSource)) return false;
        return true;
    }

    public int hashCode() {
        return JCacheOperationSourcePointcut.class.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + String.valueOf(this.cacheOperationSource);
    }

    private final class JCacheOperationSourceClassFilter
    implements ClassFilter {
        private JCacheOperationSourceClassFilter() {
        }

        public boolean matches(Class<?> clazz) {
            if (CacheManager.class.isAssignableFrom(clazz)) {
                return false;
            }
            return JCacheOperationSourcePointcut.this.cacheOperationSource == null || JCacheOperationSourcePointcut.this.cacheOperationSource.isCandidateClass(clazz);
        }

        @Nullable
        private JCacheOperationSource getCacheOperationSource() {
            return JCacheOperationSourcePointcut.this.cacheOperationSource;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof JCacheOperationSourceClassFilter)) return false;
            JCacheOperationSourceClassFilter that = (JCacheOperationSourceClassFilter)other;
            if (!ObjectUtils.nullSafeEquals((Object)this.getCacheOperationSource(), (Object)that.getCacheOperationSource())) return false;
            return true;
        }

        public int hashCode() {
            return JCacheOperationSourceClassFilter.class.hashCode();
        }

        public String toString() {
            return JCacheOperationSourceClassFilter.class.getName() + ": " + String.valueOf(this.getCacheOperationSource());
        }
    }
}

