/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.fi.util.function.CheckedConsumer;
import org.jooq.lambda.fi.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasReentrantLock {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasReentrantLock.class);
    private static final int LOCK_TIMEOUT_SECONDS = 3;
    private final ReentrantLock lock = new ReentrantLock(true);

    public boolean tryLock() {
        return (Boolean)FunctionUtils.doAndHandle(() -> this.lock.tryLock(3L, TimeUnit.SECONDS), e -> false).get();
    }

    public <T> T tryLock(CheckedSupplier<T> supplier) {
        if (this.tryLock()) {
            try {
                Object object = supplier.get();
                return (T)object;
            }
            catch (Throwable e) {
                LoggingUtils.error(LOGGER, e);
                throw new RuntimeException(e);
            }
            finally {
                this.unlock();
            }
        }
        return null;
    }

    public <T> void tryLock(CheckedConsumer<T> consumer) {
        if (this.tryLock()) {
            try {
                consumer.accept(null);
            }
            catch (Throwable e) {
                LoggingUtils.error(LOGGER, e);
                throw new RuntimeException(e);
            }
            finally {
                this.unlock();
            }
        }
    }

    public void unlock() {
        this.lock.unlock();
    }
}

