/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.util;

import de.agilecoders.wicket.webjars.util.IResourceStreamProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IFixedLocationResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderResourceStreamProvider
implements IResourceStreamProvider {
    private static final Logger LOG = LoggerFactory.getLogger((String)"wicket-webjars");
    private final ClassLoader[] classLoaders;

    public ClassLoaderResourceStreamProvider(ClassLoader ... classLoaders) {
        this.classLoaders = classLoaders;
    }

    @Override
    public IResourceStream newResourceStream(String path) {
        for (ClassLoader loader : this.classLoaders) {
            try {
                InputStream resource = loader.getResourceAsStream(path);
                if (resource == null) continue;
                return new InputStreamResourceStream(path, resource);
            }
            catch (RuntimeException e) {
                LOG.warn("can't load resource: {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    private static final class InputStreamResourceStream
    extends AbstractResourceStream
    implements IFixedLocationResourceStream {
        private final String path;
        private final InputStream inputStream;

        private InputStreamResourceStream(String path, InputStream inputStream) {
            this.path = path;
            this.inputStream = inputStream;
        }

        public String locationAsString() {
            return this.path;
        }

        public InputStream getInputStream() throws ResourceStreamNotFoundException {
            return this.inputStream;
        }

        public void close() throws IOException {
            IOUtils.closeQuietly((Closeable)this.inputStream);
        }
    }
}

