/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.pac4j.saml;

import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.syncope.common.rest.api.service.wa.WASAML2SPService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.metadata.keystore.BaseSAML2KeystoreGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WASAML2ClientKeystoreGenerator
extends BaseSAML2KeystoreGenerator {
    protected static final Logger LOG = LoggerFactory.getLogger(WASAML2ClientKeystoreGenerator.class);
    protected final WARestClient waRestClient;
    protected final SAML2Client saml2Client;

    public WASAML2ClientKeystoreGenerator(WARestClient waRestClient, SAML2Client saml2Client) {
        super(saml2Client.getConfiguration());
        this.waRestClient = waRestClient;
        this.saml2Client = saml2Client;
    }

    public boolean shouldGenerate() {
        try {
            Response response = ((WASAML2SPService)this.waRestClient.getService(WASAML2SPService.class)).getSAML2SPKeystore(this.saml2Client.getName());
            return response.getStatus() == Response.Status.NOT_FOUND.getStatusCode() || !response.hasEntity();
        }
        catch (Exception e) {
            LOG.error("While attempting to read if keystore is available for SP Entity {}", (Object)this.saml2Client.getName(), (Object)e);
            return true;
        }
    }

    protected void store(KeyStore ks, X509Certificate certificate, PrivateKey privateKey) throws Exception {
        String encodedKeystore;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            char[] password = this.saml2Configuration.getKeystorePassword().toCharArray();
            ks.store(out, password);
            out.flush();
            encodedKeystore = Base64.getEncoder().encodeToString(out.toByteArray());
            LOG.debug("Encoded keystore {}", (Object)encodedKeystore);
        }
        ((WASAML2SPService)this.waRestClient.getService(WASAML2SPService.class)).setSAML2SPKeystore(this.saml2Client.getName(), IOUtils.toInputStream((String)encodedKeystore, (Charset)StandardCharsets.UTF_8));
    }

    public InputStream retrieve() throws Exception {
        try {
            String encodedKeystore = (String)((WASAML2SPService)this.waRestClient.getService(WASAML2SPService.class)).getSAML2SPKeystore(this.saml2Client.getName()).readEntity(String.class);
            LOG.debug("Retrieved keystore {}", (Object)encodedKeystore);
            return new ByteArrayInputStream(Base64.getDecoder().decode(encodedKeystore));
        }
        catch (Exception e) {
            String message = "Unable to fetch SAML2 SP keystore for " + this.saml2Client.getName();
            LOG.error(message, (Throwable)e);
            throw new Exception(message, e);
        }
    }
}

